/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.indeed.proctor.common.ProctorRuleFunctions;
import com.indeed.proctor.common.ProctorUtils;
import com.indeed.proctor.common.el.LibraryFunctionMapperBuilder;
import com.indeed.proctor.common.el.MulticontextReadOnlyVariableMapper;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.el.ExpressionFactoryImpl;
import org.apache.log4j.Logger;
import org.apache.taglibs.standard.functions.Functions;

public class RuleEvaluator {
    private static final Logger LOGGER = Logger.getLogger(RuleEvaluator.class);
    static final FunctionMapper FUNCTION_MAPPER = RuleEvaluator.defaultFunctionMapperBuilder().build();
    static final ExpressionFactory EXPRESSION_FACTORY = new ExpressionFactoryImpl();
    @Nonnull
    final ExpressionFactory expressionFactory;
    @Nonnull
    final CompositeELResolver elResolver;
    @Nonnull
    private final Map<String, ValueExpression> testConstants;
    @Nonnull
    private final FunctionMapper functionMapper;

    RuleEvaluator(@Nonnull ExpressionFactory expressionFactory, @Nonnull FunctionMapper functionMapper, @Nonnull Map<String, Object> testConstantsMap) {
        this.expressionFactory = expressionFactory;
        this.functionMapper = functionMapper;
        this.elResolver = RuleEvaluator.constructStandardElResolver();
        this.testConstants = ProctorUtils.convertToValueExpressionMap(expressionFactory, testConstantsMap);
    }

    @Nonnull
    private static CompositeELResolver constructStandardElResolver() {
        CompositeELResolver elResolver = new CompositeELResolver();
        elResolver.add((ELResolver)new ArrayELResolver());
        elResolver.add((ELResolver)new ListELResolver());
        elResolver.add((ELResolver)new BeanELResolver());
        elResolver.add((ELResolver)new MapELResolver());
        return elResolver;
    }

    public static LibraryFunctionMapperBuilder defaultFunctionMapperBuilder() {
        LibraryFunctionMapperBuilder builder = new LibraryFunctionMapperBuilder().add("fn", Functions.class).add("proctor", ProctorRuleFunctions.class);
        return builder;
    }

    @Nonnull
    private ELContext createELContext(final @Nonnull VariableMapper variableMapper) {
        return new ELContext(){

            @Nonnull
            public ELResolver getELResolver() {
                return RuleEvaluator.this.elResolver;
            }

            @Nonnull
            public FunctionMapper getFunctionMapper() {
                return RuleEvaluator.this.functionMapper;
            }

            @Nonnull
            public VariableMapper getVariableMapper() {
                return variableMapper;
            }
        };
    }

    public boolean evaluateBooleanRule(@Nonnull String rule, @Nonnull Map<String, Object> values) throws IllegalArgumentException {
        if (CharMatcher.WHITESPACE.matchesAllOf((CharSequence)Strings.nullToEmpty((String)rule))) {
            return true;
        }
        if (!rule.startsWith("${") || !rule.endsWith("}")) {
            LOGGER.error((Object)("Invalid rule '" + rule + "'"));
            return false;
        }
        String bareRule = rule.substring(2, rule.length() - 1);
        if (CharMatcher.WHITESPACE.matchesAllOf((CharSequence)Strings.nullToEmpty((String)bareRule)) || "true".equalsIgnoreCase(bareRule)) {
            return true;
        }
        if ("false".equalsIgnoreCase(bareRule)) {
            return false;
        }
        Map<String, ValueExpression> localContext = ProctorUtils.convertToValueExpressionMap(this.expressionFactory, values);
        MulticontextReadOnlyVariableMapper variableMapper = new MulticontextReadOnlyVariableMapper(this.testConstants, localContext);
        ELContext elContext = this.createELContext(variableMapper);
        ValueExpression ve = this.expressionFactory.createValueExpression(elContext, rule, Boolean.class);
        Object result = ve.getValue(elContext);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new IllegalArgumentException("Received non-boolean return value: " + result.getClass().getCanonicalName() + " from rule " + rule);
    }
}

