/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.indeed.proctor.common.AbstractProctorLoader;
import com.indeed.proctor.common.FileProctorLoader;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.common.model.TestMatrixArtifact;
import com.indeed.util.varexport.Export;
import com.indeed.util.varexport.VarExporter;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.el.FunctionMapper;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class AbstractJsonProctorLoader
extends AbstractProctorLoader {
    private static final Logger LOGGER = Logger.getLogger(FileProctorLoader.class);
    @Nonnull
    private final ObjectMapper objectMapper = Serializers.lenient();
    @Nullable
    private String fileContents = null;

    public AbstractJsonProctorLoader(@Nonnull Class<?> cls, @Nonnull ProctorSpecification specification, @Nonnull FunctionMapper functionMapper) {
        super(cls, specification, functionMapper);
        ProctorLoaderDetail detailObject = new ProctorLoaderDetail();
        VarExporter.forNamespace((String)detailObject.getClass().getSimpleName()).export((Object)detailObject, "");
    }

    @Nullable
    protected TestMatrixArtifact loadJsonTestMatrix(@Nonnull Reader reader) throws IOException {
        int read;
        char[] buffer = new char[1024];
        StringBuilder sb = new StringBuilder();
        while ((read = reader.read(buffer)) != -1) {
            if (read <= 0) continue;
            sb.append(buffer, 0, read);
        }
        reader.close();
        String newContents = sb.toString();
        try {
            TestMatrixArtifact testMatrix = (TestMatrixArtifact)this.objectMapper.readValue(newContents, TestMatrixArtifact.class);
            if (testMatrix != null) {
                this.fileContents = newContents;
            }
            return testMatrix;
        }
        catch (JsonParseException e) {
            LOGGER.error((Object)("Unable to load test matrix from " + this.getSource()), (Throwable)e);
            throw e;
        }
        catch (JsonMappingException e) {
            LOGGER.error((Object)("Unable to load test matrix from " + this.getSource()), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOGGER.error((Object)("Unable to load test matrix from " + this.getSource()), (Throwable)e);
            throw e;
        }
    }

    @Nullable
    public String getFileContents() {
        return this.fileContents;
    }

    public class ProctorLoaderDetail {
        @Export(name="file-source")
        public String getFileSource() {
            return AbstractJsonProctorLoader.this.getSource();
        }

        @Nullable
        @Export(name="file-contents", doc="The file contents of a recent successful load. If the file contains invalid JSON, the file contents will not be set.")
        public String getLastFileContents() {
            return AbstractJsonProctorLoader.this.getFileContents();
        }
    }
}

