/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.indeed.proctor.common.PayloadSpecification;
import com.indeed.proctor.common.PayloadType;
import com.indeed.proctor.common.TestSpecification;
import com.indeed.proctor.common.model.Payload;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.common.model.TestDefinition;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class SpecificationGenerator {
    @Nonnull
    public TestSpecification generateSpecification(@Nonnull TestDefinition testDefinition) {
        TestSpecification testSpecification = new TestSpecification();
        ImmutableList testDefinitionBuckets = Ordering.from((Comparator)new Comparator<TestBucket>(){

            @Override
            public int compare(TestBucket lhs, TestBucket rhs) {
                return Ints.compare((int)lhs.getValue(), (int)rhs.getValue());
            }
        }).immutableSortedCopy(testDefinition.getBuckets());
        int fallbackValue = -1;
        if (!testDefinitionBuckets.isEmpty()) {
            fallbackValue = ((TestBucket)testDefinitionBuckets.get(0)).getValue();
            Optional<PayloadSpecification> specOpt = SpecificationGenerator.generatePayloadSpecification(testDefinitionBuckets.stream().map(TestBucket::getPayload).filter(Objects::nonNull).collect(Collectors.toList()));
            specOpt.ifPresent(testSpecification::setPayload);
        }
        LinkedHashMap buckets = Maps.newLinkedHashMap();
        for (TestBucket bucket : testDefinitionBuckets) {
            buckets.put(bucket.getName(), bucket.getValue());
        }
        testSpecification.setBuckets(buckets);
        testSpecification.setDescription(testDefinition.getDescription());
        testSpecification.setFallbackValue(fallbackValue);
        return testSpecification;
    }

    @Nonnull
    @VisibleForTesting
    static Optional<PayloadSpecification> generatePayloadSpecification(List<Payload> payloads) {
        return SpecificationGenerator.determinePayloadTypeFromPayloads(payloads).map(payloadType -> {
            PayloadSpecification payloadSpecification = new PayloadSpecification();
            payloadSpecification.setType(payloadType.payloadTypeName);
            if (payloadType.equals((Object)PayloadType.MAP)) {
                SpecificationGenerator.generateMapPayloadSchema(payloads).ifPresent(schema -> payloadSpecification.setSchema(schema.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PayloadType)((Object)((Object)((Object)((Object)e.getValue()))))).payloadTypeName))));
            }
            return payloadSpecification;
        });
    }

    @Nonnull
    private static Optional<PayloadType> determinePayloadTypeFromPayloads(@Nonnull List<Payload> testDefinitionBuckets) {
        List types = testDefinitionBuckets.stream().map(Payload::fetchPayloadType).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList());
        if (types.size() > 1) {
            throw new IllegalArgumentException("Payloads not compatible: " + types);
        }
        if (types.size() == 1) {
            return Optional.of((PayloadType)((Object)types.get(0)));
        }
        return Optional.empty();
    }

    @Nonnull
    private static Optional<Map<String, PayloadType>> generateMapPayloadSchema(@Nonnull List<Payload> payloads) {
        if (payloads.isEmpty()) {
            return Optional.empty();
        }
        HashSet emptyListValuePayloadKeys = new HashSet();
        List<Map<String, PayloadType>> schemas = payloads.stream().map(p -> SpecificationGenerator.inferSchemaForPayload(p, emptyListValuePayloadKeys)).collect(Collectors.toList());
        Map<String, PayloadType> resultPayloadMapSchema = SpecificationGenerator.mergeSchemas(schemas);
        for (String key : emptyListValuePayloadKeys) {
            if (resultPayloadMapSchema.containsKey(key) && resultPayloadMapSchema.get(key).isArrayType()) continue;
            throw new IllegalArgumentException("Cannot infer map schema type for key " + key);
        }
        return Optional.ofNullable(resultPayloadMapSchema.isEmpty() ? null : resultPayloadMapSchema);
    }

    @Nonnull
    private static Map<String, PayloadType> mergeSchemas(@Nonnull List<Map<String, PayloadType>> schemas) {
        HashMap<String, PayloadType> resultPayloadMapSchema = new HashMap<String, PayloadType>();
        ImmutableList NUMBER_TYPES = ImmutableList.of((Object)((Object)PayloadType.LONG_VALUE), (Object)((Object)PayloadType.DOUBLE_VALUE));
        ImmutableList NUMBER_ARRAY_TYPES = ImmutableList.of((Object)((Object)PayloadType.LONG_ARRAY), (Object)((Object)PayloadType.DOUBLE_ARRAY));
        for (Map<String, PayloadType> loopPayloadMapSchema : schemas) {
            for (Map.Entry<String, PayloadType> entry : loopPayloadMapSchema.entrySet()) {
                resultPayloadMapSchema.compute(entry.getKey(), (arg_0, arg_1) -> SpecificationGenerator.lambda$mergeSchemas$4(entry, (List)NUMBER_TYPES, (List)NUMBER_ARRAY_TYPES, arg_0, arg_1));
            }
        }
        return resultPayloadMapSchema;
    }

    private static Map<String, PayloadType> inferSchemaForPayload(@Nonnull Payload payload, @Nonnull Set<String> emptyListValuePayloadKeys) {
        Preconditions.checkState((payload.fetchPayloadType().isPresent() && payload.fetchPayloadType().get().equals((Object)PayloadType.MAP) ? 1 : 0) != 0, (Object)("Bug, method called with non-Map payload " + payload.fetchPayloadType()));
        HashMap<String, PayloadType> loopPayloadMapSchema = new HashMap<String, PayloadType>();
        Map<String, Object> payloadMap = payload.getMap();
        if (payloadMap != null) {
            for (Map.Entry<String, Object> entry : payloadMap.entrySet()) {
                if (!(entry.getValue() instanceof List) || !((List)entry.getValue()).isEmpty()) {
                    loopPayloadMapSchema.put(entry.getKey(), PayloadType.payloadTypeForValue(entry.getValue()));
                    continue;
                }
                emptyListValuePayloadKeys.add(entry.getKey());
            }
        }
        return loopPayloadMapSchema;
    }

    private static /* synthetic */ PayloadType lambda$mergeSchemas$4(Map.Entry entry, List NUMBER_TYPES, List NUMBER_ARRAY_TYPES, String k, PayloadType v) {
        if (v != null && !v.equals(entry.getValue())) {
            if (NUMBER_TYPES.contains((Object)v) && NUMBER_TYPES.contains(entry.getValue())) {
                return PayloadType.DOUBLE_VALUE;
            }
            if (NUMBER_ARRAY_TYPES.contains((Object)v) && NUMBER_ARRAY_TYPES.contains(entry.getValue())) {
                return PayloadType.DOUBLE_ARRAY;
            }
            throw new IllegalArgumentException("Ambiguous map schema for key " + k + ": " + (Object)((Object)v) + " != " + entry.getValue());
        }
        return v == null ? (PayloadType)((Object)entry.getValue()) : v;
    }
}

