/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.gen;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.PayloadType;
import com.indeed.proctor.consumer.gen.CodeGenException;
import com.indeed.proctor.consumer.gen.TestGroupsGenerator;
import java.util.HashMap;
import java.util.Map;

public class TestGroupsJavascriptGenerator
extends TestGroupsGenerator {
    public void generate(String input, String target, String packageName, String groupsClass, boolean useClosure) throws CodeGenException {
        String templatePath = "/com/indeed/proctor/consumer/ant/";
        String jsTemplateName = "groups-js.ftl";
        String fileExtension = ".js";
        HashMap baseContext = Maps.newHashMap();
        baseContext.put("groupsClassName", groupsClass);
        baseContext.put("useClosure", useClosure);
        if (!Strings.isNullOrEmpty((String)packageName)) {
            this.generate(input, target, baseContext, packageName, groupsClass, "/com/indeed/proctor/consumer/ant/", "groups-js.ftl", ".js");
        }
    }

    @Override
    protected void addPayloadToTestDef(Map<String, Object> testDef, PayloadType specifiedPayloadType) {
        testDef.put("payloadJavascriptType", specifiedPayloadType.javascriptTypeName);
        testDef.put("payloadDefaultValue", specifiedPayloadType.getDefaultJavascriptValue());
    }

    public static void main(String[] args) throws CodeGenException {
        if (args.length != 5) {
            System.err.println("java " + TestGroupsJavascriptGenerator.class.getCanonicalName() + " input.json outputDirectory packageName groupsClassName useClosure");
            System.exit(-4);
        }
        TestGroupsJavascriptGenerator generator = new TestGroupsJavascriptGenerator();
        String input = args[0];
        String target = args[1];
        String packageName = args[2];
        String groupsClass = args[3];
        boolean useClosure = Boolean.parseBoolean(args[4]);
        generator.generate(input, target, packageName, groupsClass, useClosure);
    }
}

