/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.gen.ant;

import com.google.common.base.Strings;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.ProctorUtils;
import com.indeed.proctor.consumer.gen.CodeGenException;
import com.indeed.proctor.consumer.gen.TestGroupsGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.LogLevel;

public abstract class TestGroupsGeneratorTask
extends Task {
    protected static final Logger LOGGER = Logger.getLogger(TestGroupsGeneratorTask.class);
    private static final int SLEEP_TIME_FOR_WARNING = 3;
    private static final String DYNAMIC_FILTERS_MIGRATION_URL = "https://github.com/indeedeng/proctor/issues/47";
    protected String input;
    protected String target;
    protected String packageName;
    protected String groupsClass;
    protected String specificationOutput;

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getGroupsClass() {
        return this.groupsClass;
    }

    public void setGroupsClass(String groupsClass) {
        this.groupsClass = groupsClass;
    }

    public String getSpecificationOutput() {
        return this.specificationOutput;
    }

    public void setSpecificationOutput(String specificationOutput) {
        this.specificationOutput = specificationOutput;
    }

    protected ProctorSpecification mergePartialSpecifications(List<File> files) throws CodeGenException {
        if (files == null || files.size() == 0) {
            throw new CodeGenException("No specifications file input");
        }
        if (Strings.isNullOrEmpty((String)this.getSpecificationOutput())) {
            throw new CodeGenException("`specificationOutput` is not given");
        }
        new File(this.specificationOutput.substring(0, this.specificationOutput.lastIndexOf(File.separator))).mkdirs();
        File specificationOutputFile = new File(this.specificationOutput);
        return TestGroupsGenerator.makeTotalSpecification(files, (String)specificationOutputFile.getParent(), (String)specificationOutputFile.getName());
    }

    public void execute() throws BuildException {
        ProctorSpecification specification;
        if (this.input == null) {
            throw new BuildException("Undefined input files for code generation from specification");
        }
        if (this.target == null) {
            throw new BuildException("Undefined target directory for code generation from specification");
        }
        String[] inputs = this.input.split(",");
        if (inputs.length == 0) {
            LOGGER.error((Object)"input shouldn't be empty");
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        boolean isSingleSpecificationFile = true;
        for (String input : inputs) {
            File inputFile = new File(input.trim());
            if (inputFile == null) {
                LOGGER.error((Object)"input not substituted with configured value");
                return;
            }
            if (inputFile.isDirectory()) {
                files.addAll(Arrays.asList(inputFile.listFiles()));
                isSingleSpecificationFile = false;
                continue;
            }
            files.add(inputFile);
        }
        if (isSingleSpecificationFile) {
            specification = ProctorUtils.readSpecification((File)new File(this.input));
        } else {
            try {
                specification = this.mergePartialSpecifications(files);
            }
            catch (CodeGenException e) {
                throw new BuildException("Unable to generate total specification for inputs " + inputs + " : " + e.getMessage(), (Throwable)e);
            }
        }
        this.validateSpecification(specification);
        try {
            this.generateSourceFiles(specification);
        }
        catch (CodeGenException e) {
            throw new BuildException("Unable to generate source file: " + e.getMessage(), (Throwable)e);
        }
    }

    private void validateSpecification(ProctorSpecification specification) {
        boolean hasDuplicatedFilters = specification.getDynamicFilters().asCollection().stream().anyMatch(filter -> filter.getClass().isAnnotationPresent(Deprecated.class));
        if (hasDuplicatedFilters) {
            this.log(String.join((CharSequence)"\n", "=================================================================================", "Warning: Proctor detected this application is using deprecated dynamic filters.", "Please migrate to meta tags based filters.", "See https://github.com/indeedeng/proctor/issues/47 for details.", "", "Sleeping 3 seconds", "================================================================================="), LogLevel.WARN.getLevel());
        }
    }

    protected abstract void generateSourceFiles(ProctorSpecification var1) throws CodeGenException;
}

