/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDClientException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.text.NumberFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class NonBlockingStatsDClient
implements StatsDClient {
    private static final StatsDClientErrorHandler NO_OP_HANDLER = new StatsDClientErrorHandler(){

        @Override
        public void handle(Exception e) {
        }
    };
    private static final NumberFormat FORMAT = NumberFormat.getInstance();
    private final String prefix;
    private final DatagramSocket clientSocket;
    private final StatsDClientErrorHandler handler;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        final ThreadFactory delegate = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread result = this.delegate.newThread(r);
            result.setName("StatsD-" + result.getName());
            return result;
        }
    });

    public NonBlockingStatsDClient(String prefix, String hostname, int port) throws StatsDClientException {
        this(prefix, hostname, port, NO_OP_HANDLER);
    }

    public NonBlockingStatsDClient(String prefix, String hostname, int port, StatsDClientErrorHandler errorHandler) throws StatsDClientException {
        this.prefix = prefix != null && prefix.length() > 0 ? String.format("%s.", prefix) : "";
        this.handler = errorHandler;
        try {
            this.clientSocket = new DatagramSocket();
            this.clientSocket.connect(new InetSocketAddress(hostname, port));
        }
        catch (Exception e) {
            throw new StatsDClientException("Failed to start StatsD client", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.handler.handle(e);
        }
        finally {
            if (this.clientSocket != null) {
                this.clientSocket.close();
            }
        }
    }

    String tagString(String[] tags) {
        if (tags == null || tags.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("|#");
        for (int n = tags.length - 1; n >= 0; --n) {
            sb.append(tags[n]);
            if (n <= 0) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public void count(String aspect, int delta, String[] tags) {
        this.send(String.format("%s%s:%d|c%s", this.prefix, aspect, delta, this.tagString(tags)));
    }

    @Override
    public void count(String aspect, int delta) {
        this.send(String.format("%s%s:%d|c", this.prefix, aspect, delta));
    }

    @Override
    public void incrementCounter(String aspect, String[] tags) {
        this.count(aspect, 1, tags);
    }

    @Override
    public void incrementCounter(String aspect) {
        this.count(aspect, 1);
    }

    @Override
    public void increment(String aspect, String[] tags) {
        this.incrementCounter(aspect, tags);
    }

    @Override
    public void increment(String aspect) {
        this.incrementCounter(aspect);
    }

    @Override
    public void decrementCounter(String aspect, String[] tags) {
        this.count(aspect, -1, tags);
    }

    @Override
    public void decrementCounter(String aspect) {
        this.count(aspect, -1);
    }

    @Override
    public void decrement(String aspect, String[] tags) {
        this.decrementCounter(aspect, tags);
    }

    @Override
    public void decrement(String aspect) {
        this.decrementCounter(aspect);
    }

    @Override
    public void recordGaugeValue(String aspect, double value, String[] tags) {
        this.send(String.format("%s%s:%s|g%s", this.prefix, aspect, FORMAT.format(value), this.tagString(tags)));
    }

    @Override
    public void recordGaugeValue(String aspect, double value) {
        this.send(String.format("%s%s:%s|g", this.prefix, aspect, FORMAT.format(value)));
    }

    @Override
    public void gauge(String aspect, double value, String[] tags) {
        this.recordGaugeValue(aspect, value, tags);
    }

    @Override
    public void gauge(String aspect, double value) {
        this.recordGaugeValue(aspect, value);
    }

    @Override
    public void recordGaugeValue(String aspect, int value, String[] tags) {
        this.send(String.format("%s%s:%d|g%s", this.prefix, aspect, value, this.tagString(tags)));
    }

    @Override
    public void recordGaugeValue(String aspect, int value) {
        this.send(String.format("%s%s:%d|g", this.prefix, aspect, value));
    }

    @Override
    public void gauge(String aspect, int value, String[] tags) {
        this.recordGaugeValue(aspect, value, tags);
    }

    @Override
    public void gauge(String aspect, int value) {
        this.recordGaugeValue(aspect, value);
    }

    @Override
    public void recordExecutionTime(String aspect, int timeInMs, String[] tags) {
        this.send(String.format("%s%s:%d|ms%s", this.prefix, aspect, timeInMs, this.tagString(tags)));
    }

    @Override
    public void recordExecutionTime(String aspect, int timeInMs) {
        this.send(String.format("%s%s:%d|ms", this.prefix, aspect, timeInMs));
    }

    @Override
    public void time(String aspect, int value, String[] tags) {
        this.recordExecutionTime(aspect, value, tags);
    }

    @Override
    public void time(String aspect, int value) {
        this.recordExecutionTime(aspect, value);
    }

    @Override
    public void recordHistogramValue(String aspect, double value, String[] tags) {
        this.send(String.format("%s%s:%s|h%s", this.prefix, aspect, FORMAT.format(value), this.tagString(tags)));
    }

    @Override
    public void recordHistogramValue(String aspect, double value) {
        this.send(String.format("%s%s:%s|h", this.prefix, aspect, FORMAT.format(value)));
    }

    @Override
    public void histogram(String aspect, double value, String[] tags) {
        this.recordHistogramValue(aspect, value, tags);
    }

    @Override
    public void histogram(String aspect, double value) {
        this.recordHistogramValue(aspect, value);
    }

    @Override
    public void recordHistogramValue(String aspect, int value, String[] tags) {
        this.send(String.format("%s%s:%d|h%s", this.prefix, aspect, value, this.tagString(tags)));
    }

    @Override
    public void recordHistogramValue(String aspect, int value) {
        this.send(String.format("%s%s:%d|h", this.prefix, aspect, value));
    }

    @Override
    public void histogram(String aspect, int value, String[] tags) {
        this.recordHistogramValue(aspect, value, tags);
    }

    @Override
    public void histogram(String aspect, int value) {
        this.recordHistogramValue(aspect, value);
    }

    private void send(final String message) {
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    NonBlockingStatsDClient.this.blockingSend(message);
                }
            });
        }
        catch (Exception e) {
            this.handler.handle(e);
        }
    }

    private void blockingSend(String message) {
        try {
            byte[] sendData = message.getBytes();
            DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length);
            this.clientSocket.send(sendPacket);
        }
        catch (Exception e) {
            this.handler.handle(e);
        }
    }

    static {
        FORMAT.setGroupingUsed(false);
        FORMAT.setMaximumFractionDigits(6);
    }
}

