/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.core;

import com.impetus.dao.utils.JsonUtil;
import com.impetus.dao.utils.PropertyReader;
import com.impetus.kundera.KunderaException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceService {
    private static Logger LOGGER = LoggerFactory.getLogger(PersistenceService.class);

    public static synchronized EntityManager getEM(EntityManagerFactory emf, String propertiesPath, String clazzName) {
        HashMap clientProperties = new HashMap();
        Map<String, Map<String, String>> entityConfigurations = Collections.synchronizedMap(new HashMap());
        PersistenceService.loadClientProperties(propertiesPath, clazzName, clientProperties, entityConfigurations);
        if (emf == null) {
            StringBuilder puNames = new StringBuilder();
            for (Map.Entry<String, Map<String, String>> entry : entityConfigurations.entrySet()) {
                if (entry.getValue().get("kundera.pu") == null) continue;
                puNames.append(entry.getValue().get("kundera.pu"));
                puNames.append(",");
            }
            if (puNames.length() > 0) {
                puNames.deleteCharAt(puNames.length() - 1);
            }
            try {
                emf = puNames.toString().isEmpty() ? Persistence.createEntityManagerFactory((String)"testPU", entityConfigurations.get(clazzName)) : Persistence.createEntityManagerFactory((String)puNames.toString());
            }
            catch (Exception e) {
                LOGGER.error("Unable to create Entity Manager Factory. Caused By: ", (Throwable)e);
                throw new KunderaException("Unable to create Entity Manager Factory. Caused By: ", (Throwable)e);
            }
        }
        return emf.createEntityManager();
    }

    private static void loadClientProperties(String propertiesPath, String clazzName, Map<?, Map<String, String>> clientProperties, Map<String, Map<String, String>> entityConfigurations) {
        InputStream inputStream = PropertyReader.class.getClassLoader().getResourceAsStream(propertiesPath);
        clientProperties = JsonUtil.readJson(inputStream, Map.class);
        if (clientProperties != null) {
            if (clientProperties.get("all") != null) {
                entityConfigurations.put(clazzName, (Map<String, String>)clientProperties.get("all"));
            } else {
                for (Object key : clientProperties.keySet()) {
                    if (((String)key).indexOf(44) > 0) {
                        StringTokenizer tokenizer = new StringTokenizer((String)key, ",");
                        while (tokenizer.hasMoreElements()) {
                            String token = tokenizer.nextToken();
                            entityConfigurations.put(token, (Map<String, String>)clientProperties.get(key));
                        }
                        continue;
                    }
                    entityConfigurations.put((String)key, (Map<String, String>)clientProperties.get(key));
                }
            }
        }
    }
}

