/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.common.exceptions;

import com.igormaznitsa.meta.common.utils.TimeGuard;
import javax.annotation.Nonnull;

public class TimeViolationError
extends AssertionError {
    private static final long serialVersionUID = 9175073973098827533L;
    private final long detectedTimeInMilliseconds;
    private final TimeGuard.TimeData item;

    public TimeViolationError(long detectedTimeInMilliseconds, @Nonnull TimeGuard.TimeData item) {
        super((Object)item.getAlertMessage());
        this.detectedTimeInMilliseconds = detectedTimeInMilliseconds;
        this.item = item;
    }

    public long getDetectedViolationInMilliseconds() {
        return this.detectedTimeInMilliseconds - this.item.getMaxAllowedDelayInMilliseconds();
    }

    public long getDetectedTimeInMilliseconds() {
        return this.detectedTimeInMilliseconds;
    }

    @Nonnull
    public TimeGuard.TimeData getData() {
        return this.item;
    }
}

