/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta;

import javax.annotation.Nonnull;

public enum Complexity {
    CONSTANT("O(1)"),
    INVERSE_ACKERMANN("O(a(n))"),
    ITERATED_LOGARITHMIC("O(log* n)"),
    LOG_LOGARITHMIC("O(log log n)"),
    LOGARITHMIC("O(log n)"),
    POLYLOGARITHMIC("poly(log n)"),
    FRACTIONAL_POWER("O(n^c)"),
    LINEAR("O(n)"),
    N_LOG_STAR_N("O(n log* n)"),
    LINEARITHMIC("O(n log n)"),
    QUADRATIC("O(n^2)"),
    CUBIC("O(n^3)"),
    POLYNOMIAL("poly(n)"),
    QUASI_POLYNOMIAL("2^poly(log n)"),
    SUB_EXPONENTIAL("O(2^n^e)"),
    EXPONENTIAL("2^O(n)"),
    FACTORIAL("O(n!)"),
    DOUBLE_EXPONENTIAL("2^2^poly(n)");

    private final String formula;

    private Complexity(String formula) {
        this.formula = formula;
    }

    @Nonnull
    public String getFormula() {
        return this.formula;
    }

    @Nonnull
    public String toString() {
        return this.formula;
    }
}

