/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.utils;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.web.util.UriComponentsBuilder;

public final class PaginationUtil {
    private static final String QUERY_GET_PARAM = "&query=";
    private static final String TYPEKEY_GET_PARAM = "&typeKey=";
    private static final String IDS_GET_PARAM = "&ids=";
    private static final String EMBED_GET_PARAM = "&embed=";

    public static HttpHeaders generatePaginationHttpHeaders(Page page, String baseUrl) {
        return PaginationUtil.generatePagination("", page, baseUrl);
    }

    public static HttpHeaders generateByIdsPaginationHttpHeaders(Set<Long> ids, Set<String> embed, Page page, String baseUrl) {
        String escapedIds = URLEncoder.encode(Objects.toString(StringUtils.join(ids, (String)","), ""), StandardCharsets.UTF_8);
        String escapedEmbed = URLEncoder.encode(Objects.toString(StringUtils.join(embed, (String)","), ""), StandardCharsets.UTF_8);
        String queryString = IDS_GET_PARAM + escapedIds + EMBED_GET_PARAM + escapedEmbed;
        return PaginationUtil.generatePagination(queryString, page, baseUrl);
    }

    private static String generateUri(String baseUrl, int page, int size) {
        return UriComponentsBuilder.fromUriString((String)baseUrl).queryParam("page", new Object[]{page}).queryParam("size", new Object[]{size}).toUriString();
    }

    public static HttpHeaders generateSearchPaginationHttpHeaders(String query, Page page, String baseUrl) {
        String escapedQuery = URLEncoder.encode(Objects.toString(query, ""), StandardCharsets.UTF_8);
        String queryString = QUERY_GET_PARAM + escapedQuery;
        return PaginationUtil.generatePagination(queryString, page, baseUrl);
    }

    public static HttpHeaders generateSearchByTypeKeyPaginationHttpHeaders(String typeKey, String query, Page page, String baseUrl) {
        String escapedTypeKey = URLEncoder.encode(Objects.toString(typeKey, ""), StandardCharsets.UTF_8);
        String escapedQuery = URLEncoder.encode(Objects.toString(query, ""), StandardCharsets.UTF_8);
        String queryString = TYPEKEY_GET_PARAM + escapedTypeKey + QUERY_GET_PARAM + escapedQuery;
        return PaginationUtil.generatePagination(queryString, page, baseUrl);
    }

    private static HttpHeaders generatePagination(String query, Page page, String baseUrl) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Total-Count", Long.toString(page.getTotalElements()));
        Object link = "";
        if (page.getNumber() + 1 < page.getTotalPages()) {
            link = "<" + PaginationUtil.generateUri(baseUrl, page.getNumber() + 1, page.getSize()) + query + ">; rel=\"next\",";
        }
        if (page.getNumber() > 0) {
            link = (String)link + "<" + PaginationUtil.generateUri(baseUrl, page.getNumber() - 1, page.getSize()) + query + ">; rel=\"prev\",";
        }
        int lastPage = 0;
        if (page.getTotalPages() > 0) {
            lastPage = page.getTotalPages() - 1;
        }
        link = (String)link + "<" + PaginationUtil.generateUri(baseUrl, lastPage, page.getSize()) + query + ">; rel=\"last\",";
        link = (String)link + "<" + PaginationUtil.generateUri(baseUrl, 0, page.getSize()) + query + ">; rel=\"first\"";
        headers.add("Link", (String)link);
        return headers;
    }

    private PaginationUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

