/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.icthh.xm.commons.domain.FunctionResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public final class ModelAndViewUtils {
    private static final Logger log = LoggerFactory.getLogger(ModelAndViewUtils.class);
    public static final String MVC_FUNC_RESULT = "modelAndView";
    private static final ObjectMapper mapper = new ObjectMapper();

    public static ModelAndView getMvcResult(FunctionResult result) {
        if (result == null) {
            return null;
        }
        ModelAndView modelAndView = result.getModelAndView();
        if (modelAndView == null) {
            Map dataMap = (Map)mapper.convertValue(result.getData(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            log.warn("Context did not contain {} or type (ModelAndView) mismatch, present keys {}", (Object)MVC_FUNC_RESULT, dataMap.keySet());
        }
        return modelAndView;
    }

    private ModelAndViewUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

