/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.OsgiPropertyUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TimestampUtils {
    protected static final long startTime;
    static final long serialVersionUID = 1026694419702351557L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeTimeToFile(File file, long timestamp) {
        FileWriter fstream;
        BufferedWriter out;
        String stamp;
        block6: {
            if (file == null) {
                return;
            }
            stamp = Long.toString(timestamp);
            out = null;
            fstream = null;
            if (FileUtils.ensureDirExists(file.getParentFile())) break block6;
            if (TimestampUtils.tryToClose(out)) return;
            TimestampUtils.tryToClose(fstream);
            return;
        }
        try {
            fstream = new FileWriter(file);
            out = new BufferedWriter(fstream);
            out.write(stamp, 0, stamp.length());
        }
        catch (IOException iOException) {
            try {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.kernel.service.utils.TimestampUtils", (String)"59", null, (Object[])new Object[]{file, timestamp});
            }
            catch (Throwable throwable) {
                if (TimestampUtils.tryToClose(out)) throw throwable;
                TimestampUtils.tryToClose(fstream);
                throw throwable;
            }
            if (TimestampUtils.tryToClose(out)) return;
            TimestampUtils.tryToClose(fstream);
            return;
        }
        if (TimestampUtils.tryToClose(out)) return;
        TimestampUtils.tryToClose(fstream);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={FileNotFoundException.class, NumberFormatException.class})
    public static long readTimeFromFile(File file) {
        long timestamp = 0L;
        FileReader fstream = null;
        BufferedReader in = null;
        try {
            fstream = new FileReader(file);
            in = new BufferedReader(fstream);
            timestamp = new Long(in.readLine());
        }
        catch (FileNotFoundException e) {
        }
        catch (NumberFormatException e) {
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.kernel.service.utils.TimestampUtils", (String)"81", null, (Object[])new Object[]{file});
        }
        finally {
            if (!TimestampUtils.tryToClose(in)) {
                TimestampUtils.tryToClose(fstream);
            }
        }
        return timestamp;
    }

    public static void auditElapsedTime(TraceComponent callingTc, String msgKey) {
        if (callingTc.isAuditEnabled()) {
            Tr.audit((TraceComponent)callingTc, (String)msgKey, (Object[])new Object[]{TimestampUtils.getElapsedTime()});
        }
    }

    public static String getElapsedTime() {
        return TimestampUtils.getElapsedTime(startTime);
    }

    @Deprecated
    public static String getElapsedTime(long startTime) {
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        return TimestampUtils.getElapsedTimeAsStringFromMilliInterval(elapsedTime);
    }

    static String getElapsedTimeAsStringFromMilliInterval(long elapsedTime) {
        return String.format("%.3f", (double)elapsedTime / 1000.0);
    }

    public static String getElapsedTimeNanos(long startTime) {
        long endTime = System.nanoTime();
        long elapsedTime = (endTime - startTime) / 1000000L;
        return TimestampUtils.getElapsedTimeAsStringFromMilliInterval(elapsedTime);
    }

    @FFDCIgnore(value={IOException.class})
    private static boolean tryToClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TimestampUtils.class);
        long start = OsgiPropertyUtils.getLong("kernel.launch.time", 0L);
        if (start == 0L) {
            start = System.currentTimeMillis();
        }
        startTime = start;
    }
}

