/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.MalformedLocationException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PathUtils {
    private static final boolean isWindows;
    static final Pattern ABSOLUTE_URI;
    private static boolean IS_POSSIBLY_CASE_INSENSITIVE;
    private static String FILE_NAME_RESTRICTED_CHARS;
    public static final Comparator<String> PATH_COMPARATOR;
    static final long serialVersionUID = -2306779740046162839L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPossiblyCaseInsensitive() {
        BundleContext ctx;
        File caseSensitiveFile = null;
        Bundle bundle = FrameworkUtil.getBundle(PathUtils.class);
        if (bundle != null && (ctx = bundle.getBundleContext()) != null && (caseSensitiveFile = ctx.getDataFile("caseSensitive")) != null && (caseSensitiveFile.delete() || !caseSensitiveFile.exists())) {
            try {
                if (caseSensitiveFile.createNewFile()) {
                    boolean bl = caseSensitiveFile.getCanonicalFile().equals(new File(caseSensitiveFile.getParentFile(), "CASEsENSITIVE").getCanonicalFile());
                    return bl;
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.kernel.service.utils.PathUtils", (String)"126", null, (Object[])new Object[0]);
            }
            finally {
                caseSensitiveFile.delete();
            }
        }
        return true;
    }

    @Trivial
    public static String slashify(String filePath) {
        return filePath.replace('\\', '/');
    }

    @Trivial
    public static String normalizeDescendentPath(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        if ((path = PathUtils.normalizeRelative(path)).startsWith("..")) {
            throw new MalformedLocationException("Can not reference \"..\" when creating a descendant (path=" + path + ")");
        }
        return path;
    }

    @Trivial
    public static String normalizeRelative(String relativePath) {
        if (PathUtils.pathIsAbsolute(relativePath = PathUtils.normalize(relativePath))) {
            throw new MalformedLocationException("path must be relative (path=" + relativePath + ")");
        }
        return relativePath;
    }

    @Trivial
    public static boolean pathIsAbsolute(String normalizedPath) {
        if (normalizedPath.length() > 0 && normalizedPath.charAt(0) == '/') {
            return true;
        }
        if (PathUtils.isSymbol(normalizedPath)) {
            return true;
        }
        if (normalizedPath.contains(":")) {
            if (normalizedPath.length() > 3 && normalizedPath.charAt(1) == ':' && normalizedPath.charAt(2) == '/') {
                return true;
            }
            Matcher m = ABSOLUTE_URI.matcher(normalizedPath);
            if (m.matches()) {
                return true;
            }
        }
        return false;
    }

    public static String normalize(String path) {
        int ns;
        int i;
        if (path.startsWith("http:") || path.startsWith("https:") || path.startsWith("ftp:")) {
            return path;
        }
        boolean slash_change = false;
        String prefix = "";
        if (path.length() >= 9 && path.startsWith("file:////")) {
            prefix = "file://";
            path = path.substring(7);
            slash_change = true;
        }
        if (path.length() >= 9 && path.startsWith("file:///")) {
            prefix = "file:///";
            path = path.substring(8);
        } else if (path.length() >= 6 && path.startsWith("file:/") && path.charAt(7) != '/') {
            prefix = "file:/";
            path = path.substring(6);
        }
        int origLength = path.length();
        int j = 0;
        int num_segments = 0;
        int lastSlash = 0;
        boolean dotSegment = false;
        boolean backslash = false;
        for (i = 0; i < origLength; ++i) {
            if (i == 0 && path.charAt(i) == '.') {
                dotSegment = true;
            }
            if (path.charAt(i) != '/' && path.charAt(i) != '\\') continue;
            if (path.charAt(i) == '\\') {
                backslash = true;
            }
            if (i == 0) {
                ++num_segments;
                while (i + 1 < path.length() && (path.charAt(i + 1) == '/' || path.charAt(i + 1) == '\\')) {
                    ++i;
                }
                if (i > 0) {
                    slash_change = true;
                }
            } else if (i == lastSlash) {
                slash_change = true;
            } else if (i != lastSlash) {
                ++num_segments;
            }
            if (!dotSegment && i + 1 < path.length() && path.charAt(i + 1) == '.') {
                dotSegment = true;
            }
            lastSlash = i + 1;
        }
        if (i > lastSlash) {
            ++num_segments;
        }
        if (backslash) {
            path = PathUtils.slashify(path);
        }
        if (path.length() > 3 && path.charAt(0) == '/' && path.charAt(2) == ':') {
            path = path.substring(1);
        }
        if (!slash_change && !dotSegment) {
            return prefix + path;
        }
        boolean pathChanged = false;
        origLength = path.length();
        ArrayList<String> segments = new ArrayList<String>(num_segments);
        lastSlash = 0;
        for (i = 0; i < origLength; ++i) {
            if (path.charAt(i) != '/') continue;
            if (i == 0) {
                while (i + 1 < path.length() && path.charAt(i + 1) == '/') {
                    ++i;
                }
                segments.add(path.substring(0, i + 1));
            } else if (i == lastSlash) {
                pathChanged = true;
            } else if (i != lastSlash) {
                segments.add(path.substring(lastSlash, i + 1));
            }
            lastSlash = i + 1;
        }
        if (i > lastSlash) {
            segments.add(path.substring(lastSlash));
        }
        for (i = ns = segments.size() - 1; i >= 0; --i) {
            String s = (String)segments.get(i);
            String t = PathUtils.trimSlash(s);
            if (i >= 1 && t.equals("..")) {
                j = i - 1;
                String p = (String)segments.get(j);
                String q = PathUtils.trimSlash(p);
                if (q.equals(".")) {
                    pathChanged = true;
                    segments.remove(j);
                } else if (!q.equals("..") && !PathUtils.isSymbol(q)) {
                    pathChanged = true;
                    segments.remove(i);
                    segments.remove(j);
                }
                if (segments.size() != j) continue;
                i = j;
                continue;
            }
            if (!t.equals(".")) continue;
            pathChanged = true;
            segments.remove(i);
        }
        if (pathChanged) {
            StringBuilder sb = new StringBuilder(path.length());
            for (String s : segments) {
                sb.append(s);
            }
            return prefix + sb.toString();
        }
        return prefix + path;
    }

    @Trivial
    public static boolean isSymbol(String s) {
        return s.length() > 3 && s.charAt(0) == '$' && s.charAt(1) == '{';
    }

    @Trivial
    public static boolean containsSymbol(String s) {
        int pos;
        if (s != null && s.length() > 3 && (pos = s.indexOf(36)) >= 0) {
            int pos2 = pos + 1;
            if (s.length() > pos2 && s.charAt(pos2) == '{' && (pos2 = s.indexOf(125, pos2)) >= 0) {
                return true;
            }
        }
        return false;
    }

    @Trivial
    public static String getSymbol(String s) {
        int pos;
        String outputSymbol = null;
        if (s != null && s.length() > 3 && (pos = s.indexOf(36)) >= 0) {
            int pos2 = pos + 1;
            if (s.length() > pos2 && s.charAt(pos2) == '{' && (pos2 = s.indexOf(125, pos2)) >= 0) {
                outputSymbol = s.substring(pos, pos2 + 1);
            }
        }
        return outputSymbol;
    }

    @Trivial
    private static String trimSlash(String segment) {
        int len = segment.length();
        if (len >= 1 && segment.charAt(len - 1) == '/') {
            return segment.substring(0, len - 1);
        }
        return segment;
    }

    static boolean isFileAChild(File parent, File child) {
        String pNormalized = PathUtils.normalize(parent.getAbsolutePath());
        String cNormalized = PathUtils.normalize(child.getAbsolutePath());
        if (cNormalized.length() <= pNormalized.length()) {
            return false;
        }
        return cNormalized.startsWith(pNormalized);
    }

    public static String getParent(String path) {
        String parent = null;
        int lastIndex = path.lastIndexOf(47);
        if (lastIndex != -1) {
            parent = path.length() == 1 ? null : (lastIndex == 0 ? "/" : path.substring(0, lastIndex));
        }
        return parent;
    }

    public static String getName(String pathAndName) {
        int i = pathAndName.lastIndexOf(47);
        int l = pathAndName.length();
        if (i == -1) {
            return pathAndName;
        }
        if (l == i) {
            return "/";
        }
        return pathAndName.substring(i + 1);
    }

    public static String getFirstPathComponent(String path) {
        int sIdx = path.indexOf(47);
        if (sIdx == -1) {
            return path;
        }
        if (path.length() <= 1) {
            return "";
        }
        if (sIdx == 0 && path.indexOf(47, 1) == -1) {
            return path.substring(1);
        }
        if (sIdx != 0) {
            return path.substring(0, sIdx);
        }
        return path.substring(1, path.indexOf(47, 1));
    }

    public static String getChildUnder(String path, String parentPath) {
        int start = parentPath.length();
        String local = path.substring(start, path.length());
        String name = PathUtils.getFirstPathComponent(local);
        return name;
    }

    public static boolean isUnixStylePathAbsolute(String unixStylePath) {
        String nPath = PathUtils.normalizeUnixStylePath(unixStylePath);
        return PathUtils.isNormalizedPathAbsolute(nPath);
    }

    public static boolean isNormalizedPathAbsolute(String nPath) {
        boolean retval = "..".equals(nPath) || nPath.startsWith("../") || nPath.startsWith("/..");
        return !retval;
    }

    public static String checkAndNormalizeRootPath(String path) throws IllegalArgumentException {
        if (!PathUtils.isNormalizedPathAbsolute(path = PathUtils.normalizeUnixStylePath(path))) {
            throw new IllegalArgumentException();
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.equals("/") || path.equals("")) {
            throw new IllegalArgumentException();
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String normalizeUnixStylePath(String path) {
        char c;
        ParseState state;
        int pathIndex;
        int pathLen;
        block58: {
            if (path == null) return path;
            pathLen = path.length();
            if (pathLen < 2) {
                return path;
            }
            pathIndex = pathLen - 1;
            state = ParseState.NEW_ELEM;
            pathIndex = pathLen - 1;
            while (pathIndex > 0) {
                char c2 = path.charAt(pathIndex);
                block0 : switch (state) {
                    case NEW_ELEM: {
                        switch (c2) {
                            case '/': {
                                break block58;
                            }
                            case '.': {
                                state = ParseState.ONE_DOT;
                                break;
                            }
                            default: {
                                state = ParseState.IN_ELEM;
                                break;
                            }
                        }
                        break;
                    }
                    case IN_ELEM: {
                        if (c2 != '/') break;
                        state = ParseState.NEW_ELEM;
                        break;
                    }
                    case ONE_DOT: {
                        switch (c2) {
                            case '/': {
                                state = ParseState.NEW_ELEM;
                                break block0;
                            }
                            case '.': {
                                state = ParseState.TWO_DOTS;
                                break block0;
                            }
                        }
                        state = ParseState.IN_ELEM;
                        break;
                    }
                    case TWO_DOTS: {
                        switch (c2) {
                            case '/': {
                                pathIndex += 2;
                                state = ParseState.NEW_ELEM;
                                break block58;
                            }
                            default: {
                                state = ParseState.IN_ELEM;
                                break block0;
                            }
                        }
                    }
                }
                --pathIndex;
            }
            return path;
        }
        char[] buffer = path.toCharArray();
        int offset = pathIndex + 1;
        int elemsToSkip = 0;
        while (pathIndex > 0) {
            block59: {
                c = buffer[pathIndex];
                block17 : switch (state) {
                    case NEW_ELEM: {
                        switch (c) {
                            case '/': {
                                break;
                            }
                            case '.': {
                                state = ParseState.ONE_DOT;
                                break;
                            }
                            default: {
                                state = ParseState.IN_ELEM;
                                if (elemsToSkip <= 0) break block17;
                                break;
                            }
                        }
                        break block59;
                    }
                    case IN_ELEM: {
                        switch (c) {
                            case '/': {
                                state = ParseState.NEW_ELEM;
                                if (elemsToSkip == 0) break;
                                --elemsToSkip;
                                break block59;
                            }
                            default: {
                                if (elemsToSkip == 0) {
                                    break;
                                }
                                break block59;
                            }
                        }
                        break;
                    }
                    case ONE_DOT: {
                        switch (c) {
                            case '.': {
                                state = ParseState.TWO_DOTS;
                                break block59;
                            }
                            case '/': {
                                state = ParseState.NEW_ELEM;
                                if (elemsToSkip == 0) {
                                    buffer[--offset] = 46;
                                    break;
                                }
                                --elemsToSkip;
                                break block59;
                            }
                            default: {
                                state = ParseState.IN_ELEM;
                                if (elemsToSkip == 0) {
                                    buffer[--offset] = 46;
                                    break;
                                }
                                break block59;
                            }
                        }
                        break;
                    }
                    case TWO_DOTS: {
                        switch (c) {
                            case '/': {
                                state = ParseState.NEW_ELEM;
                                ++elemsToSkip;
                                break block59;
                            }
                            default: {
                                state = ParseState.IN_ELEM;
                                if (elemsToSkip != 0) break block59;
                                buffer[--offset] = 46;
                                buffer[--offset] = 46;
                            }
                        }
                    }
                }
                buffer[--offset] = c;
            }
            --pathIndex;
        }
        c = buffer[0];
        boolean pathHasLeadingSlash = c == '/';
        switch (state) {
            case IN_ELEM: {
                if (elemsToSkip == 0) {
                    buffer[--offset] = c;
                    break;
                }
                --elemsToSkip;
                break;
            }
            case ONE_DOT: {
                if (elemsToSkip == 0 || c == '.') {
                    buffer[--offset] = 46;
                    buffer[--offset] = c;
                    break;
                }
                --elemsToSkip;
                break;
            }
            case NEW_ELEM: {
                if (elemsToSkip == 0) {
                    if (offset != pathLen && pathHasLeadingSlash) break;
                    buffer[--offset] = c;
                    break;
                }
                if (pathHasLeadingSlash) break;
                --elemsToSkip;
                break;
            }
            case TWO_DOTS: {
                if (elemsToSkip == 0 || pathHasLeadingSlash) {
                    buffer[--offset] = 46;
                    buffer[--offset] = 46;
                    buffer[--offset] = c;
                    break;
                }
                --elemsToSkip;
                break;
            }
        }
        if (elemsToSkip == 0) {
            boolean resultHasLeadingSlash = offset < pathLen && buffer[offset] == '/';
            if (!(pathHasLeadingSlash ^ resultHasLeadingSlash)) return new String(buffer, offset, pathLen - offset);
            if (resultHasLeadingSlash) {
                return new String(buffer, ++offset, pathLen - offset);
            }
            buffer[--offset] = 47;
            return new String(buffer, offset, pathLen - offset);
        }
        if (offset < pathLen && buffer[offset] != '/') {
            buffer[--offset] = 47;
        }
        while (true) {
            if (--elemsToSkip <= 0) {
                buffer[--offset] = 46;
                buffer[--offset] = 46;
                if (!pathHasLeadingSlash) return new String(buffer, offset, pathLen - offset);
                buffer[--offset] = 47;
                return new String(buffer, offset, pathLen - offset);
            }
            buffer[--offset] = 46;
            buffer[--offset] = 46;
            buffer[--offset] = 47;
        }
    }

    public static boolean checkCase(File file, String pathToTest) {
        if (pathToTest == null || pathToTest.isEmpty()) {
            return true;
        }
        if (!IS_POSSIBLY_CASE_INSENSITIVE) {
            return true;
        }
        try {
            if (PathUtils.checkCaseCanonical(file, pathToTest)) {
                return true;
            }
            return PathUtils.checkCaseSymlink(file, pathToTest);
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.kernel.service.utils.PathUtils", (String)"1233", null, (Object[])new Object[]{file, pathToTest});
            return false;
        }
    }

    private static boolean checkCaseCanonical(final File file, String pathToTest) throws PrivilegedActionException {
        String onDiskCanonicalPath = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
            static final long serialVersionUID = -4923010466776588478L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() throws IOException {
                return file.getCanonicalPath();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        String expectedEnding = (onDiskCanonicalPath = onDiskCanonicalPath.replace("\\", "/")).endsWith("/") ? (pathToTest.endsWith("/") ? pathToTest : pathToTest + "/") : (pathToTest.endsWith("/") ? pathToTest.substring(0, pathToTest.length() - 1) : pathToTest);
        if (expectedEnding.isEmpty()) {
            return true;
        }
        return onDiskCanonicalPath.endsWith(expectedEnding);
    }

    private static boolean checkCaseSymlink(File file, String pathToTest) throws PrivilegedActionException {
        if (pathToTest.startsWith("/")) {
            pathToTest = pathToTest.substring(1);
        }
        String[] splitPathToTest = pathToTest.split("/");
        File symLinkTestFile = file;
        for (int i = splitPathToTest.length - 1; i >= 0; --i) {
            File symLinkParentFile = symLinkTestFile.getParentFile();
            if (symLinkParentFile == null) {
                return false;
            }
            if (!PathUtils.isSymbolicLink(symLinkTestFile, symLinkParentFile) ? !PathUtils.getCanonicalFile(symLinkTestFile).getName().equals(splitPathToTest[i]) : !PathUtils.contains(symLinkParentFile.list(), splitPathToTest[i])) {
                return false;
            }
            symLinkTestFile = symLinkParentFile;
        }
        return true;
    }

    private static boolean isSymbolicLink(File file, File parentFile) throws PrivilegedActionException {
        File canonicalParentDir = PathUtils.getCanonicalFile(parentFile);
        File fileInCanonicalParentDir = new File(canonicalParentDir, file.getName());
        File canonicalFile = PathUtils.getCanonicalFile(fileInCanonicalParentDir);
        return !canonicalFile.equals(fileInCanonicalParentDir.getAbsoluteFile());
    }

    private static File getCanonicalFile(final File file) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){
            static final long serialVersionUID = -3731292346393808181L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public File run() throws Exception {
                return file.getCanonicalFile();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
    }

    @Trivial
    private static boolean contains(String[] fileList, String fileName) {
        if (fileList != null) {
            for (String file : fileList) {
                if (!file.equals(fileName)) continue;
                return true;
            }
        }
        return false;
    }

    public static String replaceRestrictedCharactersInFileName(String name) {
        int replacedChars = 0;
        StringBuilder sb = new StringBuilder(name.length());
        for (int x = 0; x < name.length(); ++x) {
            char y = name.charAt(x);
            if (FILE_NAME_RESTRICTED_CHARS.indexOf(y) == -1 && (y < '\u0000' || y > '\u001f')) {
                sb.append(y);
                continue;
            }
            sb.append('.');
            ++replacedChars;
        }
        String processedName = sb.toString();
        if (processedName.length() <= 2 && replacedChars > 0 && (processedName.equals(".") || processedName.equals(".."))) {
            return null;
        }
        return name.length() - replacedChars > 0 ? processedName : null;
    }

    public static String fixPathString(String absPath) {
        return PathUtils.fixPathString(new File(absPath));
    }

    @FFDCIgnore(value={IOException.class})
    public static String fixPathString(File absPath) {
        if (isWindows) {
            try {
                return absPath.getCanonicalPath();
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)PathUtils.class.getName(), (String)"67");
                return absPath.getAbsolutePath();
            }
        }
        return absPath.getAbsolutePath();
    }

    public static Set<File> getFixedPathFiles(Collection<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<File> result = new HashSet<File>(paths.size());
        for (String p : paths) {
            result.add(new File(PathUtils.fixPathString(p)));
        }
        return result;
    }

    public static Set<File> fixPathFiles(Collection<File> files) {
        if (files == null || files.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<File> result = new HashSet<File>(files.size());
        for (File f : files) {
            result.add(new File(PathUtils.fixPathString(f)));
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(PathUtils.class);
        isWindows = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -2755499193632448753L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return System.getProperty("os.name", "unknown").toUpperCase(Locale.ENGLISH).contains("WINDOWS");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        ABSOLUTE_URI = Pattern.compile("^[^/#\\?]+?:/.*");
        IS_POSSIBLY_CASE_INSENSITIVE = PathUtils.isPossiblyCaseInsensitive();
        FILE_NAME_RESTRICTED_CHARS = "<>:\"/\\|?*";
        PATH_COMPARATOR = new PathComparator();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class ParseState
    extends Enum<ParseState> {
        public static final /* enum */ ParseState NEW_ELEM;
        public static final /* enum */ ParseState IN_ELEM;
        public static final /* enum */ ParseState ONE_DOT;
        public static final /* enum */ ParseState TWO_DOTS;
        private static final /* synthetic */ ParseState[] $VALUES;
        static final long serialVersionUID = -8944535638781384840L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static ParseState[] values() {
            return (ParseState[])$VALUES.clone();
        }

        public static ParseState valueOf(String name) {
            return Enum.valueOf(ParseState.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ParseState.class);
            NEW_ELEM = new ParseState();
            IN_ELEM = new ParseState();
            ONE_DOT = new ParseState();
            TWO_DOTS = new ParseState();
            $VALUES = new ParseState[]{NEW_ELEM, IN_ELEM, ONE_DOT, TWO_DOTS};
        }
    }

    @Trivial
    public static class PathComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8845848986582493462L;
        public static final char PATH_SEPARATOR = '/';
        private static final int CMP_LT = -1;
        private static final int CMP_GT = 1;

        @Override
        @Trivial
        public int compare(String o1, String o2) {
            int len1 = o1.length();
            int l2 = o2.length();
            int minLen = Math.min(len1, l2);
            for (int i = 0; i < minLen; ++i) {
                char c2;
                char c1 = o1.charAt(i);
                if (c1 == (c2 = o2.charAt(i))) continue;
                if (c1 == '/') {
                    return -1;
                }
                if (c2 == '/') {
                    return 1;
                }
                return c1 - c2;
            }
            return len1 - l2;
        }
    }
}

