/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ServiceReferenceUtils;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConcurrentServiceReferenceElement<T>
implements Comparable<ConcurrentServiceReferenceElement<T>> {
    private final String referenceName;
    private final ServiceReference<T> serviceRef;
    private final Long serviceId;
    private final Integer serviceRanking;
    private volatile T locatedService = null;
    static final long serialVersionUID = 8717631417087864955L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ConcurrentServiceReferenceElement(String referenceName, ServiceReference<T> serviceRef) {
        this.referenceName = referenceName;
        this.serviceRef = serviceRef;
        this.serviceId = ServiceReferenceUtils.getId(serviceRef);
        this.serviceRanking = ServiceReferenceUtils.getRanking(serviceRef);
    }

    ServiceReference<T> getReference() {
        return this.serviceRef;
    }

    Integer getRanking() {
        return this.serviceRanking;
    }

    synchronized T getService(ComponentContext context) {
        Object svc = this.locatedService;
        if (svc == null) {
            svc = this.locatedService = context.locateService(this.referenceName, this.serviceRef);
        }
        return svc;
    }

    public String toString() {
        return super.toString() + "[id=" + this.serviceId + ", ranking=" + this.serviceRanking + "]";
    }

    public int hashCode() {
        return this.serviceId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConcurrentServiceReferenceElement other = (ConcurrentServiceReferenceElement)obj;
        return this.serviceId.equals(other.serviceId);
    }

    @Override
    public int compareTo(ConcurrentServiceReferenceElement<T> that) {
        int compare = that.serviceRanking.compareTo(this.serviceRanking);
        if (compare == 0) {
            compare = this.serviceId.compareTo(that.serviceId);
        }
        return compare;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConcurrentServiceReferenceElement.class);
    }
}

