/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanIdCache;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSRemoteWrapper;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.ejs.container.InvalidBeanIdException;
import com.ibm.ejs.container.StatefulBeanO;
import com.ibm.ejs.container.WrapperId;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.util.cache.Cache;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CacheElement;
import com.ibm.websphere.csi.DiscardException;
import com.ibm.websphere.csi.DiscardStrategy;
import com.ibm.websphere.csi.EJBCache;
import com.ibm.websphere.csi.FaultException;
import com.ibm.websphere.csi.FaultStrategy;
import com.ibm.websphere.csi.IllegalOperationException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.diagnostics.IntrospectionWriter;
import com.ibm.ws.ejbcontainer.diagnostics.TrDumpWriter;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.Enumeration;

public class WrapperManager
implements DiscardStrategy,
FaultStrategy {
    private static final TraceComponent tc = Tr.register(WrapperManager.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.WrapperManager";
    protected EJBCache wrapperCache;
    private EJSContainer container;
    protected BeanIdCache beanIdCache;

    public WrapperManager(EJSContainer container2) {
        this.container = container2;
    }

    public void initialize(Cache wrapperCache) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object[])new Object[0]);
        }
        this.wrapperCache = wrapperCache;
        wrapperCache.setDiscardStrategy(this);
        wrapperCache.setFaultStrategy(this);
        int beanIdCacheSize = this.getBeanIdCacheSize(wrapperCache.getNumBuckets());
        this.beanIdCache = new BeanIdCache(beanIdCacheSize);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void destroy() {
        this.wrapperCache.terminate();
        this.wrapperCache = null;
        this.container = null;
    }

    public void setWrapperCacheSweepInterval(long interval) {
        this.wrapperCache.setSweepInterval(interval);
    }

    public void setWrapperCacheSize(int cacheSize) {
        this.wrapperCache.setCachePreferredMaxSize(cacheSize);
        int updatedCacheSize = this.getBeanIdCacheSize(cacheSize);
        this.beanIdCache.setSize(updatedCacheSize);
    }

    private int getBeanIdCacheSize(int cacheSize) {
        int beanIdCacheSize = cacheSize;
        beanIdCacheSize = beanIdCacheSize < 0x3FFFFFFF ? (beanIdCacheSize *= 2) : Integer.MAX_VALUE;
        return beanIdCacheSize;
    }

    public boolean preInvoke(EJSWrapperBase wrapper) throws CSIException, RemoteException {
        if (wrapper.ivCommon.pinned > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"preInvoke : pinned = false (already pinned)", (Object[])new Object[]{wrapper});
            }
            return false;
        }
        boolean pinned = wrapper.ivCommon.pinOnce();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("preInvoke : pinned = " + pinned), (Object[])new Object[]{wrapper});
        }
        return pinned;
    }

    public void postInvoke(EJSWrapperBase wrapper) throws CSIException, RemoteException {
        wrapper.ivCommon.unpin();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"postInvoke : unpinned", (Object[])new Object[]{wrapper});
        }
    }

    public EJSWrapperCommon createWrapper(StatefulBeanO beanO) throws CSIException, RemoteException {
        EJSWrapperCommon wc;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createWrapper: " + beanO.getId()), (Object[])new Object[0]);
        }
        BeanId id = beanO.getId();
        EJSHome home = beanO.home;
        ByteArray wrapperKey = id.getByteArray();
        wrapperKey.setBeanId(id);
        try {
            wc = home.internalCreateWrapper(id);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.WrapperManager.createWrapper", (String)"294", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Malformed object key", (Object[])new Object[]{ex});
            }
            throw new CSIException("Wrapper creation failure: " + ex, ex);
        }
        wc.ivCachedBeanO = beanO;
        this.wrapperCache.insertUnpinned((Object)wrapperKey, wc);
        this.beanIdCache.add(id);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createWrapper");
        }
        return wc;
    }

    public EJSWrapperCommon getWrapperForCreate(BeanO beanO) throws CSIException, RemoteException {
        EJSWrapperCommon wc;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWrapperForCreate", (Object[])new Object[0]);
        }
        BeanId id = beanO.getId();
        EJSHome home = beanO.home;
        if (home.statefulSessionHome) {
            wc = ((StatefulBeanO)beanO).ivWrapperCommon;
            if (wc == null) {
                wc = this.getWrapper(id);
            }
        } else {
            wc = this.getWrapper(id);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWrapperForCreate");
        }
        return wc;
    }

    public EJSWrapperCommon getWrapper(BeanId id) throws CSIException, RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWrapper", (Object[])new Object[0]);
        }
        EJSWrapperCommon result = null;
        if (id.byteArray == null && !id._isHome && id.pkey != null) {
            id = this.beanIdCache.find(id);
        }
        ByteArray wrapperKey = id.getByteArray();
        wrapperKey.setBeanId(id);
        try {
            result = (EJSWrapperCommon)this.wrapperCache.findAndFault((Object)wrapperKey);
        }
        catch (FaultException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.WrapperManager.getWrapper", (String)"259", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unable to fault in wrapper", (Object[])new Object[]{ex});
            }
            throw new CSIException(ex.toString());
        }
        if (!id._isHome && id.pkey != null) {
            this.beanIdCache.add(result.getBeanId());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWrapper");
        }
        return result;
    }

    public boolean unregister(BeanId beanId, boolean dropRef) throws CSIException {
        boolean removed;
        block7: {
            removed = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"unregister", (Object[])new Object[]{beanId, new Boolean(dropRef)});
            }
            ByteArray wrapperKey = beanId.getByteArray();
            try {
                EJSWrapperCommon wrapperCommon = (EJSWrapperCommon)this.wrapperCache.removeAndDiscard((Object)wrapperKey, dropRef);
                if (wrapperCommon != null) {
                    removed = true;
                }
            }
            catch (IllegalOperationException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.WrapperManager.unregister", (String)"351", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("unregister ignoring IllegalOperationException for object " + beanId), (Object[])new Object[0]);
                    Tr.event((TraceComponent)tc, (String)("Exception: " + ex), (Object[])new Object[0]);
                }
            }
            catch (DiscardException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.WrapperManager.unregister", (String)"358", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                Tr.event((TraceComponent)tc, (String)"Unable to discard element", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unregister");
        }
        return removed;
    }

    public void unregisterHome(J2EEName homeName, EJSHome homeObj) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unregisterHome", (Object[])new Object[0]);
        }
        int numEnumerated = 0;
        int numRemoved = 0;
        Enumeration<?> enumerate = this.wrapperCache.enumerateElements();
        while (enumerate.hasMoreElements()) {
            EJSWrapperCommon wCommon = (EJSWrapperCommon)((CacheElement)enumerate.nextElement()).getObject();
            BeanId cacheMemberBeanId = wCommon.getBeanId();
            J2EEName cacheHomeName = cacheMemberBeanId.getJ2EEName();
            ++numEnumerated;
            if (!cacheHomeName.equals(homeName) && !cacheMemberBeanId.equals(homeObj.getId())) continue;
            this.unregister(cacheMemberBeanId, true);
            ++numRemoved;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Unregistered " + numRemoved + " wrappers (total = " + numEnumerated + ")"), (Object[])new Object[0]);
        }
        this.beanIdCache.removeAll(homeObj);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unregisterHome");
        }
    }

    @Override
    public void discardObject(EJBCache wrapperCache, Object key, Object ele) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"discardObject", (Object[])new Object[]{key, ele});
        }
        EJSWrapperCommon wrapperCommon = (EJSWrapperCommon)ele;
        wrapperCommon.disconnect();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"discardObject");
        }
    }

    public EJSRemoteWrapper keyToObject(byte[] key) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keyToObject", (Object[])new Object[0]);
        }
        EJSWrapperCommon wc = null;
        EJSRemoteWrapper wrapper = null;
        try {
            if (key[0] == -83) {
                WrapperId wrapperId = new WrapperId(key);
                ByteArray wrapperKey = wrapperId.getBeanIdArray();
                wc = (EJSWrapperCommon)this.wrapperCache.findAndFault((Object)wrapperKey);
                if (wc != null) {
                    wrapper = wc.getRemoteBusinessWrapper(wrapperId);
                    BeanId beanId = wrapper.beanId;
                    if (!beanId._isHome && beanId.pkey != null) {
                        this.beanIdCache.add(beanId);
                    }
                }
            } else {
                ByteArray wrapperKey = new ByteArray(key);
                wc = (EJSWrapperCommon)this.wrapperCache.findAndFault((Object)wrapperKey);
                if (wc != null) {
                    wrapper = wc.getRemoteObjectWrapper();
                    BeanId beanId = wrapper.beanId;
                    if (!beanId._isHome && beanId.pkey != null) {
                        this.beanIdCache.add(beanId);
                    }
                }
            }
        }
        catch (FaultException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.WrapperManager.keyToObject", (String)"501", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unable to fault in wrapper", (Object[])new Object[]{ex});
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keyToObject", (Object)wrapper);
        }
        return wrapper;
    }

    @Override
    public Object faultOnKey(EJBCache cache, Object key) throws FaultException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"faultOnKey", (Object[])new Object[]{key});
        }
        ByteArray wrapperKey = (ByteArray)((Object)key);
        EJSWrapperCommon result = null;
        BeanId beanId = wrapperKey.getBeanId();
        try {
            if (beanId == null) {
                beanId = BeanId.getBeanId(wrapperKey, this.container);
            }
            result = this.container.createWrapper(beanId);
        }
        catch (InvalidBeanIdException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.WrapperManager.faultOnKey", (String)"533", (Object)this);
            Throwable cause = ex.getCause();
            if (cause instanceof EJBNotFoundException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Application Not Started", (Object[])new Object[]{ex});
                }
                throw new FaultException((EJBNotFoundException)cause, "Application not started or not installed");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Malformed object key", (Object[])new Object[]{ex});
            }
            throw new FaultException(ex, "Malformed object key");
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.WrapperManager.faultOnKey", (String)"548", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Malformed object key", (Object[])new Object[]{ex});
            }
            throw new FaultException(ex, "Malformed object key");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"faultOnKey");
        }
        return result;
    }

    public void dump() {
        this.introspect(new TrDumpWriter(tc));
    }

    public void introspect(IntrospectionWriter writer) {
        writer.begin("WrapperManager");
        this.beanIdCache.introspect(writer);
        ((Cache)this.wrapperCache).introspect(writer);
        writer.end();
    }
}

