/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.ArtifactDownloaderUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.ProgressBar;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;

public class VerifySignatureUtility {
    private static final Logger logger = InstallLogUtils.getInstallLogger();
    private static final File LIBERTY_KEY = new File(Utils.getInstallDir(), "lib/versions/public_key/libertyKey.asc");
    private static final String UbuntuServerURL = "https://keyserver.ubuntu.com/pks/lookup?op=get&options=mr&search=";
    private String defaultKeyID = null;
    private final ProgressBar progressBar = ProgressBar.getInstance();

    private String getLibertyKeyID() throws InstallException {
        if (this.defaultKeyID != null) {
            return this.defaultKeyID;
        }
        File propertiesFile = new File(Utils.getInstallDir(), "lib/versions/openliberty.properties");
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(propertiesFile);){
            properties.load(input);
            this.defaultKeyID = properties.getProperty("com.ibm.websphere.productPublicKeyId");
        }
        catch (IOException e) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_COULD_NOT_DETERMINE_RUNTIME_PROPERTIES_FILE", propertiesFile.getAbsolutePath()));
        }
        return this.defaultKeyID;
    }

    public boolean isKeyValid(File pubKey, String keyID) throws InstallException {
        boolean isValid = false;
        try (FileInputStream fis = new FileInputStream(pubKey);
             BufferedInputStream keyIn = new BufferedInputStream(fis);){
            PGPPublicKeyRing pgpPubKeyRing = new PGPPublicKeyRing(PGPUtil.getDecoderStream(keyIn), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PGPPublicKey publicKey = pgpPubKeyRing.getPublicKey();
            isValid = this.validatePublicKey(publicKey, keyID);
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
            if (keyID.equals(this.getLibertyKeyID())) {
                throw new InstallException(e.getMessage());
            }
        }
        catch (InstallException e) {
            if (keyID.equals(this.getLibertyKeyID())) {
                throw e;
            }
            logger.warning(e.getMessage());
        }
        return isValid;
    }

    protected boolean validatePublicKey(PGPPublicKey publicKey, String expectedKeyID) throws InstallException {
        Instant expiryDate;
        String keyID = String.format("0x%016x", publicKey.getKeyID()).toUpperCase();
        if (!keyID.contains(expectedKeyID.toUpperCase())) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INAUTHENTIC_PUBLIC_KEY", keyID, expectedKeyID));
        }
        if (publicKey.hasRevocation()) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_REVOKED_PUBLIC_KEY", keyID));
        }
        if (publicKey.getValidSeconds() > 0L && (expiryDate = publicKey.getCreationTime().toInstant().plusSeconds(publicKey.getValidSeconds())).isBefore(Instant.now())) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_EXPIRED_PUBLIC_KEY", keyID, expiryDate));
        }
        return true;
    }

    public List<File> downloadPublicKeys(Collection<Map<String, String>> keys, InstallConstants.VerifyOption verify, Map<String, Object> envMap) throws InstallException {
        Map<String, String> allKeys = this.getPublicKeyURL(keys, verify);
        ArrayList<File> downloadedKeys = new ArrayList<File>();
        for (Map.Entry<String, String> key : allKeys.entrySet()) {
            try {
                Proxy proxy;
                logger.fine("Downloading key... " + key.getValue());
                ArtifactDownloaderUtils.checkValidProxy(envMap);
                URL keyUrl = new URL(key.getValue());
                String proxyEncodedAuth = "";
                if (envMap.get("https.proxyHost") != null) {
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)envMap.get("https.proxyHost"), Integer.parseInt((String)envMap.get("https.proxyPort"))));
                    proxyEncodedAuth = ArtifactDownloaderUtils.getBasicAuthentication((String)envMap.get("https.proxyUser"), (String)envMap.get("https.proxyPassword"));
                } else if (envMap.get("http.proxyHost") != null) {
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)envMap.get("http.proxyHost"), Integer.parseInt((String)envMap.get("http.proxyPort"))));
                    proxyEncodedAuth = ArtifactDownloaderUtils.getBasicAuthentication((String)envMap.get("http.proxyUser"), (String)envMap.get("http.proxyPassword"));
                } else {
                    proxy = Proxy.NO_PROXY;
                }
                URLConnection conn = keyUrl.openConnection(proxy);
                conn.setConnectTimeout(10000);
                if (!proxyEncodedAuth.isEmpty()) {
                    logger.fine("encoded proxy auth: " + proxyEncodedAuth);
                    conn.setRequestProperty("Proxy-Authorization", proxyEncodedAuth);
                }
                try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
                    File tempFile = File.createTempFile("signature", ".asc", Utils.getInstallDir());
                    tempFile.deleteOnExit();
                    try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
                        int bytesRead;
                        byte[] dataBuffer = new byte[1024];
                        while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                            fileOutputStream.write(dataBuffer, 0, bytesRead);
                        }
                        if (!this.isKeyValid(tempFile, key.getKey())) continue;
                        downloadedKeys.add(tempFile);
                    }
                }
            }
            catch (IOException e) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_DOWNLOAD_KEY_FROM_KEY_URL", e.getMessage()));
            }
        }
        return downloadedKeys;
    }

    protected Map<String, String> getPublicKeyURL(Collection<Map<String, String>> keys, InstallConstants.VerifyOption verify) throws InstallException {
        HashMap<String, String> pubKeyUrls = new HashMap<String, String>();
        try {
            if (this.isKeyValid(LIBERTY_KEY, this.getLibertyKeyID())) {
                pubKeyUrls.put(this.getLibertyKeyID(), LIBERTY_KEY.toURI().toURL().toString());
            }
        }
        catch (InstallException | MalformedURLException e) {
            logger.warning(e.getMessage());
            String liberty_keyID = System.getProperty("com.ibm.ws.install.libertyKeyID", this.getLibertyKeyID());
            String PUBKEY_URL = UbuntuServerURL + liberty_keyID;
            pubKeyUrls.put(liberty_keyID, PUBKEY_URL);
        }
        this.getUserPubKey(keys, pubKeyUrls);
        return pubKeyUrls;
    }

    protected void getUserPubKey(Collection<Map<String, String>> keys, Map<String, String> pubKeyUrls) {
        for (Map<String, String> keyMap : keys) {
            String keyURL = keyMap.get("keyurl");
            String keyID = keyMap.get("keyid");
            if (keyID == null && keyURL == null) {
                logger.fine("Found the property for keyid and/or keyurl, but the value was not specified.");
                break;
            }
            if (keyID == null) {
                logger.warning(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_KEYID_NOT_PROVIDED", keyURL));
                continue;
            }
            try {
                pubKeyUrls.put(keyID, this.getValidKeyURL(keyURL, keyID));
            }
            catch (InstallException e) {
                logger.warning(e.getMessage());
            }
        }
    }

    protected String getValidKeyURL(String keyURL, String keyID) throws InstallException {
        if (keyURL == null) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_KEYURL_NOT_PROVIDED", keyID));
        }
        if (!InstallUtils.isURL(keyURL)) {
            File f = new File(keyURL);
            if (!f.exists()) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_DOWNLOAD_KEY_FROM_KEY_URL", keyURL));
            }
            try {
                keyURL = f.toURI().toURL().toString();
            }
            catch (MalformedURLException e) {
                throw new InstallException(e.getMessage());
            }
        } else if (!(keyURL.toLowerCase().startsWith("https") || keyURL.toLowerCase().startsWith("http") || keyURL.toLowerCase().startsWith("file"))) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_KEYURL_UNSUPPORTED_PROTOCOL", keyURL));
        }
        return keyURL;
    }

    public void verifySignatures(Collection<File> artifacts, List<File> pubKeys, List<File> failedFeatures) throws InstallException {
        logger.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_STARTING_VERIFY", new Object[0]));
        PGPPublicKeyRingCollection pgpPubRingCollection = this.getRingCollection(pubKeys);
        Iterator<PGPPublicKeyRing> iterator = pgpPubRingCollection.getKeyRings();
        StringBuilder str = new StringBuilder();
        str.append("Available public keyIDs: ");
        while (iterator.hasNext()) {
            PGPPublicKey publicKey = iterator.next().getPublicKey();
            String keyID = String.format("%x", publicKey.getKeyID());
            str.append(keyID + "\t");
        }
        logger.fine(str.toString());
        double increment = this.progressBar.getMethodIncrement("verifyFeatures") / (double)artifacts.size();
        for (File f : artifacts) {
            String esa_path = f.getAbsolutePath();
            String sig_path = esa_path + ".asc";
            try {
                logger.fine(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_VERIFYING", f.getName()));
                if (!this.isValidSignature(esa_path, sig_path, pgpPubRingCollection)) {
                    failedFeatures.add(f);
                } else {
                    logger.fine(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_VERIFIED_FEATURE", f.getName()));
                }
                this.progressBar.updateProgress(increment);
            }
            catch (IOException | PGPException e) {
                logger.fine(e.getMessage());
                failedFeatures.add(f);
            }
        }
        this.progressBar.manuallyUpdate();
    }

    private PGPPublicKeyRingCollection getRingCollection(List<File> pubKeys) throws InstallException {
        try {
            PGPPublicKeyRingCollection pgpPubRingCollection = new PGPPublicKeyRingCollection(new ArrayList<PGPPublicKeyRing>());
            for (File key : pubKeys) {
                try (BufferedInputStream keyIn = new BufferedInputStream(new FileInputStream(key));){
                    PGPPublicKeyRing pgpPubKeyRing = new PGPPublicKeyRing(PGPUtil.getDecoderStream(keyIn), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                    pgpPubRingCollection = PGPPublicKeyRingCollection.addPublicKeyRing(pgpPubRingCollection, pgpPubKeyRing);
                }
            }
            return pgpPubRingCollection;
        }
        catch (IOException e) {
            throw new InstallException(e.getMessage());
        }
    }

    private boolean isValidSignature(String fileName, String sig_path, PGPPublicKeyRingCollection pgpPubRingCollection) throws IOException, PGPException {
        PGPSignatureList signatureList = this.getSignatureList(fileName, sig_path);
        boolean isVerified = false;
        if (signatureList != null) {
            for (int i = 0; i < signatureList.size() && !isVerified; ++i) {
                PGPSignature sig = signatureList.get(i);
                logger.fine(String.format("Key ID used in signature: %x", sig.getKeyID()));
                PGPPublicKey pubKey = pgpPubRingCollection.getPublicKey(sig.getKeyID());
                if (pubKey == null) {
                    logger.fine(String.format("Public key ID %x was not found.", sig.getKeyID()));
                    continue;
                }
                logger.fine(String.format("Public key ID used: %x", pubKey.getKeyID()));
                isVerified = this.verifySignature(fileName, sig, pubKey);
            }
        }
        return isVerified;
    }

    private boolean verifySignature(String fileName, PGPSignature sig, PGPPublicKey pubKey) throws IOException, FileNotFoundException, PGPException {
        sig.init(new JcaPGPContentVerifierBuilderProvider().setProvider(new BouncyCastleProvider()), pubKey);
        try (BufferedInputStream dIn = new BufferedInputStream(new FileInputStream(fileName));){
            int ch;
            while ((ch = ((InputStream)dIn).read()) >= 0) {
                sig.update((byte)ch);
            }
        }
        return sig.verify();
    }

    private PGPSignatureList getSignatureList(String fileName, String sig_path) throws IOException, FileNotFoundException, PGPException {
        PGPSignatureList signatureList = null;
        try (BufferedInputStream sigIn = new BufferedInputStream(new FileInputStream(sig_path));
             InputStream decoderStream = PGPUtil.getDecoderStream(sigIn);){
            Object o;
            JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(decoderStream);
            while ((o = pgpFact.nextObject()) != null) {
                if (o instanceof PGPCompressedData) {
                    PGPCompressedData c1 = (PGPCompressedData)o;
                    pgpFact = new JcaPGPObjectFactory(c1.getDataStream());
                    signatureList = (PGPSignatureList)pgpFact.nextObject();
                } else {
                    signatureList = (PGPSignatureList)o;
                }
                if (!signatureList.isEmpty()) continue;
                logger.fine("The PGP signature could not be processed for the following : " + fileName);
            }
        }
        return signatureList;
    }
}

