/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.BasicPermission;
import java.security.Permission;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public final class WebSphereSecurityPermission
extends BasicPermission {
    private static final long serialVersionUID = 7885831460901050879L;
    private static final TraceComponent tc = Tr.register(WebSphereSecurityPermission.class);
    public static final WebSphereSecurityPermission INTERNAL_PERMISSION = new WebSphereSecurityPermission("internal");
    public static final WebSphereSecurityPermission PROVIDER_PERMISSION = new WebSphereSecurityPermission("provider");
    public static final WebSphereSecurityPermission PRIVILEGED_PERMISSION = new WebSphereSecurityPermission("privileged");
    private static final int INTERNAL = 4;
    private static final int PROVIDER = 2;
    private static final int PRIVILEGED = 1;
    private static final int NONE = 0;
    private transient int max;
    private static final String INTERNAL_STR = "internal";
    private static final String PROVIDER_STR = "provider";
    private static final String PRIVILEGED_STR = "privileged";

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private void init(int max) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init", (Object)new Object[]{max});
        }
        if (max != 4 && max != 2 && max != 1) {
            throw new IllegalArgumentException("invalid action");
        }
        if (max == 0) {
            throw new IllegalArgumentException("missing action");
        }
        if (this.getName() == null) {
            throw new NullPointerException("action can't be null");
        }
        this.max = max;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public WebSphereSecurityPermission(String action) {
        super("WebSphereSecurityPermission");
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{action});
        }
        this.init(WebSphereSecurityPermission.getMax(action));
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean implies(Permission p) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"implies", (Object)new Object[]{p});
        }
        if (!(p instanceof WebSphereSecurityPermission)) {
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bl = bl;
                Tr.exit((TraceComponent)tc, (String)"implies", (Object)bl);
            }
            return bl;
        }
        WebSphereSecurityPermission that = (WebSphereSecurityPermission)p;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Permission " + this.max + "impliles " + that.max + " = " + (this.max > that.max)));
        }
        boolean bl = this.max >= that.max;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((TraceComponent)tc, (String)"implies", (Object)bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private static int getMax(String action) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMax", (Object)new Object[]{action});
        }
        int max = 0;
        if (action == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WebSphereSecurityPermission action should not be null");
            }
            int n = max;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                n = n;
                Tr.exit((TraceComponent)tc, (String)"getMax", (Object)n);
            }
            return n;
        }
        if (INTERNAL_STR.equalsIgnoreCase(action)) {
            max = 4;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WebSphereSecurityPermission - internal");
            }
        } else if (PROVIDER_STR.equalsIgnoreCase(action)) {
            max = 2;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WebSphereSecurityPermission - provider");
            }
        } else if (PRIVILEGED_STR.equalsIgnoreCase(action)) {
            max = 1;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WebSphereSecurityPermission - privileged");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WebSphereSecurityPermission invalid action " + action));
            }
            throw new IllegalArgumentException("invalid permission: " + action);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WebSphereSecurityPermission value = " + max));
        }
        int n = max;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            n = n;
            Tr.exit((TraceComponent)tc, (String)"getMax", (Object)n);
        }
        return n;
    }
}

