/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.websphere.channelfw.ChannelFactoryData;
import com.ibm.wsspi.channelfw.ChannelFactory;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryException;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryPropertyIgnoredException;
import java.util.HashMap;
import java.util.Map;

public class ChannelFactoryDataImpl
implements ChannelFactoryData {
    private static final long serialVersionUID = 9036496735090447667L;
    private Map<Object, Object> myProperties = null;
    private Class<?>[] deviceInterface = null;
    private Class<?> applicationInterface = null;
    private Class<?> factory = null;
    private transient ChannelFactory cf = null;

    public ChannelFactoryDataImpl(Class<?> factory, Class<?>[] deviceInterface, Class<?> applicationInterface) {
        this.factory = factory;
        this.deviceInterface = deviceInterface;
        this.applicationInterface = applicationInterface;
        this.myProperties = new HashMap<Object, Object>();
    }

    @Override
    public Class<?> getApplicationInterface() {
        return this.applicationInterface;
    }

    @Override
    public Class<?>[] getDeviceInterface() {
        return this.deviceInterface;
    }

    @Override
    public synchronized Map<Object, Object> getProperties() {
        return this.myProperties;
    }

    @Override
    public Class<?> getFactory() {
        return this.factory;
    }

    synchronized void setProperties(Map<Object, Object> m) throws ChannelFactoryPropertyIgnoredException {
        this.myProperties = m;
        if (this.cf != null) {
            this.cf.updateProperties(m);
        }
    }

    synchronized void setProperty(Object key, Object value) throws ChannelFactoryPropertyIgnoredException {
        if (null == key) {
            throw new ChannelFactoryPropertyIgnoredException("Ignored channel factory property key of null");
        }
        if (this.myProperties == null) {
            this.myProperties = new HashMap<Object, Object>();
        }
        this.myProperties.put(key, value);
        if (this.cf != null) {
            this.cf.updateProperties(this.myProperties);
        }
    }

    synchronized ChannelFactory getChannelFactory() {
        return this.cf;
    }

    synchronized void setChannelFactory(ChannelFactory factory) throws ChannelFactoryException {
        if (factory != null && this.cf != null) {
            throw new ChannelFactoryException("ChannelFactory already exists");
        }
        this.cf = factory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("ChannelFactoryData: ");
        sb.append(this.factory);
        sb.append(" devices=[");
        if (this.deviceInterface != null && 0 != this.deviceInterface.length) {
            for (int i = 0; i < this.deviceInterface.length; ++i) {
                sb.append(this.deviceInterface[i]);
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        sb.append(" app=").append(this.applicationInterface);
        if (null != this.myProperties && !this.myProperties.isEmpty()) {
            sb.append(" [");
            for (Map.Entry<Object, Object> entry : this.myProperties.entrySet()) {
                sb.append(entry.getKey()).append('=').append(entry.getValue());
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, ']');
        }
        return sb.toString();
    }
}

