/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificatePolicyMap;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;

public final class PolicyMappingsExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.PolicyMappings";
    public static final String NAME = "PolicyMappings";
    public static final String MAP = "map";
    private Vector<CertificatePolicyMap> maps = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.PolicyMappingsExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.maps == null || this.maps.isEmpty()) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream os = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        for (int i2 = 0; i2 < this.maps.size(); ++i2) {
            this.maps.elementAt(i2).encode(tmp);
        }
        os.write((byte)48, tmp);
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public PolicyMappingsExtension(Vector<CertificatePolicyMap> map) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PolicyMappingsExtension", map);
        }
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = false;
        if (map != null) {
            this.maps = (Vector)map.clone();
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "PolicyMappingsExtension");
        }
    }

    public PolicyMappingsExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "PolicyMappingsExtension");
        }
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = false;
        this.maps = new Vector(1, 1);
        if (debug != null) {
            debug.exit(16384L, className, "PolicyMappingsExtension");
        }
    }

    public PolicyMappingsExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PolicyMappingsExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            extValue[i2] = Array.getByte(value, i2);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "PolicyMappingsExtension", "Invalid encoding for PolicyMappingsExtension.");
            }
            throw new IOException("Invalid encoding for PolicyMappingsExtension.");
        }
        this.maps = new Vector(1, 1);
        while (val.getData().available() != 0) {
            DerValue seq = val.getData().getDerValue();
            CertificatePolicyMap map = new CertificatePolicyMap(seq);
            this.maps.addElement(map);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PolicyMappingsExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.maps == null) {
            return "";
        }
        String s2 = super.toString() + "PolicyMappings [\n" + this.maps.toString() + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s2);
        }
        return s2;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.PolicyMappings_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(MAP)) {
            if (!(obj instanceof Vector)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type Vector.");
                }
                throw new IOException("Attribute value should be of type Vector.");
            }
            this.maps = obj != null ? (Vector)((Vector)obj).clone() : null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(MAP)) {
            if (this.maps != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", this.maps.clone());
                }
                return this.maps.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.maps);
            }
            return null;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(MAP)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        this.maps = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(MAP);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

