/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class AVAKeyword {
    private static final Map<ObjectIdentifier, AVAKeyword> oidMap = new HashMap<ObjectIdentifier, AVAKeyword>();
    private static final Map<String, AVAKeyword> keywordMap = new HashMap<String, AVAKeyword>();
    private String keyword;
    private ObjectIdentifier oid;
    private boolean rfc1779Compliant;
    private boolean rfc2253Compliant;

    private AVAKeyword(String keyword, ObjectIdentifier oid, boolean rfc1779Compliant, boolean rfc2253Compliant) {
        this.keyword = keyword;
        this.oid = oid;
        this.rfc1779Compliant = rfc1779Compliant;
        this.rfc2253Compliant = rfc2253Compliant;
        oidMap.put(oid, this);
        keywordMap.put(keyword, this);
    }

    private boolean isCompliant(int standard) {
        switch (standard) {
            case 2: {
                return this.rfc1779Compliant;
            }
            case 3: {
                return this.rfc2253Compliant;
            }
            case 1: {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid standard " + standard);
    }

    static ObjectIdentifier getOID(String keyword, int standard) throws IOException {
        return AVAKeyword.getOID(keyword, standard, Collections.EMPTY_MAP);
    }

    static ObjectIdentifier getOID(String keyword, int standard, Map<String, String> extraKeywordMap) throws IOException {
        char ch;
        String oidString;
        keyword = keyword.toUpperCase(Locale.US);
        if (standard == 3) {
            if (keyword.startsWith(" ") || keyword.endsWith(" ")) {
                throw new IOException("Invalid leading or trailing space in keyword \"" + keyword + "\"");
            }
        } else {
            keyword = keyword.trim();
        }
        if ((oidString = extraKeywordMap.get(keyword)) == null) {
            AVAKeyword ak = keywordMap.get(keyword);
            if (ak != null && ak.isCompliant(standard)) {
                return ak.oid;
            }
        } else {
            return new ObjectIdentifier(oidString);
        }
        if (standard == 2) {
            if (!keyword.startsWith("OID.")) {
                throw new IOException("Invalid RFC1779 keyword: " + keyword);
            }
            keyword = keyword.substring(4);
        } else if (standard == 1 && keyword.startsWith("OID.")) {
            keyword = keyword.substring(4);
        }
        boolean number = false;
        if (keyword.length() != 0 && (ch = keyword.charAt(0)) >= '0' && ch <= '9') {
            number = true;
        }
        if (!number) {
            throw new IOException("Invalid keyword \"" + keyword + "\"");
        }
        return new ObjectIdentifier(keyword);
    }

    static String getKeyword(ObjectIdentifier oid, int standard) {
        return AVAKeyword.getKeyword(oid, standard, Collections.EMPTY_MAP);
    }

    static String getKeyword(ObjectIdentifier oid, int standard, Map<String, String> extraOidMap) {
        String oidString = oid.toString();
        String keywordString = extraOidMap.get(oidString);
        if (keywordString == null) {
            AVAKeyword ak = oidMap.get(oid);
            if (ak != null && ak.isCompliant(standard)) {
                return ak.keyword;
            }
        } else {
            if (keywordString.length() == 0) {
                throw new IllegalArgumentException("keyword cannot be empty");
            }
            char c2 = (keywordString = keywordString.trim()).charAt(0);
            if (c2 < 'A' || c2 > 'z' || c2 > 'Z' && c2 < 'a') {
                throw new IllegalArgumentException("keyword does not start with letter");
            }
            for (int i2 = 1; i2 < keywordString.length(); ++i2) {
                c2 = keywordString.charAt(i2);
                if (c2 >= 'A' && c2 <= 'z' && (c2 <= 'Z' || c2 >= 'a') || c2 >= '0' && c2 <= '9' || c2 == '_') continue;
                throw new IllegalArgumentException("keyword character is not a letter, digit, or underscore");
            }
            return keywordString;
        }
        if (standard == 3) {
            return oidString;
        }
        return "OID." + oidString;
    }

    static boolean hasKeyword(ObjectIdentifier oid, int standard) {
        AVAKeyword ak = oidMap.get(oid);
        if (ak == null) {
            return false;
        }
        return ak.isCompliant(standard);
    }

    static {
        new AVAKeyword("CN", X500Name.commonName_oid, true, true);
        new AVAKeyword("C", X500Name.countryName_oid, true, true);
        new AVAKeyword("L", X500Name.localityName_oid, true, true);
        new AVAKeyword("S", X500Name.stateName_oid, false, false);
        new AVAKeyword("ST", X500Name.stateName_oid, true, true);
        new AVAKeyword("O", X500Name.orgName_oid, true, true);
        new AVAKeyword("OU", X500Name.orgUnitName_oid, true, true);
        new AVAKeyword("TITLE", X500Name.title_oid, false, false);
        new AVAKeyword("T", X500Name.title_oid, false, false);
        new AVAKeyword("IP", X500Name.ipAddress_oid, false, false);
        new AVAKeyword("STREET", X500Name.streetAddress_oid, true, true);
        new AVAKeyword("DC", X500Name.domainComponent_oid, false, true);
        new AVAKeyword("DNQ", X500Name.dnQualifier_oid, false, false);
        new AVAKeyword("DNQUALIFIER", X500Name.dnQualifier_oid, false, false);
        new AVAKeyword("PSEUDONYM", X500Name.pseudonym_oid, false, false);
        new AVAKeyword("SN", X500Name.surName_oid, false, false);
        new AVAKeyword("SURNAME", X500Name.surName_oid, false, false);
        new AVAKeyword("GIVENNAME", X500Name.givenName_oid, false, false);
        new AVAKeyword("INITIALS", X500Name.initials_oid, false, false);
        new AVAKeyword("GENERATION", X500Name.generationQualifier_oid, false, false);
        new AVAKeyword("GENERATIONQUALIFIER", X500Name.generationQualifier_oid, false, false);
        new AVAKeyword("EMAIL", X500Name.emailAddress_oid, false, false);
        new AVAKeyword("EMAILADDRESS", X500Name.emailAddress_oid, false, false);
        new AVAKeyword("UID", X500Name.userid_oid, false, true);
        new AVAKeyword("SERIALNUMBER", X500Name.serialNumber_oid, false, false);
        new AVAKeyword("POSTALCODE", X500Name.postalCode_oid, false, false);
    }
}

