/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime;

import com.ibm.misc.Debug;
import java.security.NoSuchAlgorithmException;

public final class SMIME {
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.SMIME";
    public static final String ENVELOPED_DATA_FILE_NAME = "smime.p7m";
    public static final String SIGNED_DATA_FILE_NAME = "smime.p7m";
    public static final String SIGNED_DATA_SIGNATURE_ONLY_FILE_NAME = "smime.p7s";
    public static final String SIGNED_DATA_CERTIFICATE_ONLY_FILE_NAME = "smime.p7c";
    public static final String SMIME_GENERIC_FILE_NAME = "smime.dat";
    public static final String CERTIFICATE_REQUEST_FILE_NAME = "smime.p10";
    public static final String SMIME_TYPE_SIGNED_DATA = "signed-data";
    public static final String SMIME_TYPE_CERTS_ONLY = "certs-only";
    public static final String SMIME_TYPE_ENVELOPED_DATA = "enveloped-data";
    public static final String SMIME_PROTOCOL_PKCS7_SIGNATURE = "pkcs7-signature";
    static final String XMAILER_HEADER = "IBM Security Software Development Kit SMIMESender";
    public static final int WEAK_ENCRYPTION = 1;
    private static final String WEAK_ENCRYPTION_ALGORITHM = "RC2";
    private static final int WEAK_ENCRYPTION_KEYLENGTH = 40;
    public static final int MEDIUM_ENCRYPTION = 2;
    private static final String MEDIUM_ENCRYPTION_ALGORITHM = "DES";
    private static final int MEDIUM_ENCRYPTION_KEYLENGTH = 56;
    public static final int STRONG_ENCRYPTION = 3;
    private static final String STRONG_ENCRYPTION_ALGORITHM = "DESede";
    private static final int STRONG_ENCRYPTION_KEYLENGTH = 168;

    public static String getEncryptionAlgorithm(int encryptionStrength) throws NoSuchAlgorithmException {
        String encryptionAlgorithm = null;
        if (debug != null) {
            debug.entry(49152L, (Object)className, "getEncryptionAlgorithm", new Integer(encryptionStrength));
        }
        switch (encryptionStrength) {
            case 1: {
                encryptionAlgorithm = WEAK_ENCRYPTION_ALGORITHM;
                break;
            }
            case 2: {
                encryptionAlgorithm = MEDIUM_ENCRYPTION_ALGORITHM;
                break;
            }
            case 3: {
                encryptionAlgorithm = STRONG_ENCRYPTION_ALGORITHM;
                break;
            }
            default: {
                if (debug != null) {
                    debug.text(49152L, className, "getEncryptionAlgorithm", "encryptionStrength was " + encryptionStrength + ".  encryptionStrength must be specified as WEAK_ENCRYPTION," + " MEDIUM_ENCRYPTION, or STRONG_ENCRYPTION.");
                }
                throw new IllegalArgumentException("encryptionStrength was " + encryptionStrength + ".  encryptionStrength must be specified as WEAK_ENCRYPTION," + " MEDIUM_ENCRYPTION, or STRONG_ENCRYPTION.");
            }
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getEncryptionAlgorithm", encryptionAlgorithm);
        }
        return encryptionAlgorithm;
    }

    public static int getEncryptionKeySize(int encryptionStrength) {
        int keyLength = 0;
        if (debug != null) {
            debug.entry(49152L, (Object)className, "getEncryptionKeySize", new Integer(encryptionStrength));
        }
        switch (encryptionStrength) {
            case 1: {
                keyLength = 40;
                break;
            }
            case 2: {
                keyLength = 56;
                break;
            }
            case 3: {
                keyLength = 168;
                break;
            }
            default: {
                if (debug != null) {
                    debug.text(49152L, className, "getEncryptionKeySize", "encryptionStrength was " + encryptionStrength + ".  encryptionStrength must be specified as WEAK_ENCRYPTION," + " MEDIUM_ENCRYPTION, or STRONG_ENCRYPTION.");
                }
                throw new IllegalArgumentException("encryptionStrength was " + encryptionStrength + ".  encryptionStrength must be specified as WEAK_ENCRYPTION," + " MEDIUM_ENCRYPTION, or STRONG_ENCRYPTION.");
            }
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getEncryptionKeySize", keyLength);
        }
        return keyLength;
    }
}

