/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs9.PKCS9;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.UnresolvedAttribute;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class PKCSAttribute
extends PKCSDerObject
implements DerEncoder,
Cloneable {
    private ObjectIdentifier attributeId;
    private Object attributeValue;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcsutil.PKCSAttribute";
    private volatile int cachedHashVal = 0;

    public PKCSAttribute(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttribute", (Object)der);
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttribute", der, provider);
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(ObjectIdentifier id, Object value) throws IOException {
        this(id, value, null);
        if (debug != null) {
            Object[] parms = new Object[]{id, value};
            debug.entry(16384L, (Object)className, "PKCSAttribute", parms);
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(ObjectIdentifier id, Object value, String provider) throws IOException {
        super(provider);
        String name;
        if (debug != null) {
            Object[] parms = new Object[]{id, value};
            debug.entry(16384L, (Object)className, "PKCSAttribute", parms);
        }
        if ((name = PKCS9.getName(id)) != null) {
            PKCS9DerObject obj = PKCS9.getPKCS9Attribute(id, value);
            if (obj == null) {
                if (debug != null) {
                    debug.text(16384L, className, "PKCSAttribute", "Class " + value.getClass().getName() + " does not match the class required for Object Identifier " + id);
                }
                throw new IllegalArgumentException("Class " + value.getClass().getName() + " does not match the class required for Object Identifier " + id);
            }
        } else {
            if (!(value instanceof byte[])) {
                if (debug != null) {
                    debug.text(16384L, className, "PKCSAttribute", "Non-standard Attribute value must be a byte array");
                }
                throw new IOException("Non-standard Attribute value must be a byte array");
            }
            DerValue der = new DerValue((byte[])value);
            if (der.getTag() != 49) {
                if (debug != null) {
                    debug.text(16384L, className, "PKCSAttribute", "Non-standard Attribute value must be a SET OF DER value");
                }
                throw new IOException("Non-standard Attribute value must be a SET OF DER value");
            }
        }
        this.attributeId = id;
        this.attributeValue = value;
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(PKCS9DerObject attr) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttribute", attr);
        }
        this.attributeId = attr.getObjectIdentifier();
        this.attributeValue = attr.getValue();
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(PKCS9DerObject attr, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttribute", attr, provider);
        }
        this.attributeId = attr.getObjectIdentifier();
        this.attributeValue = attr.getValue();
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(UnresolvedAttribute attr) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttribute", attr);
        }
        this.attributeId = attr.getObjectIdentifier();
        this.attributeValue = attr.getValue();
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(UnresolvedAttribute attr, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttribute", attr, provider);
        }
        this.attributeId = attr.getObjectIdentifier();
        this.attributeValue = attr.getValue();
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64)};
            debug.entry(16384L, (Object)className, "PKCSAttribute", parms);
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "PKCSAttribute", parms);
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
                debug.exit(16384L, (Object)className, "clone", new PKCSAttribute(this.attributeId, this.attributeValue, this.provider));
            }
            return new PKCSAttribute(this.attributeId, this.attributeValue, this.provider);
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", obj);
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof PKCSAttribute) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", this.equals((PKCSAttribute)obj));
            }
            return this.equals((PKCSAttribute)obj);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", false);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        this.derEncode(out);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        String name;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", out);
        }
        if ((name = PKCS9.getName(this.attributeId)) != null) {
            PKCS9DerObject attr = PKCS9.getPKCS9Attribute(this.attributeId, this.attributeValue);
            attr.encode(out);
        } else {
            UnresolvedAttribute attr = new UnresolvedAttribute(this.attributeId, this.attributeValue, this.provider);
            attr.encode(out);
        }
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    public ObjectIdentifier getAttributeId() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeId");
            debug.exit(16384L, (Object)className, "getAttributeId", this.attributeId);
        }
        return this.attributeId;
    }

    public Object getAttributeValue() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeValue");
        }
        PKCSAttribute attr = new PKCSAttribute(this.attributeId, this.attributeValue, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAttributeValue", attr.attributeValue);
        }
        return attr.attributeValue;
    }

    @Override
    public String toString() {
        String val;
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "Object Identifier: ";
        out = out + this.attributeId.toString();
        String oidname = PKCS9.getName(this.attributeId);
        if (oidname != null) {
            out = out + " (" + oidname + ")";
        }
        out = out + "\r\n";
        out = out + "Value:\r\n";
        if (this.attributeValue instanceof byte[]) {
            HexDumpEncoder hd = new HexDumpEncoder();
            val = hd.encodeBuffer((byte[])this.attributeValue);
        } else if (this.attributeValue instanceof String[]) {
            String[] strs = (String[])this.attributeValue;
            val = "";
            for (int i2 = 0; i2 < strs.length; ++i2) {
                val = val + strs[i2] + " ";
            }
        } else {
            val = this.attributeValue.toString();
        }
        out = out + val;
        out = out + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    public PKCS9DerObject getPKCS9DerObject() {
        if (debug != null) {
            debug.entry(16384L, className, "getPKCS9DerObject");
            debug.exit(16384L, (Object)className, "getPKCS9DerObject", PKCS9.getPKCS9Attribute(this.attributeId, this.attributeValue));
        }
        return PKCS9.getPKCS9Attribute(this.attributeId, this.attributeValue);
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PKCS Attribute encoding error");
            }
            throw new IOException("PKCS Attribute encoding error");
        }
        DerInputStream derIn = new DerInputStream(encoding.toByteArray());
        DerValue[] val = derIn.getSequence(2);
        if (derIn.available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Excess data parsing PKCS Attribute");
            }
            throw new IOException("Excess data parsing PKCS Attribute");
        }
        if (val.length != 2) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PKCS Attribute doesn't have two components");
            }
            throw new IOException("PKCS Attribute doesn't have two components");
        }
        ObjectIdentifier oid = val[0].getOID();
        String name = PKCS9.getName(oid);
        if (name != null) {
            PKCS9DerObject attr = PKCS9.getPKCS9Attribute(encoding.toByteArray());
            this.attributeValue = attr.getValue();
        } else {
            UnresolvedAttribute attr = new UnresolvedAttribute(encoding.toByteArray());
            this.attributeValue = attr.getValue();
        }
        this.attributeId = oid;
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(PKCSAttribute other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", e2);
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

