/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public final class OptionalValidity
extends CMPDerObject {
    private Date notBefore;
    private Date notAfter;
    private boolean beforeUTCTime;
    private boolean afterUTCTime;
    private static final byte TAG_NOT_BEFORE = 0;
    private static final byte TAG_NOT_AFTER = 1;

    public OptionalValidity(Date date, Date date2) {
        if (date == null && date2 == null) {
            throw new IllegalArgumentException("At least one of the times (notBefore and notAfter) must be specified.");
        }
        this.notBefore = date;
        this.notAfter = date2;
        this.beforeUTCTime = true;
        this.afterUTCTime = true;
    }

    public OptionalValidity(Date date, boolean bl, Date date2, boolean bl2) {
        if (date == null && date2 == null) {
            throw new IllegalArgumentException("At least one of the times (notBefore and notAfter) must be specified.");
        }
        this.notBefore = date;
        this.notAfter = date2;
        this.beforeUTCTime = bl;
        this.afterUTCTime = bl2;
    }

    public OptionalValidity(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new OptionalValidity(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void decode(DerValue derValue) throws IOException {
        int n2;
        DerValue derValue2 = null;
        if (derValue.getTag() != 48) {
            throw new IOException("OptionalValidity parsing error, not a SEQUENCE");
        }
        this.notBefore = null;
        this.notAfter = null;
        boolean bl = false;
        if (derValue.getData().available() == 0) throw new IOException("OptionalValidity parsing error, data missing");
        derValue2 = derValue.getData().getDerValue();
        if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
            bl = true;
            n2 = derValue2.getData().peekByte();
            if ((byte)n2 == 23) {
                this.notBefore = derValue2.getData().getUTCTime();
                this.beforeUTCTime = true;
            } else {
                if ((byte)n2 != 24) throw new IOException("OptionalValidity parsing error, invalid tag");
                this.notBefore = derValue2.getData().getGeneralizedTime();
                this.beforeUTCTime = false;
            }
        }
        if (bl) {
            if (derValue.getData().available() == 0) return;
            derValue2 = derValue.getData().getDerValue();
        }
        if (!derValue2.isContextSpecific((byte)1) || !derValue2.isConstructed()) throw new IOException("OptionalValidity parsing error, invalid data");
        n2 = derValue2.getData().peekByte();
        if ((byte)n2 == 23) {
            this.notAfter = derValue2.getData().getUTCTime();
            this.afterUTCTime = true;
        } else {
            if ((byte)n2 != 24) throw new IOException("OptionalValidity parsing error, invalid tag");
            this.notAfter = derValue2.getData().getGeneralizedTime();
            this.afterUTCTime = false;
        }
        if (derValue.getData().available() == 0) return;
        throw new IOException("OptionalValidity parsing error, data overrun");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.notBefore == null && this.notAfter == null) {
            throw new IOException("OptionalValidity encoding error, at least one of the times must be specified");
        }
        if (this.notBefore != null) {
            derOutputStream = new DerOutputStream();
            if (this.beforeUTCTime) {
                derOutputStream.putUTCTime(this.notBefore);
            } else {
                derOutputStream.putGeneralizedTime(this.notBefore);
            }
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        }
        if (this.notAfter != null) {
            derOutputStream = new DerOutputStream();
            if (this.afterUTCTime) {
                derOutputStream.putUTCTime(this.notAfter);
            } else {
                derOutputStream.putGeneralizedTime(this.notAfter);
            }
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        }
        derOutputStream3.write((byte)48, derOutputStream2);
        outputStream.write(derOutputStream3.toByteArray());
    }

    public boolean equals(OptionalValidity optionalValidity) {
        DerValue derValue;
        DerValue derValue2;
        if (optionalValidity == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            optionalValidity.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof OptionalValidity) {
            return this.equals((OptionalValidity)object);
        }
        return false;
    }

    public Date getNotAfter() {
        if (this.notAfter == null) {
            return null;
        }
        return (Date)this.notAfter.clone();
    }

    public Date getNotBefore() {
        if (this.notBefore == null) {
            return null;
        }
        return (Date)this.notBefore.clone();
    }

    public boolean isNotAfterUTC() {
        return this.afterUTCTime;
    }

    public boolean isNotBeforeUTC() {
        return this.beforeUTCTime;
    }

    public String toString() {
        String string = "OptionalValidity:";
        if (this.notBefore != null) {
            string = this.beforeUTCTime ? String.valueOf(string) + "\r\n\tnotBefore: UTCTime " + this.notBefore.toString() : String.valueOf(string) + "\r\n\tnotBefore: GeneralizedTime " + this.notBefore.toString();
        }
        if (this.notAfter != null) {
            string = this.afterUTCTime ? String.valueOf(string) + "\r\n\tnotAfter: UTCTime " + this.notAfter.toString() : String.valueOf(string) + "\r\n\tnotAfter: GeneralizedTime " + this.notAfter.toString();
        }
        return string;
    }
}

