/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.CertifiedKeyPair;
import com.ibm.security.cmp.PKIStatusInfo;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public final class CertResponse
extends CMPDerObject {
    private BigInteger certReqId;
    private PKIStatusInfo status;
    private CertifiedKeyPair certifiedKeyPair;
    private byte[] rspInfo;

    public CertResponse(BigInteger bigInteger, PKIStatusInfo pKIStatusInfo, CertifiedKeyPair certifiedKeyPair, byte[] byArray) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("CertResponse error, certificate request ID not specified");
        }
        if (pKIStatusInfo == null) {
            throw new IllegalArgumentException("CertResponse error, status not specified");
        }
        this.certReqId = bigInteger;
        this.status = pKIStatusInfo;
        this.certifiedKeyPair = certifiedKeyPair;
        this.rspInfo = (byte[])(byArray != null ? (byte[])byArray.clone() : null);
    }

    public CertResponse(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new CertResponse(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("CertResponse parsing error, not a SEQUENCE");
        }
        this.certReqId = null;
        this.status = null;
        this.certifiedKeyPair = null;
        this.rspInfo = null;
        if (derValue.getData().available() == 0) {
            throw new IOException("CertResponse parsing error, missing data");
        }
        this.certReqId = derValue.getData().getInteger();
        if (derValue.getData().available() == 0) {
            throw new IOException("CertResponse parsing error, missing data");
        }
        this.status = new PKIStatusInfo(derValue.getData().getDerValue().toByteArray());
        if (derValue.getData().available() == 0) {
            return;
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() == 48) {
            this.certifiedKeyPair = new CertifiedKeyPair(derValue2.toByteArray());
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
            } else {
                return;
            }
        }
        if (derValue2.getTag() != 4) {
            throw new IOException("CertResponse parsing error, invalid data");
        }
        this.rspInfo = derValue2.getOctetString();
        if (derValue.getData().available() != 0) {
            throw new IOException("CertResponse parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.certReqId == null) {
            throw new IOException("CertResponse encoding error, cert request ID not specified");
        }
        derOutputStream.putInteger(this.certReqId);
        if (this.status == null) {
            throw new IOException("CertResponse encoding error, status info not specified");
        }
        this.status.encode(derOutputStream);
        if (this.certifiedKeyPair != null) {
            this.certifiedKeyPair.encode(derOutputStream);
        }
        if (this.rspInfo != null) {
            derOutputStream.putOctetString(this.rspInfo);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(CertResponse certResponse) {
        DerValue derValue;
        DerValue derValue2;
        if (certResponse == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            certResponse.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CertResponse) {
            return this.equals((CertResponse)object);
        }
        return false;
    }

    public BigInteger getCertReqId() {
        return new BigInteger(this.certReqId.toByteArray());
    }

    public CertifiedKeyPair getCertifiedKeyPair() {
        if (this.certifiedKeyPair == null) {
            return null;
        }
        return (CertifiedKeyPair)this.certifiedKeyPair.clone();
    }

    public byte[] getResponseInfo() {
        if (this.rspInfo == null) {
            return null;
        }
        return (byte[])this.rspInfo.clone();
    }

    public PKIStatusInfo getStatusInfo() {
        return (PKIStatusInfo)this.status.clone();
    }

    public String toString() {
        String string = "CertResponse:";
        if (this.certReqId != null) {
            string = String.valueOf(string) + "\r\n\tcertReqId: " + this.certReqId.toString();
        }
        if (this.status != null) {
            string = String.valueOf(string) + "\r\n\tstatus: " + this.status.toString();
        }
        if (this.certifiedKeyPair != null) {
            string = String.valueOf(string) + "\r\n\tcertified key pair: " + this.certifiedKeyPair.toString();
        }
        if (this.rspInfo != null) {
            string = String.valueOf(string) + "\r\n\trsp info: " + new String(this.rspInfo);
        }
        return string;
    }
}

