/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.CertResponse;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;

public final class CertRepMessage
extends CMPDerObject {
    private Certificate[] caPubs;
    private CertResponse[] response;
    private static final byte TAG_CA_PUBS = 1;

    public CertRepMessage(byte[] byArray) throws IOException {
        super(byArray);
    }

    public CertRepMessage(Certificate[] certificateArray, CertResponse[] certResponseArray) {
        if (certResponseArray == null) {
            throw new IllegalArgumentException("CertRepMessage error, response not specified");
        }
        if (certResponseArray.length == 0) {
            throw new IllegalArgumentException("CertRepMessage error, there should be at least one response");
        }
        if (certificateArray != null) {
            if (certificateArray.length == 0) {
                throw new IllegalArgumentException("CertRepMessage error, there should be at least one certificate");
            }
            int n2 = 0;
            while (n2 < certificateArray.length) {
                if (!(certificateArray[n2] instanceof X509Certificate)) {
                    throw new IllegalArgumentException("CertRepMessage error, invalid certificate type. Only X509 certificate is supported");
                }
                ++n2;
            }
        }
        this.caPubs = certificateArray;
        this.response = certResponseArray;
    }

    public CertRepMessage addCACert(Certificate[] certificateArray) {
        CertRepMessage certRepMessage = (CertRepMessage)this.clone();
        if (certificateArray == null || certificateArray.length == 0) {
            return certRepMessage;
        }
        if (certRepMessage.caPubs == null) {
            certRepMessage.caPubs = certificateArray;
        } else {
            int n2 = certRepMessage.caPubs.length + certificateArray.length;
            Certificate[] certificateArray2 = new Certificate[n2];
            int n3 = certRepMessage.caPubs.length;
            int n4 = 0;
            while (n3 < n2) {
                if (!(certificateArray[n4] instanceof X509Certificate)) {
                    throw new IllegalArgumentException("CertRepMessage error, invalid certificate type. Only X509 certificate is supported");
                }
                certificateArray2[n3] = certificateArray[n4];
                ++n3;
                ++n4;
            }
            int n5 = 0;
            while (n5 < certRepMessage.caPubs.length) {
                certificateArray2[n5] = certRepMessage.caPubs[n5];
                ++n5;
            }
            certRepMessage.caPubs = certificateArray2;
        }
        return certRepMessage;
    }

    public CertRepMessage addResponse(CertResponse[] certResponseArray) {
        CertRepMessage certRepMessage = (CertRepMessage)this.clone();
        if (certResponseArray == null || certResponseArray.length == 0) {
            return certRepMessage;
        }
        if (certRepMessage.response == null) {
            certRepMessage.response = certResponseArray;
        } else {
            int n2 = certRepMessage.response.length + certResponseArray.length;
            CertResponse[] certResponseArray2 = new CertResponse[n2];
            int n3 = 0;
            while (n3 < certRepMessage.response.length) {
                certResponseArray2[n3] = certRepMessage.response[n3];
                ++n3;
            }
            int n4 = certRepMessage.response.length;
            int n5 = 0;
            while (n4 < n2) {
                certResponseArray2[n4] = certResponseArray[n5];
                ++n4;
                ++n5;
            }
            certRepMessage.response = certResponseArray2;
        }
        return certRepMessage;
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new CertRepMessage(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        Object object;
        Object object2;
        if (derValue.getTag() != 48) {
            throw new IOException("CertRepMessage parsing error, not a SEQUENCE");
        }
        DerValue derValue2 = null;
        this.caPubs = null;
        this.response = null;
        if (derValue.getData().available() == 0) {
            throw new IOException("CertRepMessage parsing error, missing data");
        }
        derValue2 = derValue.getData().getDerValue();
        this.caPubs = null;
        this.response = null;
        if (derValue2.isContextSpecific((byte)1) && derValue2.isConstructed()) {
            object2 = derValue2.getData().getDerValue();
            if (((DerValue)object2).getTag() != 48) {
                throw new IOException("CertRepMessage parsing error, not a SEQUENCE OF");
            }
            object = new Vector();
            while (((DerValue)object2).getData().available() != 0) {
                DerValue derValue3 = ((DerValue)object2).getData().getDerValue();
                try {
                    X509CertImpl x509CertImpl = new X509CertImpl(derValue3);
                    ((Vector)object).add(x509CertImpl);
                }
                catch (CertificateException certificateException) {
                    throw new IOException("CertRepMessage parsing error, " + certificateException);
                }
            }
            if (((Vector)object).size() > 0) {
                this.caPubs = new X509CertImpl[((Vector)object).size()];
                int n2 = 0;
                while (n2 < ((Vector)object).size()) {
                    this.caPubs[n2] = (X509CertImpl)((Vector)object).elementAt(n2);
                    ++n2;
                }
            }
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
            } else {
                throw new IOException("CertRepMessage parsing error, missing data");
            }
        }
        if (derValue2.getTag() != 48) {
            throw new IOException("CertRepMessage parsing error, not a SEQUENCE OF");
        }
        object2 = new Vector();
        while (derValue2.getData().available() != 0) {
            object = derValue2.getData().getDerValue();
            CertResponse certResponse = new CertResponse(((DerValue)object).toByteArray());
            ((Vector)object2).add(certResponse);
        }
        if (((Vector)object2).size() > 0) {
            this.response = new CertResponse[((Vector)object2).size()];
            int n3 = 0;
            while (n3 < ((Vector)object2).size()) {
                this.response[n3] = (CertResponse)((Vector)object2).elementAt(n3);
                ++n3;
            }
        } else {
            throw new IOException("CertRepMessage parsing error, missing data");
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("CertRepMessage parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.caPubs != null) {
            derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream4 = new DerOutputStream();
            try {
                int n2 = 0;
                while (n2 < this.caPubs.length) {
                    if (!(this.caPubs[n2] instanceof X509Certificate)) {
                        throw new IOException("caPubs[" + n2 + "] has a type of " + this.caPubs[n2].getClass().getName() + ". Only instances of java.security.cert.X509Certificate are supported");
                    }
                    derOutputStream4.write(this.caPubs[n2].getEncoded());
                    ++n2;
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("CertRepMessage encoding error, " + certificateEncodingException);
            }
            derOutputStream.write((byte)48, derOutputStream4);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        }
        if (this.response != null) {
            derOutputStream = new DerOutputStream();
            int n3 = 0;
            while (n3 < this.response.length) {
                this.response[n3].encode(derOutputStream);
                ++n3;
            }
        } else {
            throw new IOException("CertRepMessage encoding error, response not specified");
        }
        derOutputStream2.write((byte)48, derOutputStream);
        derOutputStream3.write((byte)48, derOutputStream2);
        outputStream.write(derOutputStream3.toByteArray());
    }

    public boolean equals(CertRepMessage certRepMessage) {
        DerValue derValue;
        DerValue derValue2;
        if (certRepMessage == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            certRepMessage.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CertRepMessage) {
            return this.equals((CertRepMessage)object);
        }
        return false;
    }

    public Certificate[] getCAPubs() {
        if (this.caPubs == null) {
            return null;
        }
        return (Certificate[])this.caPubs.clone();
    }

    public CertResponse[] getResponse() {
        if (this.response == null) {
            return null;
        }
        return (CertResponse[])this.response.clone();
    }

    public String toString() {
        int n2;
        String string = "CertRepMessage:";
        if (this.caPubs == null || this.caPubs.length == 0) {
            string = String.valueOf(string) + "\r\n\tNo CA Certificates";
        } else {
            n2 = 0;
            while (n2 < this.caPubs.length) {
                string = String.valueOf(string) + "\r\n\tcertificate[" + n2 + "]\r\n";
                string = String.valueOf(string) + this.caPubs[n2].toString();
                string = String.valueOf(string) + "\r\n";
                ++n2;
            }
        }
        if (this.response == null || this.response.length == 0) {
            string = String.valueOf(string) + "\r\n\tNo CertResponse";
        } else {
            n2 = 0;
            while (n2 < this.response.length) {
                string = String.valueOf(string) + "\r\n\tcert response[" + n2 + "]\r\n";
                string = String.valueOf(string) + this.response[n2].toString();
                string = String.valueOf(string) + "\r\n";
                ++n2;
            }
        }
        return string;
    }
}

