/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.embeddable;

import com.ibm.wsspi.kernel.embeddable.Server;
import com.ibm.wsspi.kernel.embeddable.ServerEventListener;
import com.ibm.wsspi.kernel.embeddable.ServerException;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;

public class ServerBuilder {
    private String serverName = null;
    private File userDir = null;
    private File outputDir = null;
    private File logDir = null;
    private ServerEventListener listener = null;
    private File installDir;
    private HashMap<String, Properties> productExtensions = null;

    public ServerBuilder setName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public ServerBuilder setUserDir(File userDir) {
        this.userDir = userDir;
        return this;
    }

    public ServerBuilder setOutputDir(File outputDir) {
        this.outputDir = outputDir;
        return this;
    }

    public ServerBuilder setLogDir(File logDir) {
        this.logDir = logDir;
        return this;
    }

    public ServerBuilder setInstallDir(File install) {
        this.installDir = install;
        return this;
    }

    public ServerBuilder setServerEventListener(ServerEventListener listener) {
        this.listener = listener;
        return this;
    }

    public Server build() throws ServerException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Server>(){

                @Override
                public Server run() {
                    return ServerBuilder.this.buildWithPriv();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception target = e.getException();
            if (target instanceof ServerException) {
                throw (ServerException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            throw new InvalidInstallException(target);
        }
    }

    public ServerBuilder addProductExtension(String name, Properties props) {
        if (name != null && props != null) {
            if (this.productExtensions == null) {
                this.productExtensions = new HashMap();
            }
            this.productExtensions.put(name, props);
        }
        return this;
    }

    private Server buildWithPriv() {
        ClassLoader cl = ServerBuilder.class.getClassLoader();
        if (this.installDir != null) {
            File wsServerJar = new File(this.installDir, "bin/tools/ws-server.jar");
            if (wsServerJar.exists()) {
                try {
                    cl = new URLClassLoader(new URL[]{wsServerJar.toURI().toURL()}, cl);
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                FileNotFoundException e = new FileNotFoundException(this.installDir.getAbsolutePath());
                throw new InvalidInstallException(e);
            }
        }
        try {
            Class<?> clazz = cl.loadClass("com.ibm.ws.kernel.boot.EmbeddedServerImpl");
            Constructor<?> con = clazz.getConstructor(String.class, File.class, File.class, File.class, ServerEventListener.class, HashMap.class);
            Server server = (Server)con.newInstance(this.serverName, this.userDir, this.outputDir, this.logDir, this.listener, this.productExtensions);
            return server;
        }
        catch (ClassNotFoundException e) {
            throw new InvalidInstallException(e);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidInstallException(e);
        }
        catch (InstantiationException e) {
            throw new InvalidInstallException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidInstallException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidInstallException(e);
        }
        catch (InvocationTargetException e) {
            throw new InvalidInstallException(e);
        }
    }

    private static class InvalidInstallException
    extends ServerException {
        private static final long serialVersionUID = -1897435497398897268L;

        public InvalidInstallException(Throwable cause) {
            super(cause.getMessage(), cause.getMessage(), cause);
        }
    }
}

