/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.jcache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serialization.SerializationService;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.jcache.CacheManagerService;
import io.openliberty.jcache.CacheService;
import io.openliberty.jcache.DeserializationException;
import io.openliberty.jcache.SerializationException;
import io.openliberty.jcache.internal.CacheManagerServiceImpl;
import io.openliberty.jcache.internal.CacheProxy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"io.openliberty.jcache.cache"}, property={"service.vendor=IBM"})
public class CacheServiceImpl
implements CacheService {
    private static final TraceComponent tc = Tr.register(CacheServiceImpl.class, (String)"jcache", (String)"io.openliberty.jcache.internal.resources.JCacheMessages");
    private static final String KEY_CACHE_NAME = "name";
    private static final String KEY_ID = "id";
    private CacheManagerService cacheManagerService = null;
    private SerializationService serializationService = null;
    private ScheduledExecutorService scheduledExecutorService = null;
    private ScheduledFuture<?> getCacheFuture = null;
    private String cacheName = null;
    private Cache<Object, Object> cache = null;
    private Object syncObject = new Object();
    private String id;
    private static final Set<String> NOTSERIALIZABLE_CLASSES_LOGGED = new HashSet<String>();
    private Object closeSyncObject = null;
    static final long serialVersionUID = -834323694981261550L;

    @Activate
    public void activate(Map<String, Object> configProps) {
        this.id = (String)configProps.get(KEY_ID);
        this.cacheName = (String)configProps.get(KEY_CACHE_NAME);
        CheckpointPhase.onRestore(() -> {
            this.getCacheFuture = this.scheduledExecutorService.schedule(new Runnable(){
                static final long serialVersionUID = -5666725693501979368L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    CacheServiceImpl.this.getCache();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.jcache.internal.CacheServiceImpl$1", 1.class, (String)"jcache", (String)"io.openliberty.jcache.internal.resources.JCacheMessages");
                }
            }, 0L, TimeUnit.SECONDS);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    @FFDCIgnore(value={Exception.class})
    public void deactivate() {
        if (this.cache != null && !this.cache.isClosed()) {
            try {
                Object object = this.closeSyncObject;
                synchronized (object) {
                    if (!this.cache.isClosed()) {
                        this.cache.close();
                    }
                }
            }
            catch (Exception e) {
                Tr.warning((TraceComponent)tc, (String)"CWLJC0012_CLOSE_CACHE_ERR", (Object[])new Object[]{this.cacheName, e});
            }
        }
        this.cache = null;
        this.getCacheFuture = null;
        this.closeSyncObject = null;
        NOTSERIALIZABLE_CLASSES_LOGGED.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Sensitive
    public Object deserialize(@Sensitive byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = this.serializationService.createObjectInputStream((InputStream)bais, this.cacheManagerService.getCachingProviderService().getUnifiedClassLoader());
            return ois.readObject();
        }
        catch (IOException | ClassNotFoundException bais) {
            void e;
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive byte[]>";
            FFDCFilter.processException((Throwable)bais, (String)"io.openliberty.jcache.internal.CacheServiceImpl", (String)"143", (Object)this, (Object[])objectArray);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"CWLJC0008_DESERIALIZE_ERR", (Object[])new Object[]{this.cacheName, e});
            throw new DeserializationException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Sensitive
    public byte[] serialize(@Sensitive Object o) {
        if (o == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = this.serializationService.createObjectOutputStream((OutputStream)baos);
            oos.writeObject(o);
            return baos.toByteArray();
        }
        catch (IOException baos) {
            void e;
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive java.lang.Object>";
            FFDCFilter.processException((Throwable)baos, (String)"io.openliberty.jcache.internal.CacheServiceImpl", (String)"160", (Object)this, (Object[])objectArray);
            this.throwSerializationException((Exception)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache<Object, Object> getCache() {
        if (this.cache == null) {
            Object object = this.syncObject;
            synchronized (object) {
                if (this.cache == null) {
                    this.cache = AccessController.doPrivileged(() -> {
                        CacheProxy tCache = null;
                        if (this.cacheManagerService == null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"It appears that perhaps the CacheManagerService was stopped after this task was started. Perhaps a configuration change was processed?", (Object[])new Object[0]);
                            }
                            return null;
                        }
                        CacheManager cacheManager = null;
                        long loadTimeMs = 0L;
                        try {
                            cacheManager = this.cacheManagerService.getCacheManager();
                            if (cacheManager == null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"It appears that the CacheManagerService was unable to get a CacheManager instance. Perhaps a configuration change was processed?", (Object[])new Object[0]);
                                }
                                return null;
                            }
                            loadTimeMs = System.currentTimeMillis();
                            Cache jCache = cacheManager.getCache(this.cacheName);
                            loadTimeMs = System.currentTimeMillis() - loadTimeMs;
                            if (jCache != null) {
                                tCache = new CacheProxy((Cache<Object, Object>)jCache, this);
                            }
                        }
                        catch (Throwable e) {
                            Tr.warning((TraceComponent)tc, (String)"CWLJC0011_GET_CACHE_ERR", (Object[])new Object[]{this.cacheName, e});
                        }
                        if (tCache == null) {
                            MutableConfiguration config = new MutableConfiguration();
                            config.setTypes(Object.class, Object.class);
                            loadTimeMs = System.currentTimeMillis();
                            tCache = new CacheProxy((Cache<Object, Object>)cacheManager.createCache(this.cacheName, (Configuration)config), this);
                            loadTimeMs = System.currentTimeMillis() - loadTimeMs;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
                                Tr.info((TraceComponent)tc, (String)"CWLJC0001_CACHE_CREATED", (Object[])new Object[]{this.cacheName, loadTimeMs, this.cacheManagerService.getCachingProviderService().getCachingProvider().getClass().getName()});
                            }
                        } else if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
                            Tr.info((TraceComponent)tc, (String)"CWLJC0002_CACHE_FOUND", (Object[])new Object[]{this.cacheName, loadTimeMs, this.cacheManagerService.getCachingProviderService().getCachingProvider().getClass().getName()});
                        }
                        return tCache;
                    });
                }
            }
        }
        return this.cache;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setCacheManagerService(CacheManagerService service) {
        this.cacheManagerService = service;
        this.closeSyncObject = ((CacheManagerServiceImpl)service).getCloseSyncObject();
    }

    public void unsetCacheManagerService(CacheManagerService service) {
        this.waitForBackgroundTask();
        if (this.cache != null) {
            this.cache.close();
        }
        this.cache = null;
        this.getCacheFuture = null;
        this.cacheManagerService = null;
    }

    @Reference(name="scheduledExecutorService", service=ScheduledExecutorService.class, target="(deferrable=false)")
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void unsetScheduledExecutorService(ServiceReference<ScheduledExecutorService> scheduledExecutorService) {
        this.scheduledExecutorService = null;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    public void unsetSerializationService(SerializationService serializationService) {
        this.serializationService = null;
    }

    public String toString() {
        return super.toString() + "{id=" + this.id + ", cacheName=" + this.cacheName + "}";
    }

    private void throwSerializationException(Exception cause) {
        String msg = Tr.formatMessage((TraceComponent)tc, (String)"CWLJC0009_SERIALIZE_ERR", (Object[])new Object[]{this.cacheName, cause});
        if (cause instanceof NotSerializableException) {
            String className = cause.getMessage();
            if (!NOTSERIALIZABLE_CLASSES_LOGGED.contains(className)) {
                NOTSERIALIZABLE_CLASSES_LOGGED.add(className);
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            }
        }
        throw new SerializationException(msg, cause);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForBackgroundTask() {
        block5: {
            if (this.getCacheFuture != null && !this.getCacheFuture.isDone()) {
                boolean shouldTrace = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
                try {
                    if (shouldTrace) {
                        Tr.debug((TraceComponent)tc, (String)"Started waiting for background task to finish.", (Object[])new Object[0]);
                    }
                    this.getCacheFuture.get(60L, TimeUnit.SECONDS);
                    if (shouldTrace) {
                        Tr.debug((TraceComponent)tc, (String)"Finished waiting for background task to finish.", (Object[])new Object[0]);
                    }
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.jcache.internal.CacheServiceImpl", (String)"372", (Object)this, (Object[])new Object[0]);
                    if (!shouldTrace) break block5;
                    Tr.debug((TraceComponent)tc, (String)("Caught the following exception while waiting for background task to finish: " + e), (Object[])new Object[0]);
                }
            }
        }
    }
}

