/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import java.util.HashSet;
import java.util.List;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class OpenAPIValidator
extends TypeValidator<OpenAPI> {
    private static final TraceComponent tc = Tr.register(OpenAPIValidator.class);
    private static final OpenAPIValidator INSTANCE = new OpenAPIValidator();

    public static OpenAPIValidator getInstance() {
        return INSTANCE;
    }

    private OpenAPIValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, OpenAPI t) {
        if (t != null) {
            List tags;
            String openapiVersion = t.getOpenapi();
            ValidatorUtils.validateRequiredField(openapiVersion, context, "openapi").ifPresent(helper::addValidationEvent);
            ValidatorUtils.validateRequiredField(t.getInfo(), context, "info").ifPresent(helper::addValidationEvent);
            ValidatorUtils.validateRequiredField(t.getPaths(), context, "paths").ifPresent(helper::addValidationEvent);
            if (openapiVersion != null && !openapiVersion.startsWith("3.")) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"openAPIVersionInvalid", (Object[])new Object[]{openapiVersion});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if ((tags = t.getTags()) != null) {
                HashSet<String> tagNames = new HashSet<String>();
                for (Tag tag : tags) {
                    if (tagNames.add(tag.getName())) continue;
                    String message = Tr.formatMessage((TraceComponent)tc, (String)"openAPITagIsNotUnique", (Object[])new Object[]{tag.getName()});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                }
            }
        }
    }
}

