/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility.extension;

import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.product.utility.BaseCommandTask;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.ExecutionContext;
import com.ibm.ws.product.utility.extension.IFixUtils;
import com.ibm.ws.product.utility.extension.VersionUtils;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import com.ibm.ws.product.utility.extension.ifix.xml.Problem;
import com.ibm.ws.product.utility.extension.ifix.xml.Resolves;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VersionCommandTask
extends BaseCommandTask {
    private static final String VERBOSE_OPTION = "--verbose";
    private static final String IFIXES_OPTION = "--ifixes";
    public static final String COM_IBM_WEBSPHERE_PRODUCTREPLACES_KEY = "com.ibm.websphere.productReplaces";
    public static final String VERSION_TASK_NAME = "version";

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>(Arrays.asList(IFIXES_OPTION, VERBOSE_OPTION));
    }

    @Override
    public String getTaskName() {
        return VERSION_TASK_NAME;
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("version.desc", new Object[0]);
    }

    @Override
    public String getTaskHelp() {
        return super.getTaskHelp("version.desc", "version.usage.options", "version.option-key.", "version.option-desc.", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute(ExecutionContext context) {
        CommandConsole commandConsole = context.getCommandConsole();
        File installDir = context.getAttribute("WLP_INSTALLATION_LOCATION", File.class);
        Map<String, ProductInfo> productIdToVersionPropertiesMap = null;
        try {
            productIdToVersionPropertiesMap = VersionUtils.getAllProductInfo(installDir);
        }
        catch (VersionUtils.VersionParsingException e1) {
            commandConsole.printErrorMessage(e1.getMessage());
            return;
        }
        boolean verboseDisplayMode = context.optionExists(VERBOSE_OPTION);
        for (ProductInfo versionProperties : productIdToVersionPropertiesMap.values()) {
            block21: {
                block20: {
                    BufferedReader bufferedReader;
                    if (!verboseDisplayMode) break block21;
                    File file = versionProperties.getFile();
                    commandConsole.printlnInfoMessage(file.getName() + ":");
                    BufferedReader bufferedReader2 = null;
                    try {
                        String currentLine;
                        bufferedReader = new BufferedReader(new FileReader(versionProperties.getFile()));
                        while ((currentLine = bufferedReader.readLine()) != null) {
                            if (currentLine.startsWith("#")) continue;
                            commandConsole.printlnInfoMessage("\t" + currentLine);
                        }
                        if (bufferedReader == null) break block20;
                    }
                    catch (IOException e) {
                        commandConsole.printlnErrorMessage(this.getMessage("ERROR_UNABLE_READ_FILE", versionProperties.getFile().getAbsoluteFile(), e.getMessage()));
                        return;
                    }
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception currentLine) {}
                    break block20;
                    finally {
                        if (bufferedReader2 != null) {
                            try {
                                bufferedReader2.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                commandConsole.printlnInfoMessage("");
                continue;
            }
            if (versionProperties.getReplacedBy() != null) continue;
            commandConsole.printInfoMessage(this.getMessage("product.name", new Object[0]));
            commandConsole.printlnInfoMessage(" " + versionProperties.getName());
            commandConsole.printInfoMessage(this.getMessage("product.version", new Object[0]));
            commandConsole.printlnInfoMessage(" " + versionProperties.getVersion());
            commandConsole.printInfoMessage(this.getMessage("product.edition", new Object[0]));
            commandConsole.printlnInfoMessage(" " + versionProperties.getEdition());
            commandConsole.printlnInfoMessage("");
        }
        if (!context.optionExists(IFIXES_OPTION)) return;
        Set<IFixInfo> iFixInfos = IFixUtils.getInstalledIFixes(installDir, commandConsole);
        HashMap<String, HashSet<String>> fixInfo = new HashMap<String, HashSet<String>>();
        for (IFixInfo iFixInfo : iFixInfos) {
            List<Problem> probs;
            Resolves r;
            String fixId = iFixInfo.getId();
            if (fixId == null || (r = iFixInfo.getResolves()) == null || (probs = r.getProblems()) == null) continue;
            for (Problem p : probs) {
                String aparId = p.getDisplayId();
                if (aparId == null) continue;
                HashSet<String> fixIds = (HashSet<String>)fixInfo.get(aparId);
                if (fixIds == null) {
                    fixIds = new HashSet<String>();
                    fixInfo.put(aparId, fixIds);
                }
                fixIds.add(fixId);
            }
        }
        Iterator<Object> iterator = fixInfo.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            commandConsole.printlnInfoMessage(this.getMessage("compare.ifix.apar.info", entry.getKey(), entry.getValue()));
        }
    }
}

