/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility.extension;

import com.ibm.ws.product.utility.BaseCommandTask;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.CommandConstants;
import com.ibm.ws.product.utility.CommandTask;
import com.ibm.ws.product.utility.ExecutionContext;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class HelpCommandTask
extends BaseCommandTask {
    public static final String HELP_TASK_NAME = "help";

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>(Arrays.asList("compare", "featureInfo", "viewLicenseInfo", "viewLicenseAgreement", "version", "validate"));
    }

    @Override
    public String getTaskName() {
        return HELP_TASK_NAME;
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("help.desc", new Object[0]);
    }

    @Override
    public String getTaskHelp() {
        return super.getTaskHelp("help.desc", "help.usage.options", null, null, null);
    }

    @Override
    public void doExecute(ExecutionContext context) {
        if (context.getArguments().length == 0) {
            this.doVerboseScriptUsage(context);
        } else if (context.getArguments().length == 1) {
            this.doTaskHelp(context, context.getArguments()[0]);
        }
    }

    public void doScriptUsage(ExecutionContext context, boolean error) {
        CommandConsole commandConsole = context.getCommandConsole();
        this.printlnMessage(commandConsole, "", error);
        CommandTask[] commandTasks = context.getCommandTaskRegistry().getCommandTasks();
        StringBuilder scriptUsage = new StringBuilder();
        boolean separatorRequired = false;
        scriptUsage.append(MessageFormat.format(this.getMessage("usage", new Object[0]), context.getAttribute("SCRIPT_NAME", String.class)));
        scriptUsage.append(" {");
        for (CommandTask commandTask : commandTasks) {
            if (separatorRequired) {
                scriptUsage.append("|");
            } else {
                separatorRequired = true;
            }
            scriptUsage.append(commandTask.getTaskName());
        }
        scriptUsage.append("} [options]");
        this.printlnMessage(commandConsole, scriptUsage.toString(), error);
    }

    private void printlnMessage(CommandConsole commandConsole, String message, boolean error) {
        if (error) {
            commandConsole.printlnErrorMessage(message);
        } else {
            commandConsole.printlnInfoMessage(message);
        }
    }

    private void doTaskHelp(ExecutionContext context, String taskName) {
        CommandConsole commandConsole = context.getCommandConsole();
        CommandTask commandTask = context.getCommandTaskRegistry().getCommandTask(taskName);
        if (commandTask == null) {
            commandConsole.printlnErrorMessage("");
            commandConsole.printlnErrorMessage(this.getMessage("ERROR_UNKNOWN_COMMAND_TASK", taskName));
            return;
        }
        commandConsole.printlnInfoMessage("");
        String scriptName = context.getAttribute("SCRIPT_NAME", String.class);
        commandConsole.printlnInfoMessage(MessageFormat.format(commandTask.getTaskHelp(), scriptName));
    }

    private void doVerboseScriptUsage(ExecutionContext context) {
        this.doScriptUsage(context, false);
        CommandConsole commandConsole = context.getCommandConsole();
        StringBuilder verboseHelp = new StringBuilder();
        verboseHelp.append(CommandConstants.LINE_SEPARATOR);
        verboseHelp.append(this.getMessage("tasks", new Object[0]));
        verboseHelp.append(CommandConstants.LINE_SEPARATOR);
        for (CommandTask commandTask : context.getCommandTaskRegistry().getCommandTasks()) {
            verboseHelp.append(CommandConstants.LINE_SEPARATOR);
            verboseHelp.append("    " + commandTask.getTaskName());
            verboseHelp.append(CommandConstants.LINE_SEPARATOR);
            verboseHelp.append(commandTask.getTaskDescription());
            verboseHelp.append(CommandConstants.LINE_SEPARATOR);
        }
        verboseHelp.append(CommandConstants.LINE_SEPARATOR);
        verboseHelp.append(this.getOption("global.options", new Object[0]));
        verboseHelp.append(CommandConstants.LINE_SEPARATOR);
        verboseHelp.append(this.getOption("global.options.statement", new Object[0]));
        commandConsole.printlnInfoMessage(verboseHelp.toString());
    }

    @Override
    protected boolean validateArguments(ExecutionContext context) {
        boolean optionsValid = true;
        LinkedHashSet<String> supportedOptions = new LinkedHashSet<String>();
        supportedOptions.add("--output");
        supportedOptions.addAll(this.getSupportedOptions());
        String supportedOptionsString = null;
        Set<String> suppliedOptions = context.getOptionNames();
        for (String option : suppliedOptions) {
            if (supportedOptions.contains(option)) continue;
            optionsValid = false;
            if (supportedOptionsString == null) {
                supportedOptionsString = this.getSupportedOptionsString(supportedOptions);
            }
            context.getCommandConsole().printlnErrorMessage(this.getMessage("ERROR_INVALID_COMMAND_OPTION", option, supportedOptionsString));
        }
        return optionsValid;
    }
}

