/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bytebuffer.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.PooledWsByteBufferImpl;
import com.ibm.ws.bytebuffer.internal.WsByteBufferPoolManagerImpl;
import com.ibm.ws.kernel.service.util.ConcurrentObjectPool;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;

public class WsByteBufferPool {
    private final int intEntrySize;
    private final int globalPoolSize;
    private final boolean isDirectPool;
    private final ConcurrentObjectPool<PooledWsByteBufferImpl> pool;
    private final Hashtable<PooledWsByteBufferImpl, PooledWsByteBufferImpl> inUseTable;
    private final AtomicInteger intUniqueCounter = new AtomicInteger(0);
    private static final TraceComponent tc = Tr.register(WsByteBufferPool.class, (String)"WsByteBuffer", (String)"com.ibm.ws.bytebuffer.internal.resources.ByteBufferMessages");
    private WsByteBufferPoolManagerImpl wsbbPoolManager = null;

    public WsByteBufferPool(int entrySizeIn, int _globalPoolSize, boolean tracking, boolean isDirectPool) {
        this.intEntrySize = entrySizeIn;
        this.globalPoolSize = _globalPoolSize;
        this.isDirectPool = isDirectPool;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Creating : " + this.toString() + " direct=" + isDirectPool + " backing pool size: " + this.globalPoolSize), (Object[])new Object[0]);
        }
        this.pool = new ConcurrentObjectPool(this.globalPoolSize);
        this.inUseTable = tracking ? new Hashtable(this.globalPoolSize * 2) : null;
    }

    public PooledWsByteBufferImpl create() {
        int intUniqueId = this.intUniqueCounter.getAndIncrement();
        if (intUniqueId == -1) {
            intUniqueId = this.intUniqueCounter.getAndIncrement();
        }
        return new PooledWsByteBufferImpl(intUniqueId);
    }

    public void destroy(PooledWsByteBufferImpl obj) {
        if (this.wsbbPoolManager == null) {
            this.wsbbPoolManager = (WsByteBufferPoolManagerImpl)WsByteBufferPoolManagerImpl.getRef();
        }
        if (this.wsbbPoolManager != null) {
            this.wsbbPoolManager.releasing(obj.oByteBuffer);
        }
    }

    public PooledWsByteBufferImpl getEntry() {
        PooledWsByteBufferImpl returnValue = (PooledWsByteBufferImpl)this.pool.get();
        if (returnValue == null) {
            returnValue = this.create();
        }
        if (this.inUseTable != null) {
            this.inUseTable.put(returnValue, returnValue);
        }
        return returnValue;
    }

    public void release(PooledWsByteBufferImpl buffer) {
        if (this.inUseTable != null) {
            this.inUseTable.remove(buffer);
        }
        boolean pooled = this.pool.put((Object)buffer);
        if (this.isDirectPool && !pooled) {
            this.destroy(buffer);
        }
    }

    public Object[] getInUse() {
        return this.inUseTable != null ? ((Hashtable)this.inUseTable.clone()).keySet().toArray() : new Object[]{};
    }

    public void removeFromInUse(Object buffer) {
        if (this.inUseTable != null) {
            if (null == buffer) {
                throw new NullPointerException();
            }
            this.inUseTable.remove(buffer);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        sb.append(this.getClass().getSimpleName());
        sb.append('@');
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append('/').append(this.intEntrySize);
        sb.append(']');
        return sb.toString();
    }
}

