/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.java.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.json.java.internal.Token;
import com.ibm.json.java.internal.Tokenizer;
import java.io.IOException;
import java.io.Reader;

public class Parser {
    private Tokenizer tokenizer;
    private Token lastToken;

    public Parser(Reader reader) throws IOException {
        this.tokenizer = new Tokenizer(reader);
    }

    public JSONObject parse() throws IOException {
        return this.parse(false);
    }

    public JSONObject parse(boolean ordered) throws IOException {
        this.lastToken = this.tokenizer.next();
        return this.parseObject(ordered);
    }

    public JSONObject parseObject() throws IOException {
        return this.parseObject(false);
    }

    public JSONObject parseObject(boolean ordered) throws IOException {
        JSONObject result;
        block6: {
            result = null;
            result = !ordered ? new JSONObject() : new OrderedJSONObject();
            if (this.lastToken != Token.TokenBraceL) {
                throw new IOException("Expecting '{' " + this.tokenizer.onLineCol() + " instead, obtained token: '" + this.lastToken + "'");
            }
            this.lastToken = this.tokenizer.next();
            while (true) {
                if (this.lastToken == Token.TokenEOF) {
                    throw new IOException("Unterminated object " + this.tokenizer.onLineCol());
                }
                if (this.lastToken == Token.TokenBraceR) break block6;
                if (!this.lastToken.isString()) {
                    throw new IOException("Expecting string key " + this.tokenizer.onLineCol());
                }
                String key = this.lastToken.getString();
                this.lastToken = this.tokenizer.next();
                if (this.lastToken != Token.TokenColon) {
                    throw new IOException("Expecting colon " + this.tokenizer.onLineCol());
                }
                this.lastToken = this.tokenizer.next();
                Object val = this.parseValue(ordered);
                result.put(key, val);
                if (this.lastToken == Token.TokenComma) {
                    this.lastToken = this.tokenizer.next();
                    continue;
                }
                if (this.lastToken != Token.TokenBraceR) break;
            }
            throw new IOException("expecting either ',' or '}' " + this.tokenizer.onLineCol());
        }
        this.lastToken = this.tokenizer.next();
        return result;
    }

    public JSONArray parseArray() throws IOException {
        return this.parseArray(false);
    }

    public JSONArray parseArray(boolean ordered) throws IOException {
        JSONArray result;
        block4: {
            result = new JSONArray();
            if (this.lastToken != Token.TokenBrackL) {
                throw new IOException("Expecting '[' " + this.tokenizer.onLineCol());
            }
            this.lastToken = this.tokenizer.next();
            while (true) {
                if (this.lastToken == Token.TokenEOF) {
                    throw new IOException("Unterminated array " + this.tokenizer.onLineCol());
                }
                if (this.lastToken == Token.TokenBrackR) break block4;
                Object val = this.parseValue(ordered);
                result.add(val);
                if (this.lastToken == Token.TokenComma) {
                    this.lastToken = this.tokenizer.next();
                    continue;
                }
                if (this.lastToken != Token.TokenBrackR) break;
            }
            throw new IOException("expecting either ',' or ']' " + this.tokenizer.onLineCol());
        }
        this.lastToken = this.tokenizer.next();
        return result;
    }

    public Object parseValue() throws IOException {
        return this.parseValue(false);
    }

    public Object parseValue(boolean ordered) throws IOException {
        if (this.lastToken == Token.TokenEOF) {
            throw new IOException("Expecting property value " + this.tokenizer.onLineCol());
        }
        if (this.lastToken.isNumber()) {
            Number result = this.lastToken.getNumber();
            this.lastToken = this.tokenizer.next();
            return result;
        }
        if (this.lastToken.isString()) {
            String result = this.lastToken.getString();
            this.lastToken = this.tokenizer.next();
            return result;
        }
        if (this.lastToken == Token.TokenFalse) {
            this.lastToken = this.tokenizer.next();
            return Boolean.FALSE;
        }
        if (this.lastToken == Token.TokenTrue) {
            this.lastToken = this.tokenizer.next();
            return Boolean.TRUE;
        }
        if (this.lastToken == Token.TokenNull) {
            this.lastToken = this.tokenizer.next();
            return null;
        }
        if (this.lastToken == Token.TokenBrackL) {
            return this.parseArray(ordered);
        }
        if (this.lastToken == Token.TokenBraceL) {
            return this.parseObject(ordered);
        }
        throw new IOException("Invalid token " + this.tokenizer.onLineCol());
    }
}

