/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ras;

import com.ibm.websphere.ras.Traceable;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

public final class ProtectedString
implements Traceable,
FFDCSelfIntrospectable {
    private static final byte[] SALT;
    private static AtomicReference<List<ProtectedString>> checkpointStrings;
    public static final ProtectedString NULL_PROTECTED_STRING;
    public static final ProtectedString EMPTY_PROTECTED_STRING;
    @Sensitive
    private final char[] _password;
    private String _traceableString = null;

    public ProtectedString(@Sensitive char[] password) {
        if (password != null) {
            if (password.length != 0) {
                this._password = new char[password.length];
                System.arraycopy(password, 0, this._password, 0, password.length);
            } else {
                this._password = password;
            }
        } else {
            this._password = null;
        }
    }

    @Sensitive
    public char[] getChars() {
        if (this._password != null) {
            if (this._password.length != 0) {
                char[] result = new char[this._password.length];
                System.arraycopy(this._password, 0, result, 0, this._password.length);
                return result;
            }
            return this._password;
        }
        return null;
    }

    public String toString() {
        if (this._password != null) {
            return "*****";
        }
        return "null";
    }

    @Override
    public String toTraceString() {
        String result = this._traceableString;
        if (result == null) {
            List<ProtectedString> current;
            if (this._password != null) {
                try {
                    MessageDigest digester = MessageDigest.getInstance("SHA-512");
                    digester.update(SALT);
                    for (char c : this._password) {
                        digester.update((byte)((c & 0xFF00) >> 8));
                        digester.update((byte)(c & 0xFF));
                    }
                    byte[] hash = digester.digest();
                    StringBuilder sb = new StringBuilder();
                    for (byte b : hash) {
                        int i = b & 0xF;
                        sb.append(Integer.toHexString(i));
                    }
                    result = sb.toString();
                }
                catch (NoSuchAlgorithmException nsae) {
                    result = this.toString();
                }
            } else {
                result = "";
            }
            this._traceableString = result;
            if (!CheckpointPhase.getPhase().restored() && (current = checkpointStrings.get()) != null) {
                current.add(this);
            }
        }
        return result;
    }

    @Override
    public String[] introspectSelf() {
        return new String[]{"_password = " + this.toString(), "_traceablePassword = " + this.toTraceString()};
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof ProtectedString) {
            ProtectedString other = (ProtectedString)o;
            return Arrays.equals(this._password, other._password);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this._password);
    }

    public boolean isEmpty() {
        return this._password == null || this._password.length == 0;
    }

    static {
        checkpointStrings = new AtomicReference();
        final SecureRandom sr = new SecureRandom();
        SALT = new byte[12];
        sr.nextBytes(SALT);
        if (!CheckpointPhase.getPhase().restored()) {
            CheckpointHook resaltHook = new CheckpointHook(){

                public void restore() {
                    sr.nextBytes(SALT);
                    ((List)checkpointStrings.getAndSet(null)).forEach(ps -> ((ProtectedString)ps)._traceableString = null);
                }
            };
            if (CheckpointPhase.getPhase().addSingleThreadedHook(resaltHook)) {
                checkpointStrings.set(new CopyOnWriteArrayList());
            }
        }
        NULL_PROTECTED_STRING = new ProtectedString(null);
        EMPTY_PROTECTED_STRING = new ProtectedString(new char[0]);
    }
}

