/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webserver.plugin.utility.tasks;

import com.ibm.ws.product.utility.CommandTask;
import com.ibm.ws.product.utility.ExecutionContext;
import com.ibm.ws.webserver.plugin.utility.tasks.BasePluginConfigCommandTask;
import java.text.MessageFormat;
import java.util.Set;

public class HelpTask
extends BasePluginConfigCommandTask {
    final String scriptName;
    ExecutionContext context;

    public HelpTask(String scriptName) {
        super(scriptName);
        this.scriptName = scriptName;
    }

    public String getTaskName() {
        return "help";
    }

    public String getTaskHelp() {
        StringBuilder scriptHelp = new StringBuilder();
        scriptHelp.append(NL);
        scriptHelp.append(this.getMessage("usage", this.scriptName));
        scriptHelp.append(NL);
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption("global.actions", new Object[0]));
        scriptHelp.append(NL);
        for (CommandTask task : this.context.getCommandTaskRegistry().getCommandTasks()) {
            if (task.getTaskName().equals(this.getTaskName())) continue;
            scriptHelp.append(NL);
            scriptHelp.append(task.getTaskDescription());
            scriptHelp.append(NL);
        }
        scriptHelp.append(this.getTaskDescription());
        scriptHelp.append(NL);
        scriptHelp.append(NL);
        scriptHelp.append(NL);
        return MessageFormat.format(scriptHelp.toString(), this.scriptName);
    }

    public String getTaskDescription() {
        StringBuilder scriptHelp = new StringBuilder();
        String UsageOption = this.getOption("help.usage.options", new Object[0]);
        UsageOption = "\t" + UsageOption.substring(5);
        scriptHelp.append(NL);
        scriptHelp.append(UsageOption);
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption("help.desc", new Object[0]));
        scriptHelp.append(NL);
        return scriptHelp.toString();
    }

    public Set<String> getSupportedOptions() {
        return null;
    }

    public void execute(ExecutionContext context) {
        this.context = context;
        String[] args = context.getArguments();
        boolean helpProvided = false;
        if (args.length > 0) {
            for (String taskName : args) {
                for (CommandTask task : context.getCommandTaskRegistry().getCommandTasks()) {
                    if (!task.getTaskName().equals(taskName) || taskName.equals(this.getTaskName())) continue;
                    helpProvided = true;
                    context.getCommandConsole().printlnInfoMessage(task.getTaskHelp());
                }
            }
        }
        if (!helpProvided) {
            context.getCommandConsole().printInfoMessage(this.getTaskHelp());
        }
    }
}

