/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.utils.encapsulation;

import com.ibm.ws.jpa.diagnostics.utils.encapsulation.EncapsulatedData;
import com.ibm.ws.jpa.diagnostics.utils.encapsulation.xsd10.EncapsulatedDataGroupType;
import com.ibm.ws.jpa.diagnostics.utils.encapsulation.xsd10.EncapsulatedDataType;
import com.ibm.ws.jpa.diagnostics.utils.encapsulation.xsd10.PropertiesType;
import com.ibm.ws.jpa.diagnostics.utils.encapsulation.xsd10.PropertyType;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class EncapsulatedDataGroup {
    private final EncapsulatedDataGroupType edgt;
    private final Map<String, EncapsulatedDataGroup> childDataGroupsMap = new HashMap<String, EncapsulatedDataGroup>();
    private final Map<String, EncapsulatedData> childDataMap = new HashMap<String, EncapsulatedData>();

    public static EncapsulatedDataGroup createEncapsulatedDataGroup(String name, String id) {
        EncapsulatedDataGroup edg = new EncapsulatedDataGroup(new EncapsulatedDataGroupType());
        edg.setId(id);
        edg.setName(name);
        return edg;
    }

    public static EncapsulatedDataGroup createEncapsulatedDataGroup(InputStream is) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{EncapsulatedDataGroupType.class});
        Unmarshaller um = jc.createUnmarshaller();
        EncapsulatedDataGroupType edt = (EncapsulatedDataGroupType)um.unmarshal(is);
        EncapsulatedDataGroup edg = new EncapsulatedDataGroup(edt);
        return edg;
    }

    private EncapsulatedDataGroup(EncapsulatedDataGroupType edgt) {
        List<EncapsulatedDataType> dataItems;
        this.edgt = edgt;
        List<EncapsulatedDataGroupType> dataGroups = edgt.getDataGroup();
        if (dataGroups.size() > 0) {
            for (EncapsulatedDataGroupType subedgt : dataGroups) {
                EncapsulatedDataGroup edg = new EncapsulatedDataGroup(subedgt);
                this.childDataGroupsMap.put(edg.getId(), edg);
            }
        }
        if ((dataItems = edgt.getDataItem()).size() > 0) {
            for (EncapsulatedDataType dataItem : dataItems) {
                EncapsulatedData ed = EncapsulatedData.createEncapsulatedData(dataItem);
                this.childDataMap.put(ed.getId(), ed);
            }
        }
    }

    public String getId() {
        return this.edgt.getId();
    }

    public void setId(String id) {
        this.edgt.setId(id);
    }

    public String getName() {
        return this.edgt.getName();
    }

    public void setName(String name) {
        this.edgt.setName(name);
    }

    public Set<String> getDataSubGroupNames() {
        return Collections.unmodifiableSet(this.childDataGroupsMap.keySet());
    }

    public EncapsulatedDataGroup putDataSubGroup(EncapsulatedDataGroup group) {
        if (group == null) {
            return null;
        }
        this.internalRemoveDataGroup(group.getId());
        List<EncapsulatedDataGroupType> dataGroups = this.edgt.getDataGroup();
        dataGroups.add(group.edgt);
        return this.childDataGroupsMap.put(group.getId(), group);
    }

    public EncapsulatedDataGroup getDataSubGroup(String id) {
        return this.childDataGroupsMap.get(id);
    }

    public void removeDataSubGroup(String id) {
        if (id == null) {
            return;
        }
        this.internalRemoveDataGroup(id);
        this.childDataGroupsMap.remove(id);
    }

    public Set<String> getDataItemsNames() {
        return Collections.unmodifiableSet(this.childDataMap.keySet());
    }

    public EncapsulatedData putDataItem(EncapsulatedData item) {
        EncapsulatedData retVal = this.childDataMap.put(item.getId(), item);
        this.internalRemoveDataItem(item.getId());
        this.edgt.getDataItem().add(item.getEncapsulatedDataType());
        return retVal;
    }

    public EncapsulatedData getDataItem(String id) {
        return this.childDataMap.get(id);
    }

    public void removeDataItem(String id) {
        this.childDataMap.remove(id);
        this.internalRemoveDataItem(id);
    }

    private void internalRemoveDataGroup(String id) {
        List<EncapsulatedDataGroupType> dataGroups = this.edgt.getDataGroup();
        ArrayList<EncapsulatedDataGroupType> removeList = new ArrayList<EncapsulatedDataGroupType>();
        for (EncapsulatedDataGroupType dgItem : dataGroups) {
            if (!dgItem.getId().equals(id)) continue;
            removeList.add(dgItem);
        }
        if (removeList.size() > 0) {
            for (EncapsulatedDataGroupType dgItem : removeList) {
                dataGroups.remove(dgItem);
            }
        }
    }

    private void internalRemoveDataItem(String id) {
        List<EncapsulatedDataType> dataItems = this.edgt.getDataItem();
        ArrayList<EncapsulatedDataType> removeList = new ArrayList<EncapsulatedDataType>();
        for (EncapsulatedDataType dtItem : dataItems) {
            if (!dtItem.getId().equals(id)) continue;
            removeList.add(dtItem);
        }
        if (removeList.size() > 0) {
            for (EncapsulatedDataType dtItem : removeList) {
                dataItems.remove(dtItem);
            }
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        PropertiesType pt = this.edgt.getProperties();
        if (pt != null) {
            List<PropertyType> propList = pt.getProperty();
            for (PropertyType ptEntry : propList) {
                propertiesMap.put(ptEntry.getName(), ptEntry.getValue());
            }
        }
        return propertiesMap;
    }

    public void setProperty(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        PropertiesType pt = this.edgt.getProperties();
        if (pt == null) {
            pt = new PropertiesType();
            this.edgt.setProperties(pt);
        }
        List<PropertyType> propList = pt.getProperty();
        PropertyType newPt = new PropertyType();
        propList.add(newPt);
        newPt.setName(name);
        newPt.setValue(value);
        newPt.setType(value.getClass().getCanonicalName());
    }

    public void clearProperties() {
        PropertiesType pt = this.edgt.getProperties();
        if (pt != null) {
            pt.getProperty().clear();
        }
    }

    public void removeProperty(String name) {
        if (name == null) {
            return;
        }
        PropertiesType pt = this.edgt.getProperties();
        if (pt != null) {
            ArrayList<PropertyType> propToRemove = new ArrayList<PropertyType>();
            List<PropertyType> propList = pt.getProperty();
            for (PropertyType p : propList) {
                if (!p.getName().equals(name)) continue;
                propToRemove.add(p);
            }
            for (PropertyType p : propToRemove) {
                propList.remove(p);
            }
        }
    }

    public void write(PrintWriter pw) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{EncapsulatedDataGroupType.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)this.edgt, (Writer)pw);
    }

    public void writeToString(OutputStream os) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{EncapsulatedDataGroupType.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)this.edgt, os);
    }
}

