/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.EARApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.health.internal.AppTracker;
import com.ibm.ws.microprofile.health.internal.HealthCheckService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.ApplicationState;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={AppTracker.class, ApplicationStateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class AppTrackerImpl
implements AppTracker,
ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(AppTrackerImpl.class, (String)"HEALTH", (String)"com.ibm.ws.microprofile.health.resources.Health");
    private static final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    protected ConfigurationAdmin configAdmin;
    private final HashMap<String, Set<String>> appModules = new HashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, ApplicationState> appStateMap = new HashMap<String, ApplicationState>();
    private final Map<String, ApplicationState> configAdminMap = new HashMap<String, ApplicationState>();
    private HealthCheckService healthCheckService;
    static final long serialVersionUID = -9073651567954913573L;

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AppTrackerImpl is activated", (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, int reason) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AppTrackerImpl is deactivated", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Reference(name="configAdmin")
    protected void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
        try {
            Configuration[] configuredApps = configAdmin.listConfigurations("(service.factoryPid=com.ibm.ws.app.manager)");
            if (configuredApps != null) {
                for (Configuration c : configuredApps) {
                    String appName;
                    Dictionary properties = c.getProperties();
                    String[] appNameSplit = Paths.get((String)properties.get("location"), new String[0]).toString().split("\\\\|/");
                    if (properties.get("name") != null) {
                        appName = (String)properties.get("name");
                    } else {
                        appName = appNameSplit[appNameSplit.length - 1].replace(".war", "");
                        appName = appName.replace(".ear", "");
                    }
                    this.configAdminMap.put(appName, ApplicationState.INSTALLED);
                }
            }
        }
        catch (IOException configuredApps) {
            void e;
            FFDCFilter.processException((Throwable)configuredApps, (String)"com.ibm.ws.microprofile.health.internal.AppTrackerImpl", (String)"129", (Object)this, (Object[])new Object[]{configAdmin});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"configadmin had an issue collecting configured applications due to an IO exception.", (Object[])new Object[0]);
            }
            e.printStackTrace();
        }
        catch (InvalidSyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.health.internal.AppTrackerImpl", (String)"133", (Object)this, (Object[])new Object[]{configAdmin});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"configadmin had an issue collecting configured applications due to invalid syntax.", (Object[])new Object[0]);
            }
            e.printStackTrace();
        }
    }

    protected void unsetConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = null;
    }

    @Override
    public Set<String> getAppNames() {
        return this.appModules.keySet();
    }

    @Override
    public Set<String> getAllAppNames() {
        return this.appStateMap.keySet();
    }

    @Override
    public Set<String> getAllConfigAppNames() {
        return this.configAdminMap.keySet();
    }

    @Override
    public void addAppName(String appName) {
        this.appStateMap.put(appName, ApplicationState.INSTALLED);
    }

    @Override
    public Set<String> getModuleNames(String appName) {
        if (this.appModules.containsKey(appName)) {
            return this.appModules.get(appName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={UnableToAdaptException.class})
    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        Container appContainer;
        String appName = appInfo.getDeploymentName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("applicationStarting() : appName = " + appName), (Object[])new Object[0]);
        }
        if ((appContainer = appInfo.getContainer()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("applicationStarting() : appContainer=null for " + appInfo), (Object[])new Object[0]);
            }
            return;
        }
        try {
            NonPersistentCache cache = (NonPersistentCache)appContainer.adapt(NonPersistentCache.class);
            ApplicationClassesContainerInfo acci = (ApplicationClassesContainerInfo)cache.getFromCache(ApplicationClassesContainerInfo.class);
            if (acci == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("applicationStarting() : applicationClassesContainerInfo=null for " + appInfo), (Object[])new Object[0]);
                }
                return;
            }
        }
        catch (UnableToAdaptException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("applicationStarting() : Failed to adapt NonPersistentCache: container=" + appContainer + " : \n" + e.getMessage()), (Object[])new Object[0]);
            }
            return;
        }
        this.processApplication(appContainer, appInfo, appName, false);
        this.lock.writeLock().lock();
        try {
            this.appStateMap.put(appName, ApplicationState.STARTING);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("applicationStarting(): starting app added in appStateMap = " + this.appStateMap.toString() + " for app: " + appName), (Object[])new Object[0]);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private String getAppModuleNameFromMetaData(WebModuleMetaData webModuleMetaData) {
        String appModuleName = null;
        appModuleName = webModuleMetaData.getJ2EEName().toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAppModuleNameFromMetaData() : appModuleName = " + appModuleName), (Object[])new Object[0]);
        }
        return appModuleName;
    }

    @FFDCIgnore(value={UnableToAdaptException.class})
    private WebModuleMetaData getWebModuleMetaData(Container container) {
        NonPersistentCache overlayCache;
        WebModuleMetaData wmmd;
        block3: {
            wmmd = null;
            overlayCache = null;
            try {
                overlayCache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
            }
            catch (UnableToAdaptException e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("getWebModuleMetaData() : Failed to adapt NonPersistentCache: container=" + container + " : \n" + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (overlayCache != null) {
            wmmd = (WebModuleMetaData)overlayCache.getFromCache(WebModuleMetaData.class);
        }
        return wmmd;
    }

    private synchronized void addAppModuleNames(String appName, String moduleAndAppName) {
        HashSet moduleNames = null;
        if (moduleAndAppName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"addAppModuleNames(): moduleAndAppName is null.", (Object[])new Object[0]);
            }
            return;
        }
        String moduleName = moduleAndAppName.split("#")[1];
        if (this.appModules.containsKey(appName)) {
            moduleNames = (HashSet)this.appModules.get(appName);
            moduleNames.add(moduleName);
            this.appModules.replace(appName, moduleNames);
        } else {
            moduleNames = new HashSet();
            moduleNames.add(moduleName);
            this.appModules.put(appName, moduleNames);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addAppModuleNames(): modules added = " + this.appModules.toString() + " for app: " + appName + " and for module: " + moduleName), (Object[])new Object[0]);
        }
    }

    @Override
    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
        String appName = appInfo.getDeploymentName();
        this.lock.writeLock().lock();
        try {
            if (this.appStateMap.containsKey(appName)) {
                this.appStateMap.replace(appName, ApplicationState.STARTING, ApplicationState.STARTED);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("applicationStarted(): started app updated in appStateMap = " + this.appStateMap.toString() + " for app: " + appName), (Object[])new Object[0]);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isStarted(String appName) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.appStateMap.get(appName) == ApplicationState.STARTED;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInstalled(String appName) {
        block4: {
            this.lock.readLock().lock();
            try {
                if (this.appStateMap.get(appName) != ApplicationState.INSTALLED) break block4;
                String state = this.getApplicationMBean(appName);
                if (state.isEmpty()) {
                    this.appStateMap.replace(appName, null);
                    break block4;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return false;
    }

    @Override
    public boolean isUninstalled(String appName) {
        this.lock.readLock().lock();
        try {
            if (this.appStateMap.get(appName) == null) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private String getApplicationMBean(String appName) {
        String state;
        block2: {
            MBeanInfo bean = null;
            state = "";
            try {
                ObjectName objectName = new ObjectName("WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=" + appName);
                bean = mbeanServer.getMBeanInfo(objectName);
                state = (String)mbeanServer.getAttribute(objectName, "State");
            }
            catch (Exception objectName) {
                void e;
                FFDCFilter.processException((Throwable)objectName, (String)"com.ibm.ws.microprofile.health.internal.AppTrackerImpl", (String)"370", (Object)this, (Object[])new Object[]{appName});
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("getApplicationMBean() : Failed to retrieve MBean for app: " + appName + " : \n" + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return state;
    }

    @Override
    public void applicationStopping(ApplicationInfo appInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applicationStopped(ApplicationInfo appInfo) {
        String appName = appInfo.getDeploymentName();
        Container appContainer = appInfo.getContainer();
        if (appContainer == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("applicationStopped() : appContainer=null for " + appInfo), (Object[])new Object[0]);
            }
            return;
        }
        this.processApplication(appContainer, appInfo, appName, true);
        this.lock.writeLock().lock();
        try {
            String state = this.getApplicationMBean(appName);
            if (state.equals("STARTING")) {
                this.appStateMap.replace(appName, ApplicationState.INSTALLED);
            } else {
                this.appStateMap.remove(appName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("applicationStopped(): stopped app removed from appStateMap = " + this.appStateMap.toString() + " for app: " + appName), (Object[])new Object[0]);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void processApplication(Container appContainer, ApplicationInfo appInfo, String appName, boolean isAppStopped) {
        if (appInfo instanceof EARApplicationInfo) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processApplication() : App " + appInfo.getDeploymentName() + " is an EAR file."), (Object[])new Object[0]);
            }
            EARApplicationInfo earAppInfo = (EARApplicationInfo)appInfo;
            this.processEARApplication(appContainer, earAppInfo, isAppStopped);
        } else {
            WebModuleMetaData webModuleMetaData = this.getWebModuleMetaData(appContainer);
            if (webModuleMetaData != null) {
                String appModuleName = this.getAppModuleNameFromMetaData(webModuleMetaData);
                if (isAppStopped) {
                    this.moduleStopped(appName, appModuleName);
                } else {
                    this.addAppModuleNames(appName, appModuleName);
                }
            }
        }
    }

    @FFDCIgnore(value={UnableToAdaptException.class})
    private void processEARApplication(Container appContainer, EARApplicationInfo earAppInfo, boolean isAppStopped) {
        for (Entry entry : appContainer) {
            try {
                WebModuleMetaData webModuleMetaData;
                Container c = (Container)entry.adapt(Container.class);
                if (c == null || (webModuleMetaData = this.getWebModuleMetaData(c)) == null) continue;
                String appName = earAppInfo.getDeploymentName();
                String appModuleName = this.getAppModuleNameFromMetaData(webModuleMetaData);
                if (isAppStopped) {
                    this.moduleStopped(appName, appModuleName);
                    continue;
                }
                this.addAppModuleNames(appName, appModuleName);
            }
            catch (UnableToAdaptException e) {
                if (!tc.isDebugEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("processEARApplication() : Failed to adapt entry: entry=" + entry + " : \n" + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    public synchronized void moduleStopped(String appName, String appModuleName) {
        Set<String> modules = this.appModules.get(appName);
        String moduleName = appModuleName.split("#")[1];
        if (modules != null) {
            modules.remove(moduleName);
            if (modules.size() <= 0) {
                this.appModules.remove(appName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("moduleStopped(): app module removed = " + this.appModules.toString() + " for app: " + appName + " and for module: " + moduleName), (Object[])new Object[0]);
            }
        }
        if (this.healthCheckService != null) {
            this.healthCheckService.removeModuleReferences(appName, moduleName);
        }
    }

    @Override
    public void setHealthCheckService(HealthCheckService healthService) {
        this.healthCheckService = healthService;
    }
}

