/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.reader;

import com.ibm.ws.security.audit.reader.AuditUtilityReturnCodes;
import com.ibm.ws.security.audit.reader.AuditUtilityTask;
import com.ibm.ws.security.audit.reader.tasks.AuditReaderTask;
import com.ibm.ws.security.audit.reader.tasks.HelpTask;
import com.ibm.ws.security.audit.reader.utils.CommandUtils;
import com.ibm.ws.security.audit.reader.utils.ConsoleWrapper;
import com.ibm.ws.security.audit.reader.utils.FileUtility;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class AuditUtility {
    static final String SCRIPT_NAME = "auditUtility";
    private final ConsoleWrapper stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;
    List<AuditUtilityTask> tasks = new ArrayList<AuditUtilityTask>();

    AuditUtility(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr) {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    void registerTask(AuditUtilityTask task) {
        this.tasks.add(task);
    }

    private AuditUtilityTask getTask(String taskName) {
        AuditUtilityTask task = null;
        for (AuditUtilityTask availTask : this.tasks) {
            if (!availTask.getTaskName().equals(taskName)) continue;
            task = availTask;
        }
        return task;
    }

    AuditUtilityReturnCodes runProgram(String[] args) {
        AuditUtilityTask task;
        if (this.stdin == null) {
            this.stderr.println(CommandUtils.getMessage("error.missingIO", "stdin"));
            return AuditUtilityReturnCodes.ERR_GENERIC;
        }
        if (this.stdout == null) {
            this.stderr.println(CommandUtils.getMessage("error.missingIO", "stdout"));
            return AuditUtilityReturnCodes.ERR_GENERIC;
        }
        if (this.stderr == null) {
            this.stdout.println(CommandUtils.getMessage("error.missingIO", "stderr"));
            return AuditUtilityReturnCodes.ERR_GENERIC;
        }
        HelpTask help = new HelpTask(SCRIPT_NAME, this.tasks);
        this.registerTask(help);
        if (args.length == 0) {
            this.stdout.println(help.getScriptUsage());
            return AuditUtilityReturnCodes.OK;
        }
        if (args[0].toLowerCase().endsWith(help.getTaskName().toLowerCase())) {
            args[0] = help.getTaskName();
        }
        if ((task = this.getTask(args[0])) == null) {
            this.stderr.println(CommandUtils.getMessage("task.unknown", args[0]));
            this.stderr.println(help.getScriptUsage());
            return AuditUtilityReturnCodes.OK;
        }
        try {
            return task.handleTask(this.stdin, this.stdout, this.stderr, args);
        }
        catch (IllegalArgumentException e) {
            this.stderr.println("");
            this.stderr.println(CommandUtils.getMessage("error", e.getMessage()));
            this.stderr.println(help.getTaskUsage(task));
            return AuditUtilityReturnCodes.ERR_GENERIC;
        }
        catch (Exception e) {
            this.stderr.println("");
            this.stderr.println(CommandUtils.getMessage("error", e.toString()));
            this.stderr.println(help.getTaskUsage(task));
            return AuditUtilityReturnCodes.ERR_GENERIC;
        }
    }

    public static void main(String[] args) {
        ConsoleWrapper console = new ConsoleWrapper(System.console(), System.err);
        AuditUtility util = new AuditUtility(console, System.out, System.err);
        FileUtility fileUtil = new FileUtility(System.getenv("WLP_USER_DIR"), System.getenv("WLP_OUTPUT_DIR"));
        util.registerTask(new AuditReaderTask(SCRIPT_NAME));
        int rc = util.runProgram(args).getReturnCode();
        System.exit(rc);
    }
}

