/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.websphere.logging.hpel.reader.RemoteListCache;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.reader.ServerInstanceLogRecordList;
import com.ibm.ws.logging.hpel.LogRepositoryBrowser;
import com.ibm.ws.logging.hpel.impl.LogRecordBrowser;
import com.ibm.ws.logging.object.hpel.RemoteListCacheImpl;
import com.ibm.ws.logging.object.hpel.RemoteRepositoryCache;
import com.ibm.ws.logging.object.hpel.RepositoryLogRecordImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class ServerInstanceLogRecordListImpl
implements ServerInstanceLogRecordList {
    protected final LogRepositoryBrowser logBrowser;
    protected final LogRepositoryBrowser traceBrowser;
    private final boolean switched;
    protected LogRecordBrowser.OnePidRecordListImpl logResult = null;
    protected LogRecordBrowser.OnePidRecordListImpl traceResult = null;
    private Properties header = null;
    public static final Iterator<RepositoryLogRecord> EMPTY_ITERATOR = new Iterator<RepositoryLogRecord>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public RepositoryLogRecord next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method is not applicable to this class");
        }
    };

    public ServerInstanceLogRecordListImpl(LogRepositoryBrowser logBrowser, LogRepositoryBrowser traceBrowser, boolean switched) {
        if (logBrowser == null && traceBrowser == null) {
            throw new IllegalArgumentException("Either logBrowser or traceBrowser should have value other than 'null'");
        }
        this.logBrowser = logBrowser;
        this.traceBrowser = traceBrowser;
        this.switched = switched;
    }

    protected LogRecordBrowser.OnePidRecordListImpl getLogResult() {
        if (this.logResult == null && this.logBrowser != null) {
            this.logResult = this.queryResult(this.logBrowser);
        }
        return this.logResult;
    }

    protected LogRecordBrowser.OnePidRecordListImpl getTraceResult() {
        if (this.traceResult == null && this.traceBrowser != null) {
            this.traceResult = this.queryResult(this.traceBrowser);
        }
        return this.traceResult;
    }

    public RemoteListCache getCache() {
        RemoteRepositoryCache logCache = this.getLogResult() == null ? null : this.getLogResult().getCache();
        RemoteRepositoryCache traceCache = this.getTraceResult() == null ? null : this.getTraceResult().getCache();
        return this.switched ? new RemoteListCacheImpl(traceCache, logCache) : new RemoteListCacheImpl(logCache, traceCache);
    }

    public void setCache(RemoteListCache cache) {
        if (cache instanceof RemoteListCacheImpl) {
            RemoteListCacheImpl cacheImpl = (RemoteListCacheImpl)cache;
            if (this.getLogResult() != null) {
                RemoteRepositoryCache logCache;
                RemoteRepositoryCache remoteRepositoryCache = logCache = this.switched ? cacheImpl.getTraceCache() : cacheImpl.getLogCache();
                if (logCache != null) {
                    this.getLogResult().setCache(logCache);
                }
            }
            if (this.getTraceResult() != null) {
                RemoteRepositoryCache traceCache;
                RemoteRepositoryCache remoteRepositoryCache = traceCache = this.switched ? cacheImpl.getLogCache() : cacheImpl.getTraceCache();
                if (traceCache != null) {
                    this.getTraceResult().setCache(traceCache);
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown implementation of the RemoteListCache instance");
        }
    }

    public abstract LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser var1);

    @Override
    public Map<String, ServerInstanceLogRecordList> getChildren() {
        HashMap<String, ServerInstanceLogRecordList> map = new HashMap<String, ServerInstanceLogRecordList>();
        if (this.traceBrowser == null) {
            for (Map.Entry<String, LogRepositoryBrowser> entry : this.logBrowser.getSubProcesses().entrySet()) {
                ServerInstanceLogRecordListImpl value = new ServerInstanceLogRecordListImpl(entry.getValue(), null, this.switched){

                    @Override
                    public LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                        return ServerInstanceLogRecordListImpl.this.queryResult(browser);
                    }
                };
                map.put(entry.getKey(), value);
            }
        } else if (this.logBrowser == null) {
            for (Map.Entry<String, LogRepositoryBrowser> entry : this.traceBrowser.getSubProcesses().entrySet()) {
                ServerInstanceLogRecordListImpl value = new ServerInstanceLogRecordListImpl(entry.getValue(), null, !this.switched){

                    @Override
                    public LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                        return ServerInstanceLogRecordListImpl.this.queryResult(browser);
                    }
                };
                map.put(entry.getKey(), value);
            }
        } else {
            Map<String, LogRepositoryBrowser> logSubProcs = this.logBrowser.getSubProcesses();
            Map<String, LogRepositoryBrowser> traceSubProcs = this.traceBrowser.getSubProcesses();
            HashSet<String> keys = new HashSet<String>();
            keys.addAll(logSubProcs.keySet());
            keys.addAll(traceSubProcs.keySet());
            for (String key : keys) {
                ServerInstanceLogRecordListImpl value = new ServerInstanceLogRecordListImpl(logSubProcs.get(key), traceSubProcs.get(key), this.switched){

                    @Override
                    public LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                        return ServerInstanceLogRecordListImpl.this.queryResult(browser);
                    }
                };
                map.put(key, value);
            }
        }
        return map;
    }

    @Override
    public Properties getHeader() {
        if (this.header == null) {
            LogRecordBrowser.OnePidRecordListImpl traceResult;
            LogRecordBrowser.OnePidRecordListImpl logResult = this.getLogResult();
            if (logResult != null) {
                this.header = logResult.getHeader();
            }
            if (this.header == null && (traceResult = this.getTraceResult()) != null) {
                this.header = traceResult.getHeader();
            }
            if (this.header == null && logResult != null) {
                this.header = logResult.getParsedHeader();
            }
            if (this.header == null && this.traceResult != null) {
                this.header = this.traceResult.getParsedHeader();
            }
        }
        return this.header;
    }

    @Override
    public Date getStartTime() {
        if (this.logBrowser != null && this.traceBrowser != null) {
            if (this.logBrowser.getTimestamp() < this.traceBrowser.getTimestamp()) {
                return new Date(this.logBrowser.getTimestamp());
            }
            return new Date(this.traceBrowser.getTimestamp());
        }
        if (this.logBrowser != null) {
            return new Date(this.logBrowser.getTimestamp());
        }
        if (this.traceBrowser != null) {
            return new Date(this.traceBrowser.getTimestamp());
        }
        return null;
    }

    @Override
    public Iterator<RepositoryLogRecord> iterator() {
        return this.getNewIterator(0, -1);
    }

    @Override
    public Iterable<RepositoryLogRecord> range(final int offset, final int length) {
        return new Iterable<RepositoryLogRecord>(){

            @Override
            public Iterator<RepositoryLogRecord> iterator() {
                return ServerInstanceLogRecordListImpl.this.getNewIterator(offset, length);
            }
        };
    }

    protected Iterator<RepositoryLogRecord> getNewIterator(int offset, int length) {
        LogRecordBrowser.OnePidRecordListImpl logResult = this.getLogResult();
        LogRecordBrowser.OnePidRecordListImpl traceResult = this.getTraceResult();
        if (logResult == null && traceResult == null) {
            return EMPTY_ITERATOR;
        }
        if (traceResult == null) {
            return logResult.getNewIterator(offset, length);
        }
        if (logResult == null) {
            return traceResult.getNewIterator(offset, length);
        }
        MergedServerInstanceLogRecordIterator result = new MergedServerInstanceLogRecordIterator(logResult, traceResult);
        result.setRange(offset, length);
        return result;
    }

    private static class MergedServerInstanceLogRecordIterator
    implements Iterator<RepositoryLogRecord> {
        private final LogRecordBrowser.OnePidRecordIterator it1;
        private final LogRecordBrowser.OnePidRecordIterator it2;
        private RepositoryLogRecordImpl next1 = null;
        private RepositoryLogRecordImpl next2 = null;
        private RepositoryLogRecord next = null;
        private int countDown = -1;

        MergedServerInstanceLogRecordIterator(LogRecordBrowser.OnePidRecordListImpl list1, LogRecordBrowser.OnePidRecordListImpl list2) {
            this.it1 = (LogRecordBrowser.OnePidRecordIterator)list1.getNewIterator(0, -1);
            this.it2 = (LogRecordBrowser.OnePidRecordIterator)list2.getNewIterator(0, -1);
        }

        void setRange(int offset, int length) {
            if (offset == 0 && length < 0) {
                return;
            }
            int total1 = this.it1.total();
            int total2 = this.it2.total();
            if (offset < 0) {
                int index1 = total1 - 1;
                int index2 = total2 - 1;
                while (index1 >= 0 && index2 >= 0) {
                    int size1 = this.it1.size(index1);
                    if (size1 == 0) {
                        --index1;
                        continue;
                    }
                    int size2 = this.it2.size(index2);
                    if (size2 == 0) {
                        --index2;
                        continue;
                    }
                    long firstId1 = this.it1.getFirstId(index1);
                    long lastId1 = this.it1.getLastId(index1);
                    long firstId2 = this.it2.getFirstId(index2);
                    long lastId2 = this.it2.getLastId(index2);
                    if (lastId1 < firstId2) {
                        if (size2 > -offset) break;
                        offset += size2;
                        --index2;
                        continue;
                    }
                    if (lastId2 < firstId1) {
                        if (size1 > -offset) break;
                        offset += size1;
                        --index1;
                        continue;
                    }
                    if (size1 + size2 > -offset) break;
                    if (firstId1 < firstId2) {
                        offset += size2;
                        --index2;
                        continue;
                    }
                    offset += size1;
                    --index1;
                }
                if (index1 < 0) {
                    this.it1.setRange(0, 0, -1);
                    while (index2 >= 0 && this.it2.size(index2) < -offset) {
                        offset += this.it2.size(index2--);
                    }
                    if (index2 >= 0) {
                        this.it2.setRange(index2, this.it2.size(index2) + offset, -1);
                    } else {
                        this.it2.setRange(0, 0, -1);
                        length = length > -offset ? length + offset : 0;
                    }
                } else if (index2 < 0) {
                    this.it2.setRange(0, 0, -1);
                    while (index1 >= 0 && this.it1.size(index1) < -offset) {
                        offset += this.it1.size(index1--);
                    }
                    if (index1 >= 0) {
                        this.it1.setRange(index1, this.it1.size(index1) + offset, -1);
                    } else {
                        this.it1.setRange(0, 0, -1);
                        length = length > -offset ? length + offset : 0;
                    }
                } else {
                    this.it1.setRange(index1, 0, -1);
                    this.it2.setRange(index2, 0, -1);
                    for (int size = this.it1.size(index1) + this.it2.size(index2) + offset; size > 0 && this.next() != null; --size) {
                    }
                }
            } else {
                int index1 = 0;
                int index2 = 0;
                while (index1 < total1 && index2 < total2) {
                    int size1 = this.it1.size(index1);
                    if (size1 == 0) {
                        ++index1;
                        continue;
                    }
                    int size2 = this.it2.size(index2);
                    if (size2 == 0) {
                        ++index2;
                        continue;
                    }
                    long firstId1 = this.it1.getFirstId(index1);
                    long lastId1 = this.it1.getLastId(index1);
                    long firstId2 = this.it2.getFirstId(index2);
                    long lastId2 = this.it2.getLastId(index2);
                    if (lastId1 < firstId2) {
                        if (size1 > offset) break;
                        offset -= size1;
                        ++index1;
                        continue;
                    }
                    if (lastId2 < firstId1) {
                        if (size2 > offset) break;
                        offset -= size2;
                        ++index2;
                        continue;
                    }
                    if (size1 + size2 > offset) break;
                    if (lastId1 < lastId2) {
                        offset -= size1;
                        ++index1;
                        continue;
                    }
                    offset -= size2;
                    ++index2;
                }
                if (index1 == total1) {
                    this.it1.close();
                    while (index2 < total2 && this.it2.size(index2) <= offset) {
                        offset -= this.it2.size(index2++);
                    }
                    if (index2 < total2) {
                        this.it2.setRange(index2, offset, length);
                    } else {
                        this.it2.close();
                    }
                } else if (index2 == total2) {
                    this.it2.close();
                    while (index1 < total1 && this.it1.size(index1) <= offset) {
                        offset -= this.it1.size(index1++);
                    }
                    if (index1 < total1) {
                        this.it1.setRange(index1, offset, length);
                    } else {
                        this.it1.close();
                    }
                } else {
                    this.it1.setRange(index1, 0, -1);
                    this.it2.setRange(index2, 0, -1);
                    while (offset > 0 && this.next() != null) {
                        --offset;
                    }
                }
            }
            this.countDown = length;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.getNext();
            }
            return this.next != null;
        }

        private RepositoryLogRecord getNext() {
            RepositoryLogRecordImpl result;
            if (this.countDown == 0) {
                this.it1.close();
                this.it2.close();
                return null;
            }
            while (this.next1 == null && this.next2 == null && !this.it1.isDone() && !this.it2.isDone()) {
                if (this.it1.compareTo(this.it2) < 0) {
                    this.next1 = (RepositoryLogRecordImpl)this.it1.findNext(-1L);
                    continue;
                }
                this.next2 = (RepositoryLogRecordImpl)this.it2.findNext(-1L);
            }
            if (this.next1 != null && this.next2 == null) {
                this.next2 = (RepositoryLogRecordImpl)this.it2.findNext(this.next1.getInternalSeqNumber());
            } else if (this.next1 == null && this.next2 != null) {
                this.next1 = (RepositoryLogRecordImpl)this.it1.findNext(this.next2.getInternalSeqNumber());
            } else if (this.next1 == null && this.next2 == null) {
                if (!this.it1.isDone()) {
                    this.next1 = (RepositoryLogRecordImpl)this.it1.next();
                } else {
                    this.next2 = (RepositoryLogRecordImpl)this.it2.next();
                }
            }
            if (this.next1 == null && this.next2 == null) {
                result = null;
            } else if (this.next1 == null) {
                result = this.next2;
                this.next2 = null;
            } else if (this.next2 == null) {
                result = this.next1;
                this.next1 = null;
            } else if (this.next1.getInternalSeqNumber() < this.next2.getInternalSeqNumber()) {
                result = this.next1;
                this.next1 = null;
            } else {
                result = this.next2;
                this.next2 = null;
            }
            if (this.countDown > 0) {
                --this.countDown;
            }
            return result;
        }

        @Override
        public RepositoryLogRecord next() {
            if (this.next == null) {
                this.next = this.getNext();
            }
            RepositoryLogRecord result = this.next;
            this.next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method is not applicable to this class");
        }
    }
}

