/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.LogRecord;
import java.nio.ByteBuffer;
import java.util.Arrays;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ReadableLogRecord
extends LogRecord {
    private static final TraceComponent tc = Tr.register(ReadableLogRecord.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final long _sequenceNumber;
    static final long serialVersionUID = 4139817285898659847L;

    private ReadableLogRecord(ByteBuffer buffer, int absolutePosition, long sequenceNumber) {
        super(buffer, absolutePosition);
        this._sequenceNumber = sequenceNumber;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ReadableLogRecord", (Object[])new Object[]{absolutePosition, sequenceNumber, this});
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    protected static ReadableLogRecord read(ByteBuffer sourceBuffer, long expectedSequenceNumber, boolean doByteByByteScanning) {
        ReadableLogRecord logRecord;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"read", (Object[])new Object[]{sourceBuffer, expectedSequenceNumber, doByteByByteScanning});
            }
            logRecord = null;
            try {
                logRecord = ReadableLogRecord.read(sourceBuffer.slice(), expectedSequenceNumber, sourceBuffer);
            }
            catch (RuntimeException runtimeException) {
                void e;
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.recoverylog.spi.ReadableLogRecord", (String)"70", null, (Object[])new Object[]{sourceBuffer, expectedSequenceNumber, doByteByByteScanning});
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"EXPECTED: RuntimeException reading log: ", (Object[])new Object[]{e});
            }
        }
        if (logRecord == null && doByteByByteScanning) {
            logRecord = ReadableLogRecord.doByteByByteScanning(sourceBuffer, expectedSequenceNumber);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read", (Object)logRecord);
        }
        return logRecord;
    }

    private static ReadableLogRecord read(ByteBuffer viewBuffer, long expectedSequenceNumber, ByteBuffer sourceBuffer) {
        long recordSequenceNumber;
        ReadableLogRecord logRecord = null;
        int absolutePosition = sourceBuffer.position() + viewBuffer.position();
        byte[] magicNumberBuffer = new byte[RECORD_MAGIC_NUMBER.length];
        viewBuffer.get(magicNumberBuffer);
        int recordLength = 0;
        if (Arrays.equals(magicNumberBuffer, RECORD_MAGIC_NUMBER) && (recordSequenceNumber = viewBuffer.getLong()) >= expectedSequenceNumber) {
            recordLength = viewBuffer.getInt();
            int recordDataPosition = viewBuffer.position();
            viewBuffer.position(recordDataPosition + recordLength);
            long tailSequenceNumber = viewBuffer.getLong();
            if (tailSequenceNumber == recordSequenceNumber) {
                viewBuffer.position(recordDataPosition);
                logRecord = new ReadableLogRecord(viewBuffer, absolutePosition, tailSequenceNumber);
                sourceBuffer.position(absolutePosition + HEADER_SIZE + recordLength);
            }
        }
        return logRecord;
    }

    @ManualTrace
    private static ReadableLogRecord doByteByByteScanning(ByteBuffer sourceBuffer, long expectedSequenceNumber) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doByteByByteScanning", (Object[])new Object[]{sourceBuffer, expectedSequenceNumber});
        }
        ReadableLogRecord logRecord = null;
        ByteBuffer viewBuffer = sourceBuffer.slice();
        int position = LogRecord.HEADER_SIZE;
        while (position + LogRecord.HEADER_SIZE < viewBuffer.limit()) {
            viewBuffer.position(position);
            byte peak = viewBuffer.get(position);
            if (peak == 82 && (peak = viewBuffer.get(position + 1)) == 67) {
                try {
                    logRecord = ReadableLogRecord.read(viewBuffer, expectedSequenceNumber, sourceBuffer);
                    if (logRecord != null) {
                        break;
                    }
                }
                catch (RuntimeException runtimeException) {
                    FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.recoverylog.spi.ReadableLogRecord", (String)"164", null, (Object[])new Object[]{sourceBuffer, expectedSequenceNumber});
                }
            }
            ++position;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doByteByByteScanning", logRecord);
        }
        return logRecord;
    }

    @Trivial
    protected long getSequenceNumber() {
        return this._sequenceNumber;
    }
}

