/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticateApi;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.util.WebContainerSystemProps;
import com.ibm.wsspi.webcontainer.osgi.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FormLogoutExtensionProcessor
extends WebExtensionProcessor {
    private static final TraceComponent tc = Tr.register(FormLogoutExtensionProcessor.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    protected static final String DEFAULT_LOGOUT_MSG = "<!DOCTYPE HTML PUBLIC \"-//W3C/DTD HTML 4.0 Transitional//EN\"><HTML><TITLE>Default Logout Exit Page</TITLE><BODY><H2>Successful Logout</H2></BODY></HTML>";
    private static String ABSOLUTE_URI = "com.ibm.websphere.security.web.absoluteUri";
    private boolean absoluteUri = false;
    private final WebAppSecurityConfig webAppSecurityConfig;
    AuthenticateApi authenticateApi = null;
    static final long serialVersionUID = -2288276532536191281L;

    public FormLogoutExtensionProcessor(IServletContext webapp, WebAppSecurityConfig webAppSecConfig, AuthenticateApi authenticateApi) {
        super(webapp);
        this.authenticateApi = authenticateApi;
        this.webAppSecurityConfig = webAppSecConfig;
        String absUri = System.getProperty(ABSOLUTE_URI);
        if (absUri != null && absUri.equalsIgnoreCase("true")) {
            this.absoluteUri = true;
        }
    }

    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            final HttpServletRequest request = (HttpServletRequest)req;
            final HttpServletResponse response = (HttpServletResponse)res;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -8649240704909426242L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws ServletException, IOException {
                    FormLogoutExtensionProcessor.this.formLogout(request, response);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.internal.FormLogoutExtensionProcessor$1", 1.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private void formLogout(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            String exitPage = this.getValidLogoutExitPage(req);
            if (exitPage != null) {
                req.setAttribute("FormLogoutExitPage", (Object)exitPage);
            }
            this.authenticateApi.logout(req, res, this.webAppSecurityConfig);
            String str = null;
            if (req.getAttribute("SpSLOInProgress") == null) {
                AuthenticationResult authResult = new AuthenticationResult(AuthResult.SUCCESS, str);
                authResult.setAuditLogoutSubject(this.authenticateApi.returnSubjectOnLogout());
                authResult.setAuditCredType("FORM");
                authResult.setAuditOutcome("success");
                authResult.setTargetRealm(authResult.realm);
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHN_TERMINATE_01, (Object[])new Object[]{req, authResult, res.getStatus()});
                this.redirectLogoutExitPage(req, res);
            }
        }
        catch (ServletException exitPage) {
            void se;
            FFDCFilter.processException((Throwable)exitPage, (String)"com.ibm.ws.webcontainer.security.internal.FormLogoutExtensionProcessor", (String)"121", (Object)((Object)this), (Object[])new Object[]{req, res});
            String str = "ServletException: " + se.getMessage();
            AuthenticationResult authResult = new AuthenticationResult(AuthResult.FAILURE, str);
            authResult.setAuditCredType("FORM");
            authResult.setAuditOutcome("failure");
            authResult.setTargetRealm(authResult.realm);
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHN_TERMINATE_01, (Object[])new Object[]{req, authResult, res.getStatus()});
            throw se;
        }
        catch (IOException se) {
            void ie;
            FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.webcontainer.security.internal.FormLogoutExtensionProcessor", (String)"131", (Object)((Object)this), (Object[])new Object[]{req, res});
            String str = "IOException: " + ie.getMessage();
            AuthenticationResult authResult = new AuthenticationResult(AuthResult.FAILURE, str);
            authResult.setAuditCredType("FORM");
            authResult.setAuditOutcome("failure");
            authResult.setTargetRealm(authResult.realm);
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHN_TERMINATE_01, (Object[])new Object[]{req, authResult, res.getStatus()});
            throw ie;
        }
    }

    private String getValidLogoutExitPage(HttpServletRequest req) {
        boolean logoutExitURLaccepted;
        boolean valid = false;
        String exitPage = req.getParameter("logoutExitPage");
        if (exitPage != null && exitPage.length() != 0 && (logoutExitURLaccepted = this.verifyLogoutURL(req, exitPage))) {
            exitPage = this.removeFirstSlash(exitPage);
            exitPage = this.compatibilityExitPage(req, exitPage);
            valid = true;
        }
        return valid ? exitPage : null;
    }

    private void redirectLogoutExitPage(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String exitPage = this.getValidLogoutExitPage(req);
        if (exitPage != null) {
            res.sendRedirect(res.encodeURL(exitPage));
        } else {
            this.useDefaultLogoutMsg(res);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void useDefaultLogoutMsg(HttpServletResponse res) {
        block3: {
            try {
                PrintWriter pw = res.getWriter();
                pw.println(DEFAULT_LOGOUT_MSG);
            }
            catch (IOException pw) {
                void e;
                FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.webcontainer.security.internal.FormLogoutExtensionProcessor", (String)"188", (Object)((Object)this), (Object[])new Object[]{res});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No logoutExitPage specified", (Object[])new Object[0]);
        }
    }

    private String compatibilityExitPage(HttpServletRequest req, String exitPage) {
        if (!WebContainerSystemProps.getSendRedirectCompatibilty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Compatibility=false (default) redirect mode", (Object[])new Object[0]);
            }
            if (this.absoluteUri) {
                if (exitPage.equals("/")) {
                    exitPage = "";
                } else if (exitPage.startsWith("/")) {
                    exitPage = exitPage.substring(1);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Logout exit page is not relative to Context Root.", (Object[])new Object[0]);
                }
            } else if (exitPage.startsWith("/")) {
                StringBuffer sb = new StringBuffer();
                String contextPath = req.getContextPath();
                if (contextPath != null && contextPath.endsWith("/")) {
                    int i = contextPath.lastIndexOf("/");
                    contextPath = contextPath.substring(0, i);
                }
                sb.append(contextPath);
                sb.append(exitPage);
                exitPage = sb.toString();
            }
        }
        return exitPage;
    }

    private String removeFirstSlash(String exitPage) {
        if (exitPage.startsWith("//")) {
            exitPage = exitPage.substring(1);
        }
        return exitPage;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={UnknownHostException.class})
    protected boolean verifyLogoutURL(HttpServletRequest req, String exitPage) {
        boolean acceptURL = false;
        boolean allowLogoutPageRedirectToAnyHost = this.webAppSecurityConfig.getAllowLogoutPageRedirectToAnyHost();
        if (exitPage != null && !exitPage.equals("logon.jsp") && !allowLogoutPageRedirectToAnyHost) {
            String logoutURLHost = null;
            try {
                String hostFullName;
                String ipAddress;
                String shortName;
                block23: {
                    InetAddress thisHost = InetAddress.getLocalHost();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("return from getLocalHost: " + thisHost), (Object[])new Object[0]);
                    }
                    shortName = thisHost.getHostName();
                    ipAddress = thisHost.getHostAddress();
                    hostFullName = ipAddress == null ? shortName : InetAddress.getByName(ipAddress).getHostName();
                    try {
                        String exitPageTrimmed;
                        URI logoutURL = new URI(exitPage);
                        logoutURLHost = logoutURL.getHost();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("domain for exitPage url: " + logoutURLHost), (Object[])new Object[0]);
                        }
                        if (logoutURL.isAbsolute()) break block23;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("URI " + exitPage + " is not absolute."), (Object[])new Object[0]);
                        }
                        if ((exitPageTrimmed = exitPage.trim()).startsWith("//")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("URI " + exitPageTrimmed + " will be processed as a Network-Path. SendRedirect() defines a Network-Path as starting with // "), (Object[])new Object[0]);
                            }
                            char[] exitPageCharArr = exitPageTrimmed.toCharArray();
                            for (int i = 0; i < exitPageCharArr.length; ++i) {
                                if (exitPageCharArr[i] == '/') continue;
                                URI uri = new URI(exitPageTrimmed.substring(i - 2));
                                logoutURLHost = uri.getHost();
                                if (logoutURLHost == null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("SDK indicates " + exitPageTrimmed + " Network-Path does not contain a valid hostname."), (Object[])new Object[0]);
                                    }
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("SDK indicates " + exitPageTrimmed + " Network-Path contains a valid hostname," + logoutURLHost), (Object[])new Object[0]);
                                }
                                break block23;
                            }
                            break block23;
                        }
                        acceptURL = true;
                    }
                    catch (URISyntaxException logoutURL) {
                        FFDCFilter.processException((Throwable)logoutURL, (String)"com.ibm.ws.webcontainer.security.internal.FormLogoutExtensionProcessor", (String)"299", (Object)((Object)this), (Object[])new Object[]{req, exitPage});
                        if (tc.isDebugEnabled()) {
                            void urise;
                            Tr.debug((TraceComponent)tc, (String)("caught URISyntaxException getting urI for exitPage: " + urise.getMessage()), (Object[])new Object[0]);
                        }
                        acceptURL = false;
                    }
                }
                if (logoutURLHost != null && !acceptURL) {
                    acceptURL = this.isRedirectHostTheSameAsLocalHost(exitPage, logoutURLHost, hostFullName, shortName, ipAddress);
                    if (acceptURL) {
                        return acceptURL;
                    }
                    acceptURL = this.isLogoutPageMatchDomainNameList(exitPage, logoutURLHost, this.webAppSecurityConfig.getLogoutPageRedirectDomainList());
                }
            }
            catch (UnknownHostException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("caught an unknown exception: " + e.getMessage()), (Object[])new Object[0]);
                }
                acceptURL = false;
            }
            if (!acceptURL && logoutURLHost != null) {
                acceptURL = this.isRequestURLEqualsExitPageHost(req, logoutURLHost);
            }
        } else if (exitPage != null) {
            acceptURL = true;
        }
        if (!acceptURL) {
            Tr.error((TraceComponent)tc, (String)"SEC_FORM_LOGOUTEXITPAGE_INVALID", (Object[])new Object[]{req.getRequestURL(), req.getParameter("logoutExitPage")});
        }
        return acceptURL;
    }

    private boolean isRedirectHostTheSameAsLocalHost(String exitPage, String logoutURLhost, String hostFullName, String shortName, String ipAddress) {
        String localHostIpAddress = "127.0.0.1";
        boolean acceptURL = false;
        if (logoutURLhost.equalsIgnoreCase("localhost") || logoutURLhost.equals(localHostIpAddress) || hostFullName != null && logoutURLhost.equalsIgnoreCase(hostFullName) || shortName != null && logoutURLhost.equalsIgnoreCase(shortName) || ipAddress != null && logoutURLhost.equals(ipAddress)) {
            acceptURL = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"exitPage points to this host: all ok", (Object[])new Object[0]);
            }
        }
        return acceptURL;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isRequestURLEqualsExitPageHost(HttpServletRequest req, String logoutURLhost) {
        boolean acceptURL;
        block5: {
            acceptURL = false;
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"about to attempt matching the logout exit url with the domain of the request.", (Object[])new Object[0]);
                }
                StringBuffer requestURLString = req.getRequestURL();
                URL requestURL = new URL(new String(requestURLString));
                String requestURLhost = requestURL.getHost();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" host of the request url is: " + requestURLhost + " and the host of the logout URL is: " + logoutURLhost), (Object[])new Object[0]);
                }
                if (logoutURLhost != null && requestURLhost != null && logoutURLhost.equalsIgnoreCase(requestURLhost)) {
                    acceptURL = true;
                }
            }
            catch (MalformedURLException requestURLString) {
                void e;
                FFDCFilter.processException((Throwable)requestURLString, (String)"com.ibm.ws.webcontainer.security.internal.FormLogoutExtensionProcessor", (String)"374", (Object)((Object)this), (Object[])new Object[]{req, logoutURLhost});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("caught Exception trying to form request URL object: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return acceptURL;
    }

    boolean isLogoutPageMatchDomainNameList(String exitPage, String logoutURLhost, List<String> logoutPageRedirectDomainList) {
        boolean acceptURL = false;
        if (logoutPageRedirectDomainList != null && !logoutPageRedirectDomainList.isEmpty()) {
            for (String domain : logoutPageRedirectDomainList) {
                if (!logoutURLhost.endsWith(domain) && !exitPage.endsWith(domain)) continue;
                acceptURL = true;
                break;
            }
        }
        return acceptURL;
    }
}

