/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resources.internal;

import com.ibm.ws.repository.common.enums.DisplayPolicy;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.resources.internal.GenericRequirement;
import com.ibm.ws.repository.resources.internal.RepositoryResourceImpl;
import com.ibm.ws.repository.resources.writeable.ProductRelatedResourceWritable;
import com.ibm.ws.repository.transport.model.Asset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.resource.Requirement;

public abstract class ProductRelatedResourceImpl
extends RepositoryResourceImpl
implements ProductRelatedResourceWritable {
    public ProductRelatedResourceImpl(RepositoryConnection repoConnection) {
        this(repoConnection, null);
    }

    public ProductRelatedResourceImpl(RepositoryConnection repoConnection, Asset ass) {
        super(repoConnection, ass);
    }

    @Override
    public void setProductId(String productId) {
        this._asset.getWlpInformation().setProductId(productId);
    }

    @Override
    public String getProductId() {
        return this._asset.getWlpInformation().getProductId();
    }

    @Override
    public void setProductEdition(String edition) {
        this._asset.getWlpInformation().setProductEdition(edition);
    }

    @Override
    public String getProductEdition() {
        return this._asset.getWlpInformation().getProductEdition();
    }

    @Override
    public void setProductInstallType(String productInstallType) {
        this._asset.getWlpInformation().setProductInstallType(productInstallType);
    }

    @Override
    public String getProductInstallType() {
        return this._asset.getWlpInformation().getProductInstallType();
    }

    @Override
    public void setProductVersion(String version) {
        this._asset.getWlpInformation().setProductVersion(version);
    }

    @Override
    public String getProductVersion() {
        return this._asset.getWlpInformation().getProductVersion();
    }

    @Override
    public void setWebDisplayPolicy(DisplayPolicy policy) {
        this._asset.getWlpInformation().setWebDisplayPolicy(policy);
    }

    @Override
    public DisplayPolicy getWebDisplayPolicy() {
        if (this._asset.getWlpInformation() == null) {
            return null;
        }
        return this._asset.getWlpInformation().getWebDisplayPolicy();
    }

    @Override
    public void setProvideFeature(Collection<String> provideFeature) {
        this._asset.getWlpInformation().setProvideFeature(provideFeature);
    }

    @Override
    public Collection<String> getProvideFeature() {
        return this._asset.getWlpInformation().getProvideFeature();
    }

    @Override
    public void setRequireFeature(Collection<String> requireFeature) {
        this._asset.getWlpInformation().setRequireFeature(requireFeature);
    }

    @Override
    public Collection<String> getRequireFeature() {
        return this._asset.getWlpInformation().getRequireFeature();
    }

    @Override
    public Collection<Requirement> getGenericRequirements() {
        String requirementStr = this._asset.getWlpInformation().getGenericRequirements();
        HashSet<Requirement> requirements = new HashSet<Requirement>();
        List genMetList = ManifestHeaderProcessor.parseRequirementString((String)requirementStr);
        for (ManifestHeaderProcessor.GenericMetadata genMet : genMetList) {
            GenericRequirement req = new GenericRequirement(genMet);
            requirements.add(req);
        }
        return requirements;
    }

    @Override
    public void setGenericRequirements(String genericRequirements) {
        this._asset.getWlpInformation().setGenericRequirements(genericRequirements);
        List genMetList = ManifestHeaderProcessor.parseRequirementString((String)genericRequirements);
        for (ManifestHeaderProcessor.GenericMetadata genMet : genMetList) {
            if (!genMet.getNamespace().equals("osgi.native")) continue;
            this._asset.getWlpInformation().setWlpInformationVersion(Float.toString(2.0f));
        }
    }

    @Override
    public String getPackagedJava() {
        return this._asset.getWlpInformation().getPackagedJava();
    }

    @Override
    public void setPackagedJava(String packagedJava) {
        this._asset.getWlpInformation().setPackagedJava(packagedJava);
    }

    @Override
    protected void copyFieldsFrom(RepositoryResourceImpl fromResource, boolean includeAttachmentInfo) {
        super.copyFieldsFrom(fromResource, includeAttachmentInfo);
        ProductRelatedResourceImpl prodRes = (ProductRelatedResourceImpl)fromResource;
        this.setProductId(prodRes.getProductId());
        this.setProductEdition(prodRes.getProductEdition());
        this.setProductInstallType(prodRes.getProductInstallType());
        this.setProductVersion(prodRes.getProductVersion());
        this.setWebDisplayPolicy(prodRes.getWebDisplayPolicy());
        this.setProvideFeature(prodRes.getProvideFeature());
        this.setRequireFeature(prodRes.getRequireFeature());
        this.setGenericRequirements(prodRes._asset.getWlpInformation().getGenericRequirements());
        this.setPackagedJava(prodRes.getPackagedJava());
    }
}

