/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.connections;

import com.ibm.ws.repository.exceptions.RepositoryIllegalArgumentException;
import com.ibm.ws.repository.transport.client.LoginInfoClientProxy;
import java.net.URL;

public class RestRepositoryConnectionProxy {
    final URL proxyURL;

    public RestRepositoryConnectionProxy(URL proxyURL) throws RepositoryIllegalArgumentException {
        this.proxyURL = this.setURL(proxyURL);
    }

    public URL getProxyURL() {
        return this.proxyURL;
    }

    public LoginInfoClientProxy getLoginInfoClientProxy() {
        return new LoginInfoClientProxy(this.proxyURL);
    }

    private URL setURL(URL url) throws RepositoryIllegalArgumentException {
        int port = url.getPort();
        if (port == -1) {
            throw new RepositoryIllegalArgumentException("Bad proxy URL", new IllegalArgumentException("Proxy URL does not contain a port"));
        }
        String host = url.getHost();
        if (host.equals("")) {
            throw new RepositoryIllegalArgumentException("Bad proxy URL", new IllegalArgumentException("Proxy URL does not contain a host"));
        }
        return url;
    }

    public boolean isHTTPorHTTPS() {
        return this.proxyURL.getProtocol().equalsIgnoreCase("HTTP") || this.proxyURL.getProtocol().equalsIgnoreCase("HTTPS");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.proxyURL == null ? 0 : this.proxyURL.toString().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RestRepositoryConnectionProxy other = (RestRepositoryConnectionProxy)obj;
        return !(this.proxyURL == null ? other.proxyURL != null : !this.proxyURL.toString().equals(other.proxyURL.toString()));
    }
}

