/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.writer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.Constants;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics.helper.PrometheusBuilder;
import com.ibm.ws.microprofile.metrics.helper.Util;
import com.ibm.ws.microprofile.metrics.writer.OutputWriter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PrometheusMetricWriter
implements OutputWriter {
    private static final TraceComponent tc = Tr.register(PrometheusMetricWriter.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    private final Writer writer;
    private final Locale locale;
    private final Set<String> improperMetricSet = new HashSet<String>();
    static final long serialVersionUID = -5397979326828377413L;

    public PrometheusMetricWriter(Writer writer, Locale locale) {
        this.writer = writer;
        this.locale = locale;
    }

    @Override
    public void write(String registryName, String metricName) throws NoSuchMetricException, NoSuchRegistryException, IOException, EmptyRegistryException {
        StringBuilder builder = new StringBuilder();
        this.writeMetricsAsPrometheus(builder, registryName, metricName);
        this.serialize(builder);
    }

    @Override
    public void write(String registryName) throws NoSuchRegistryException, EmptyRegistryException, IOException {
        StringBuilder builder = new StringBuilder();
        this.writeMetricsAsPrometheus(builder, registryName);
        this.serialize(builder);
    }

    @Override
    @FFDCIgnore(value={EmptyRegistryException.class, NoSuchRegistryException.class})
    public void write() throws IOException {
        StringBuilder builder = new StringBuilder();
        for (String registryName : Constants.REGISTRY_NAMES_LIST) {
            try {
                this.writeMetricsAsPrometheus(builder, registryName);
            }
            catch (NoSuchRegistryException noSuchRegistryException) {
            }
            catch (EmptyRegistryException emptyRegistryException) {}
        }
        this.serialize(builder);
    }

    private void writeMetricsAsPrometheus(StringBuilder builder, String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        this.writeMetricMapAsPrometheus(builder, registryName, Util.getMetricsAsMap(registryName), Util.getMetricsMetadataAsMap(registryName));
    }

    private void writeMetricsAsPrometheus(StringBuilder builder, String registryName, String metricName) throws NoSuchRegistryException, NoSuchMetricException, EmptyRegistryException {
        this.writeMetricMapAsPrometheus(builder, registryName, Util.getMetricsAsMap(registryName, metricName), Util.getMetricsMetadataAsMap(registryName, metricName));
    }

    protected void writeMetricMapAsPrometheus(StringBuilder builder, String registryName, Map<String, Metric> metricMap, Map<String, Metadata> metricMetadataMap) {
        for (Map.Entry<String, Metadata> metadataEntry : metricMetadataMap.entrySet()) {
            String metricName = metadataEntry.getKey();
            String metricNamePrometheus = registryName + ":" + metricName;
            Metadata metricMetadata = metadataEntry.getValue();
            Metric metric = metricMap.get(metricName);
            String description = metricMetadata.getDescription() == null || metricMetadata.getDescription().trim().isEmpty() ? "" : Tr.formatMessage((TraceComponent)tc, (Locale)this.locale, (String)metricMetadata.getDescription(), (Object[])new Object[0]);
            String unit = metricMetadata.getUnit();
            String tags = metricMetadata.getTagsAsString();
            Map.Entry<String, Double> conversionAppendEntry = this.resolveConversionFactorXappendUnitEntry(unit);
            double conversionFactor = conversionAppendEntry.getValue();
            String appendUnit = conversionAppendEntry.getKey();
            if (Counter.class.isInstance(metric)) {
                PrometheusBuilder.buildCounter(builder, metricNamePrometheus, (Counter)metric, description, tags);
                continue;
            }
            if (Gauge.class.isInstance(metric)) {
                PrometheusBuilder.buildGauge(builder, metricNamePrometheus, (Gauge)metric, description, conversionFactor, appendUnit, tags);
                continue;
            }
            if (Timer.class.isInstance(metric)) {
                PrometheusBuilder.buildTimer(builder, metricNamePrometheus, (Timer)metric, description, tags);
                continue;
            }
            if (Histogram.class.isInstance(metric)) {
                PrometheusBuilder.buildHistogram(builder, metricNamePrometheus, (Histogram)metric, description, conversionFactor, tags, appendUnit);
                continue;
            }
            if (Meter.class.isInstance(metric)) {
                PrometheusBuilder.buildMeter(builder, metricNamePrometheus, (Meter)metric, description, tags);
                continue;
            }
            if (this.improperMetricSet.contains(metricName)) continue;
            Tr.event((TraceComponent)tc, (String)("Metric type '" + metric.getClass() + " for " + metricName + " is invalid."), (Object[])new Object[0]);
            this.improperMetricSet.add(metricName);
        }
    }

    protected Map.Entry<String, Double> resolveConversionFactorXappendUnitEntry(String unit) {
        if (unit == null || unit.trim().isEmpty() || unit.equals("none")) {
            return new AbstractMap.SimpleEntry<Object, Double>(null, Double.NaN);
        }
        if (unit.equals("nanoseconds")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 1.0E-9);
        }
        if (unit.equals("microseconds")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 1.0E-6);
        }
        if (unit.equals("seconds")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 1.0);
        }
        if (unit.equals("minutes")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 60.0);
        }
        if (unit.equals("hours")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 3600.0);
        }
        if (unit.equals("days")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 86400.0);
        }
        if (unit.equals("percent")) {
            return new AbstractMap.SimpleEntry<String, Double>("_percent", Double.NaN);
        }
        if (unit.equals("bytes")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 1.0);
        }
        if (unit.equals("kilobytes")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 1024.0);
        }
        if (unit.equals("megabytes")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 1048576.0);
        }
        if (unit.equals("gigabytes")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 1.073741824E9);
        }
        if (unit.equals("kilobits")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 125.0);
        }
        if (unit.equals("megabits")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 125000.0);
        }
        if (unit.equals("gigabits")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 1.25E8);
        }
        if (unit.equals("kibibits")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 128.0);
        }
        if (unit.equals("mebibits")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 131072.0);
        }
        if (unit.equals("gibibits")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 1.342E8);
        }
        if (unit.equals("milliseconds")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 0.001);
        }
        return new AbstractMap.SimpleEntry<String, Double>("_" + unit, Double.NaN);
    }

    private void serialize(StringBuilder builder) throws IOException {
        try {
            this.writer.write(builder.toString());
        }
        finally {
            this.writer.flush();
        }
    }
}

