/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.metatype;

public enum OutputVersion {
    v1("1"),
    v2("2");

    private String value;

    private OutputVersion(String version) {
        this.value = OutputVersion.getNormalizedVersion(version);
    }

    public String toString() {
        return this.value;
    }

    public static OutputVersion getEnum(String version) {
        String normalizedVersion = OutputVersion.getNormalizedVersion(version);
        for (OutputVersion v : OutputVersion.values()) {
            if (!v.value.equals(normalizedVersion)) continue;
            return v;
        }
        throw new IllegalArgumentException(version);
    }

    public static boolean isValid(String version) {
        try {
            OutputVersion.getEnum(version);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return true;
    }

    public static String getNormalizedVersion(String version) {
        if (version == null) {
            version = "1";
        } else if ((version = version.trim()).length() == 0) {
            version = "1";
        }
        if (version.endsWith(".0")) {
            return version.substring(0, version.length() - 2);
        }
        return version;
    }
}

