/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.collective.member.metadata.AdminMetadataParser;
import com.ibm.ws.collective.member.metadata.AdminMetadataPublisher;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AdminMetadataFileMonitor
implements FileMonitor {
    private static final TraceComponent tc = Tr.register(AdminMetadataFileMonitor.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
    private final AdminMetadataParser parser;
    private final AdminMetadataPublisher metadataPublisher;
    private static final String ADMIN_METADATA_FILE_NAME = "admin-metadata.xml";
    private static final String MODIFIED_ACTION = "modified";
    private static final String CREATED_ACTION = "created";
    private static final String DELETED_ACTION = "deleted";
    static final long serialVersionUID = 8314738990793408781L;

    public AdminMetadataFileMonitor(AdminMetadataPublisher metadataPublisher, AdminMetadataParser parser) {
        this.metadataPublisher = metadataPublisher;
        this.parser = parser;
    }

    public ServiceRegistration<FileMonitor> monitorFiles(BundleContext bundleContext, Collection<String> paths, long monitorInterval) {
        Hashtable<String, Object> fileMonitorProps = new Hashtable<String, Object>();
        fileMonitorProps.put("monitor.directories", paths);
        fileMonitorProps.put("monitor.interval", monitorInterval);
        fileMonitorProps.put("monitor.filter", ADMIN_METADATA_FILE_NAME);
        return bundleContext.registerService(FileMonitor.class, (Object)this, fileMonitorProps);
    }

    public void onBaseline(Collection<File> baseline) {
        this.processFiles(baseline, CREATED_ACTION);
    }

    public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        if (!createdFiles.isEmpty()) {
            this.processFiles(createdFiles, CREATED_ACTION);
        }
        if (!deletedFiles.isEmpty()) {
            this.processFiles(deletedFiles, DELETED_ACTION);
        }
        if (!modifiedFiles.isEmpty()) {
            this.processFiles(modifiedFiles, MODIFIED_ACTION);
        }
    }

    private void processFiles(Collection<File> files, String action) {
        for (File file : files) {
            if (file.isFile() && file.getName().equalsIgnoreCase(ADMIN_METADATA_FILE_NAME)) {
                if (action.equals(CREATED_ACTION)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("A new admin-metadata.xml was added " + file.getParentFile().getAbsolutePath()), (Object[])new Object[0]);
                    }
                } else if (action.equals(MODIFIED_ACTION)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("admin-metadata.xml was changed at " + file.getParentFile().getAbsolutePath()), (Object[])new Object[0]);
                    }
                } else if (action.equals(DELETED_ACTION) && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("admin-metadata.xml was removed at " + file.getParentFile().getAbsolutePath()), (Object[])new Object[0]);
                }
            }
            this.updateAdminMetadata(file, action);
        }
    }

    private void updateAdminMetadata(File file, String action) {
        Map<String, Object> adminMetadata;
        if ((action.equals(CREATED_ACTION) || action.equals(MODIFIED_ACTION)) && (adminMetadata = this.parser.parseAdminMetadata(file, "server")) != null) {
            this.metadataPublisher.updateAdminMetadata(adminMetadata);
            this.metadataPublisher.publishAdminMetadata(adminMetadata);
        }
        if (action.equals(DELETED_ACTION)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Remove server admin metadata from repository", (Object[])new Object[0]);
            }
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            this.metadataPublisher.updateAdminMetadata(metadata);
            this.metadataPublisher.publishAdminMetadata(metadata);
        }
    }
}

