/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.app.deploy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.extended.ManifestClassPathHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.util.Collection;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ManifestClassPathUtils {
    static final TraceComponent tc = Tr.register(ManifestClassPathUtils.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
    static final long serialVersionUID = 6200716064634612332L;

    public static String createEntryIdentity(Entry entry) throws UnableToAdaptException {
        String result = "";
        while (entry != null && !entry.getPath().isEmpty()) {
            result = entry.getPath() + result;
            entry = (Entry)entry.getRoot().adapt(Entry.class);
        }
        return result;
    }

    public static void processMFClasspath(Entry jarEntry, List<ContainerInfo> containers, Collection<String> resolved) throws UnableToAdaptException {
        ManifestClassPathUtils.processMFClasspath(jarEntry, containers, resolved, false);
    }

    public static void processMFClasspath(Entry jarEntry, List<ContainerInfo> containers, Collection<String> resolved, boolean addRoot) throws UnableToAdaptException {
        Container jarContainer;
        if (jarEntry != null && (jarContainer = (Container)jarEntry.adapt(Container.class)) != null) {
            ManifestClassPathHelper.processMFClasspath((Entry)jarEntry, (Container)jarContainer, containers, resolved, (boolean)addRoot);
        }
    }

    public static void addCompleteJarEntryUrls(List<ContainerInfo> containers, Entry jarEntry, Collection<String> resolved) throws UnableToAdaptException {
        String entryIdentity = ManifestClassPathUtils.createEntryIdentity(jarEntry);
        if (!entryIdentity.isEmpty() && !resolved.contains(entryIdentity)) {
            resolved.add(entryIdentity);
            ManifestClassPathUtils.processMFClasspath(jarEntry, containers, resolved);
        }
    }
}

