/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.PKCS12Utils;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class FriendlyName
extends PKCS9DerObject
implements Cloneable {
    private String name;
    private byte[] bmpName;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.FriendlyName";
    private volatile int cachedHashVal = 0;

    public FriendlyName(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "FriendlyName", (Object)der);
            debug.exit(16384L, className, "FriendlyName");
        }
    }

    public FriendlyName(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "FriendlyName", der, provider);
            debug.exit(16384L, className, "FriendlyName");
        }
    }

    public FriendlyName(String name) {
        this.name = name;
        this.bmpName = PKCS12Utils.ascii2bmp(name.toCharArray());
        if (debug != null) {
            debug.entry(16384L, (Object)className, "FriendlyName", name);
            debug.exit(16384L, className, "FriendlyName");
        }
    }

    public FriendlyName(String name, String provider) {
        super(provider);
        this.name = name;
        this.bmpName = PKCS12Utils.ascii2bmp(name.toCharArray());
        if (debug != null) {
            debug.entry(16384L, className, "FriendlyName", name, provider);
            debug.exit(16384L, className, "FriendlyName");
        }
    }

    public FriendlyName(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "FriendlyName", filename, new Boolean(base64));
            debug.exit(16384L, className, "FriendlyName");
        }
    }

    public FriendlyName(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "FriendlyName", parms);
            debug.exit(16384L, className, "FriendlyName");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            FriendlyName result = new FriendlyName(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exit(16384L, className, "clone");
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", obj);
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof FriendlyName) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((FriendlyName)obj)));
            }
            return this.equals((FriendlyName)obj);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            this.cachedHashVal = 17;
            for (int i2 = 0; i2 < this.bmpName.length; ++i2) {
                this.cachedHashVal = 37 * this.cachedHashVal + this.bmpName[i2];
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.FRIENDLY_NAME_OID);
        }
        return PKCSOID.FRIENDLY_NAME_OID;
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.bmpName == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Friendly Name not specified.");
            }
            throw new IOException("Friendly Name not specified.");
        }
        DerOutputStream tmpout = new DerOutputStream();
        DerOutputStream tmpout2 = new DerOutputStream();
        DerOutputStream tmpout3 = new DerOutputStream();
        tmpout.putOID(this.getObjectIdentifier());
        tmpout2.putBMPString(this.bmpName);
        tmpout.write((byte)49, tmpout2.toByteArray());
        tmpout3.write((byte)48, tmpout.toByteArray());
        os.write(tmpout3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String getFriendlyName() {
        if (debug != null) {
            debug.entry(16384L, className, "getFriendlyName");
        }
        try {
            if (this.name != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getFriendlyName", this.name);
                }
                return this.name;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getFriendlyName", PKCS12Utils.bmp2string(this.bmpName));
            }
            return PKCS12Utils.bmp2string(this.bmpName);
        }
        catch (IllegalArgumentException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "getFriendlyName", e2);
                debug.exit(16384L, (Object)className, "getFriendlyName", "Invalid Friendly Name");
            }
            return "Invalid Friendly Name";
        }
    }

    @Override
    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getFriendlyName());
        }
        return this.getFriendlyName();
    }

    @Override
    public boolean isTagValid(byte tag) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(tag));
        }
        if (tag == 30) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    @Override
    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingeValued", new Boolean(true));
        }
        return true;
    }

    @Override
    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "FriendlyName");
        }
        return "FriendlyName";
    }

    @Override
    public String toString() {
        String name = this.getFriendlyName();
        String out = "PKCS9 FriendlyName:\r\n";
        out = out + "\t" + name;
        return out;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        super.decode(encoding);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
            debug.exit(16384L, className, "decode");
        }
        DerValue[] elems = null;
        if (encoding.getTag() == 48) {
            DerInputStream derIn = new DerInputStream(encoding.toByteArray());
            DerValue[] val = derIn.getSequence(2);
            elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        } else {
            elems = new DerInputStream(encoding.toByteArray()).getSet(1);
        }
        this.bmpName = new DerInputStream(elems[0].toByteArray()).getBMPString();
        try {
            this.name = PKCS12Utils.bmp2string(this.bmpName);
        }
        catch (IllegalArgumentException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "decode", e2);
                debug.text(16384L, className, "decode", "Invalid BMP string");
            }
            throw new IOException("Invalid BMP string");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(FriendlyName other) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        if (this.bmpName.length != other.bmpName.length) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        for (int i2 = 0; i2 < this.bmpName.length; ++i2) {
            if (this.bmpName[i2] == other.bmpName[i2]) continue;
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

