/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.CertOrEncCert;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.EncryptedValue;
import com.ibm.security.crmf.PKIPublicationInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;

public final class CertifiedKeyPair
extends CMPDerObject {
    private CertOrEncCert certOrEncCert;
    private EncryptedValue privateKey;
    private PKIPublicationInfo publicationInfo;
    private static final byte TAG_PRIVATE_KEY = 0;
    private static final byte TAG_PUBLICATION_INFO = 1;

    public CertifiedKeyPair(CertOrEncCert certOrEncCert, EncryptedValue encryptedValue, PKIPublicationInfo pKIPublicationInfo) {
        if (certOrEncCert == null) {
            throw new IllegalArgumentException("CertifiedKeyPair error, certificate not specified");
        }
        this.certOrEncCert = certOrEncCert;
        this.privateKey = encryptedValue;
        this.publicationInfo = pKIPublicationInfo;
    }

    public CertifiedKeyPair(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new CertifiedKeyPair(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("CertifiedKeyPair parsing error, not a SEQUENCE");
        }
        this.certOrEncCert = null;
        this.privateKey = null;
        this.publicationInfo = null;
        if (derValue.getData().available() == 0) {
            throw new IOException("CertifiedKeyPair parsing error, missing data");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.certOrEncCert = new CertOrEncCert(derValue2.toByteArray());
        if (derValue.getData().available() == 0) {
            return;
        }
        derValue2 = derValue.getData().getDerValue();
        if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
            this.privateKey = new EncryptedValue(derValue2.getData().getDerValue().toByteArray());
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
            } else {
                return;
            }
        }
        if (!derValue2.isContextSpecific((byte)1) || !derValue2.isConstructed()) {
            throw new IOException("CertifiedKeyPair parsing error, invalid tag");
        }
        this.publicationInfo = new PKIPublicationInfo(derValue2.getData().getDerValue().toByteArray());
        if (derValue.getData().available() != 0) {
            throw new IOException("CertifiedKeyPair parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.certOrEncCert == null) {
            throw new IOException("CertifiedKeyPair encoding error, certificate not specified");
        }
        this.certOrEncCert.encode(derOutputStream2);
        if (this.privateKey != null) {
            derOutputStream = new DerOutputStream();
            this.privateKey.encode(derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        }
        if (this.publicationInfo != null) {
            derOutputStream = new DerOutputStream();
            this.publicationInfo.encode(derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        }
        derOutputStream3.write((byte)48, derOutputStream2);
        outputStream.write(derOutputStream3.toByteArray());
    }

    public boolean equals(CertifiedKeyPair certifiedKeyPair) {
        DerValue derValue;
        DerValue derValue2;
        if (certifiedKeyPair == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            certifiedKeyPair.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CertifiedKeyPair) {
            return this.equals((CertifiedKeyPair)object);
        }
        return false;
    }

    public CertOrEncCert getCertOrEncCert() {
        return (CertOrEncCert)this.certOrEncCert.clone();
    }

    public EncryptedValue getPrivateKey() {
        if (this.privateKey == null) {
            return null;
        }
        return (EncryptedValue)this.privateKey.clone();
    }

    public PKIPublicationInfo getPublicationInfo() {
        if (this.publicationInfo == null) {
            return null;
        }
        return (PKIPublicationInfo)this.publicationInfo.clone();
    }

    public String toString() {
        String string = "CertifiedKeyPair:";
        string = String.valueOf(string) + "\r\n\tcertificate: " + this.certOrEncCert.toString();
        if (this.privateKey != null) {
            string = String.valueOf(string) + "\r\n\tprivate key: " + this.privateKey.toString();
        }
        if (this.publicationInfo != null) {
            string = String.valueOf(string) + "\r\n\tpublication info: " + this.publicationInfo.toString();
        }
        return string;
    }
}

