/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.fmt;

import com.ibm.security.certclient.base.PkAttr;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkEvent;
import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkInitRepEvent;
import com.ibm.security.certclient.base.PkInitReqEvent;
import com.ibm.security.certclient.base.PkIoException;
import com.ibm.security.certclient.base.PkKupdRepEvent;
import com.ibm.security.certclient.base.PkKupdReqEvent;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.base.PkSecnRepEvent;
import com.ibm.security.certclient.base.PkSecnReqEvent;
import com.ibm.security.certclient.base.PkXcerRepEvent;
import com.ibm.security.certclient.base.PkXcerReqEvent;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcs9.PKCS9;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.UnresolvedAttribute;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;

public class PkPkcsEventFormatter
extends PkEventFormatter
implements PkConstants {
    private static final ObjectIdentifier EXT_OID = PkPkcsEventFormatter.getOID();

    private static final ObjectIdentifier getOID() {
        try {
            return new ObjectIdentifier("1.3.6.1.4.1.311.2.1.14");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public PkEvent readEvent(Object source, InputStream is, PkReqEvent req) throws PkException, IOException {
        DerValue der = new DerValue(is);
        try {
            return this.readCertReqEvent(source, der);
        }
        catch (IOException e2) {
            return this.readCertRepEvent(source, der, req);
        }
    }

    @Override
    public void writeException(Exception e2, OutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeCertReq(PkCertReqEvent req, OutputStream out) throws IOException {
        CertificationRequest cr;
        PKCSAttributes attrs = new PKCSAttributes();
        CertificateExtensions certExt = null;
        ArrayList<DerValue> v2 = new ArrayList<DerValue>();
        PkAttrs.Iter i2 = req.getAttrs().iterator();
        while (i2.hasNext()) {
            PkAttr a2 = (PkAttr)i2.next();
            if (!a2.isApproved() || !a2.isApplied()) continue;
            if (a2.isNameOid()) {
                attrs = attrs.addAttribute(new PKCSAttribute(new ObjectIdentifier(a2.getName()), a2.getValue()));
                continue;
            }
            if (!a2.getName().startsWith("x509.info.extensions.")) continue;
            if (certExt == null) {
                certExt = new CertificateExtensions();
            }
            ObjectIdentifier oid = OIDMap.getOID(a2.getName());
            CertAttrSet certAttrSet = (CertAttrSet)a2.getValue();
            DerOutputStream tempOut = new DerOutputStream();
            try {
                certAttrSet.encode(tempOut);
                DerValue dv = new DerValue(tempOut.toByteArray());
                v2.add(dv);
            }
            catch (CertificateException e2) {
                throw new PkIoException(e2);
            }
        }
        if (v2.size() > 0) {
            DerValue[] dvs = new DerValue[v2.size()];
            Object[] objs = v2.toArray();
            for (int i3 = 0; i3 < objs.length; ++i3) {
                dvs[i3] = (DerValue)objs[i3];
            }
            DerOutputStream attrOut = new DerOutputStream();
            attrOut.putSequence(dvs);
            DerOutputStream attrOut2 = new DerOutputStream();
            attrOut2.write((byte)49, attrOut);
            attrs = attrs.addAttribute(new PKCSAttribute(new UnresolvedAttribute(EXT_OID, attrOut2.toByteArray())));
        }
        PkAttrs ats = req.getAttrs();
        String algo = ((AlgorithmId)ats.getValue("x509.info.algorithmID")).getName();
        algo = algo.substring(0, algo.indexOf("with"));
        try {
            cr = new CertificationRequest(new CertificationRequestInfo((X500Name)ats.getValue("x509.info.subject"), (PublicKey)ats.getValue("x509.info.key"), attrs), (PrivateKey)ats.getValue("cert.oper.privateKey"), algo);
        }
        catch (PKCSException e3) {
            throw new PkIoException(e3);
        }
        catch (NoSuchAlgorithmException e4) {
            throw new PkIoException(e4);
        }
        cr.encode(out);
    }

    @Override
    public void writeCertRep(PkCertRepEvent rep, OutputStream out) throws IOException {
        new ContentInfo(new SignedData(new Certificate[]{rep.getCert()}, null)).encode(out);
    }

    protected PkCertReqEvent readCertReqEvent(Object source, DerValue der) throws IOException {
        CertificationRequest msg = new CertificationRequest(der.toByteArray());
        return new PkCertReqEvent(source, msg, this.getAttrs(msg));
    }

    protected PkCertRepEvent readCertRepEvent(Object source, DerValue der, PkReqEvent req) throws IOException {
        ContentInfo contentInfo = new ContentInfo(der.toByteArray());
        SignedData innerSignedData = (SignedData)contentInfo.getContent();
        Certificate[] certs = innerSignedData.getCertificates();
        if (req instanceof PkInitReqEvent) {
            return new PkInitRepEvent(source, contentInfo, req, certs[0]);
        }
        if (req instanceof PkSecnReqEvent) {
            return new PkSecnRepEvent(source, contentInfo, req, certs[0]);
        }
        if (req instanceof PkXcerReqEvent) {
            return new PkXcerRepEvent(source, contentInfo, req, certs[0]);
        }
        if (req instanceof PkKupdReqEvent) {
            return new PkKupdRepEvent(source, contentInfo, req, certs[0]);
        }
        throw new PkIoException(PkNLSConstants.PKCSEVENT_BAD_REQUEST);
    }

    private PkAttrs getAttrs(CertificationRequest cr) throws IOException {
        CertificationRequestInfo cri = cr.getCertRequestInfo();
        PkAttrs result = new PkAttrs();
        PkPkcsEventFormatter.add(result, "x509.info.subject", cri.getSubjectName());
        try {
            PkPkcsEventFormatter.add(result, "x509.info.key", cri.getSubjectPublicKeyInfo());
        }
        catch (InvalidKeyException e2) {
            throw new PkIoException(e2);
        }
        PKCSAttribute[] attrs = cri.getAttributes().getAttributes();
        for (int i2 = 0; i2 < attrs.length; ++i2) {
            ObjectIdentifier oid = attrs[i2].getAttributeId();
            String name = PKCS9.getName(oid);
            if (name != null) {
                PkPkcsEventFormatter.add(result, name, attrs[i2].getAttributeValue());
                continue;
            }
            if (!oid.equals(EXT_OID)) continue;
            DerInputStream derIn = new DerInputStream((byte[])attrs[i2].getAttributeValue());
            DerValue[] val = derIn.getSet(1);
            DerInputStream dis = new DerInputStream(val[0].toByteArray());
            CertificateExtensions exts = new CertificateExtensions(dis);
            Enumeration xenum = exts.getElements();
            while (xenum.hasMoreElements()) {
                Object obj = xenum.nextElement();
                String extName = !(obj instanceof CertAttrSet) ? ((Extension)obj).getExtensionId().toString() : "x509.info.extensions." + ((CertAttrSet)obj).getName();
                PkPkcsEventFormatter.add(result, extName, obj);
            }
        }
        return result;
    }

    private static void add(PkAttrs attrs, String name, Object value) {
        attrs.add(name, 1, value);
    }
}

