/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.util.Date;

public abstract class PKCS11Object {
    public static final int CLASS = 0;
    public static final int TOKEN = 1;
    public static final int PRIVATE = 2;
    public static final int LABEL = 3;
    public static final int APPLICATION = 16;
    public static final int VALUE = 17;
    public static final int OBJECT_ID = 18;
    public static final int CERTIFICATE_TYPE = 128;
    public static final int ISSUER = 129;
    public static final int SERIAL_NUMBER = 130;
    public static final int AC_ISSUER = 131;
    public static final int OWNER = 132;
    public static final int ATTR_TYPES = 133;
    public static final int TRUSTED = 134;
    public static final int KEY_TYPE = 256;
    public static final int SUBJECT = 257;
    public static final int ID = 258;
    public static final int SENSITIVE = 259;
    public static final int ENCRYPT = 260;
    public static final int DECRYPT = 261;
    public static final int WRAP = 262;
    public static final int UNWRAP = 263;
    public static final int SIGN = 264;
    public static final int SIGN_RECOVER = 265;
    public static final int VERIFY = 266;
    public static final int VERIFY_RECOVER = 267;
    public static final int DERIVE = 268;
    public static final int START_DATE = 272;
    public static final int END_DATE = 273;
    public static final int MODULUS = 288;
    public static final int MODULUS_BITS = 289;
    public static final int PUBLIC_EXPONENT = 290;
    public static final int PRIVATE_EXPONENT = 291;
    public static final int PRIME_1 = 292;
    public static final int PRIME_2 = 293;
    public static final int EXPONENT_1 = 294;
    public static final int EXPONENT_2 = 295;
    public static final int COEFFICIENT = 296;
    public static final int PRIME = 304;
    public static final int SUBPRIME = 305;
    public static final int BASE = 306;
    public static final int PRIME_BITS = 307;
    public static final int SUBPRIME_BITS = 308;
    public static final int SUB_PRIME_BITS = 308;
    public static final int VALUE_BITS = 352;
    public static final int VALUE_LEN = 353;
    public static final int EXTRACTABLE = 354;
    public static final int LOCAL = 355;
    public static final int NEVER_EXTRACTABLE = 356;
    public static final int ALWAYS_SENSITIVE = 357;
    public static final int KEY_GEN_MECHANISM = 358;
    public static final int MODIFIABLE = 368;
    public static final int ECDSA_PARAMS = 384;
    public static final int EC_PARAMS = 384;
    public static final int EC_POINT = 385;
    public static final int SECONDARY_AUTH = 512;
    public static final int AUTH_PIN_FLAGS = 513;
    public static final int HW_FEATURE_TYPE = 768;
    public static final int RESET_ON_INIT = 769;
    public static final int HAS_RESET = 770;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int INVALID = -1;
    public static final Integer DATA = new Integer(0);
    public static final Integer CERTIFICATE = new Integer(1);
    public static final Integer PUBLIC_KEY = new Integer(2);
    public static final Integer PRIVATE_KEY = new Integer(3);
    public static final Integer SECRET_KEY = new Integer(4);
    public static final Integer HW_FEATURE = new Integer(5);
    public static final Integer DOMAIN_PARAMETERS = new Integer(6);
    public static final Integer MONOTONIC_COUNTER = new Integer(1);
    public static final Integer CLOCK = new Integer(2);
    public static final Integer RSA = new Integer(0);
    public static final Integer DSA = new Integer(1);
    public static final Integer DH = new Integer(2);
    public static final Integer ECDSA = new Integer(3);
    public static final Integer EC = new Integer(3);
    public static final Integer MAYFLY = new Integer(4);
    public static final Integer X9_42_DH = new Integer(4);
    public static final Integer KEA = new Integer(5);
    public static final Integer GENERIC_SECRET = new Integer(16);
    public static final Integer RC2 = new Integer(17);
    public static final Integer RC4 = new Integer(18);
    public static final Integer DES = new Integer(19);
    public static final Integer DES2 = new Integer(20);
    public static final Integer DES3 = new Integer(21);
    public static final Integer CAST = new Integer(22);
    public static final Integer CAST3 = new Integer(23);
    public static final Integer CAST5 = new Integer(24);
    public static final Integer CAST128 = new Integer(24);
    public static final Integer RC5 = new Integer(25);
    public static final Integer IDEA = new Integer(26);
    public static final Integer SKIPJACK = new Integer(27);
    public static final Integer BATON = new Integer(28);
    public static final Integer JUNIPER = new Integer(29);
    public static final Integer CDMF = new Integer(30);
    public static final Integer AES = new Integer(31);
    public static final Integer BLOWFISH = new Integer(32);
    public static final Integer TWOFISH = new Integer(33);
    public static final Integer X_509 = new Integer(0);
    public static final Integer X_509_ATTR_CERT = new Integer(1);
    public static final Boolean TRUE = Boolean.TRUE;
    public static final Boolean FALSE = Boolean.FALSE;
    private static final String[] objclassNames = new String[]{"DATA", "CERTIFICATE", "PUBLIC_KEY", "PRIVATE_KEY", "SECRET_KEY", "HW_FEATURE", "DOMAIN_PARAMETERS"};
    private static final int[] attrtypeList = new int[]{0, 1, 2, 3, 16, 768, 18, 17, 128, 129, 130, 131, 132, 133, 134, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 272, 273, 288, 289, 290, 291, 292, 293, 294, 295, 296, 304, 305, 306, 307, 308, 352, 353, 354, 355, 356, 357, 358, 368, 384, 385, 512, 513, 769, 770};
    private static final String[] attrtypeNames = new String[]{"CLASS", "TOKEN", "PRIVATE", "LABEL", "APPLICATION", "HW_FEATURE_TYPE", "OBJECT_ID", "VALUE", "CERTIFICATE_TYPE", "ISSUER", "SERIAL_NUMBER", "AC_ISSUER", "OWNER", "ATTR_TYPES", "TRUSTED", "KEY_TYPE", "SUBJECT", "ID", "SENSITIVE", "ENCRYPT", "DECRYPT", "WRAP", "UNWRAP", "SIGN", "SIGN_RECOVER", "VERIFY", "VERIFY_RECOVER", "DERIVE", "START_DATE", "END_DATE", "MODULUS", "MODULUS_BITS", "PUBLIC_EXPONENT", "PRIVATE_EXPONENT", "PRIME_1", "PRIME_2", "EXPONENT_1", "EXPONENT_2", "COEFFICIENT", "PRIME", "SUBPRIME", "BASE", "PRIME_BITS", "SUBPRIME_BITS", "VALUE_BITS", "VALUE_LEN", "EXTRACTABLE", "LOCAL", "NEVER_EXTRACTABLE", "ALWAYS_SENSITIVE", "KEY_GEN_MECHANISM", "MODIFIABLE", "EC_PARAMS", "EC_POINT", "SECONDARY_AUTH", "AUTH_PIN_FLAGS", "RESET_ON_INIT", "HAS_RESET"};
    private static final Class[] attrValueClasses = new Class[]{Integer.class, Boolean.class, Boolean.class, String.class, String.class, Integer.class, byte[].class, byte[].class, Integer.class, byte[].class, byte[].class, byte[].class, byte[].class, byte[].class, Boolean.class, Integer.class, byte[].class, byte[].class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Date.class, Date.class, BigInteger.class, Integer.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, Integer.class, Integer.class, Integer.class, Integer.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Integer.class, Boolean.class, byte[].class, byte[].class, Boolean.class, Integer.class, Boolean.class, Boolean.class};
    private static final Integer[] keytypeList = new Integer[]{RSA, DSA, DH, EC, ECDSA, X9_42_DH, MAYFLY, KEA, GENERIC_SECRET, RC2, RC4, DES, DES2, DES3, CAST, CAST3, CAST128, CAST5, RC5, IDEA, SKIPJACK, BATON, JUNIPER, CDMF, AES, BLOWFISH, TWOFISH};
    private static final String[] keytypeNames = new String[]{"RSA", "DSA", "DH", "EC", "ECDSA", "X9_42_DH", "MAYFLY", "KEA", "GENERIC_SECRET", "RC2", "RC4", "DES", "DES2", "DES3", "CAST", "CAST3", "CAST128", "CAST5", "RC5", "IDEA", "SKIPJACK", "BATON", "JUNIPER", "CDMF", "AES", "BLOWFISH", "TWOFISH"};
    private static final int[] pinflagList = new int[]{65536, 131072, 262144, 524288};
    static final String[] pinflagNames = new String[]{"USER_PIN_COUNT_LOW", "USER_PIN_FINAL_TRY", "USER_PIN_LOCKED", "USER_PIN_TO_BE_CHANGED"};

    protected PKCS11Object() {
    }

    public abstract PKCS11Session getSession() throws PKCS11Exception;

    public abstract PKCS11Object copy(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void destroy() throws PKCS11Exception;

    public abstract int size() throws PKCS11Exception;

    public Object[] getAttributeValues(int[] types) throws PKCS11Exception {
        Object[] objs = new Object[types.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            objs[i2] = this.getAttributeValue(types[i2]);
        }
        return objs;
    }

    public abstract Object getAttributeValue(int var1) throws PKCS11Exception;

    public boolean getBoolAttributeValue(int type) throws PKCS11Exception {
        if (PKCS11Object.valueClass(type) != Boolean.class) {
            throw new PKCS11Exception(18);
        }
        return (Boolean)this.getAttributeValue(type);
    }

    public int getIntAttributeValue(int type) throws PKCS11Exception {
        if (PKCS11Object.valueClass(type) != Integer.class) {
            throw new PKCS11Exception(18);
        }
        return (Integer)this.getAttributeValue(type);
    }

    public String getStringAttributeValue(int type) throws PKCS11Exception {
        if (PKCS11Object.valueClass(type) != String.class) {
            throw new PKCS11Exception(18);
        }
        return (String)this.getAttributeValue(type);
    }

    public byte[] getByteArrayAttributeValue(int type) throws PKCS11Exception {
        if (PKCS11Object.valueClass(type) != byte[].class) {
            throw new PKCS11Exception(18);
        }
        return (byte[])this.getAttributeValue(type);
    }

    public Date getDateAttributeValue(int type) throws PKCS11Exception {
        if (PKCS11Object.valueClass(type) != Date.class) {
            throw new PKCS11Exception(18);
        }
        return (Date)this.getAttributeValue(type);
    }

    public BigInteger getBigIntegerAttributeValue(int type) throws PKCS11Exception {
        if (PKCS11Object.valueClass(type) != BigInteger.class) {
            throw new PKCS11Exception(18);
        }
        return (BigInteger)this.getAttributeValue(type);
    }

    public abstract void setAttributeValues(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void setAttributeValue(int var1, Object var2) throws PKCS11Exception;

    public void setBoolAttributeValue(int type, boolean value) throws PKCS11Exception {
        if (PKCS11Object.valueClass(type) != Boolean.class) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(type, new Boolean(value));
    }

    public void setIntAttributeValue(int type, int value) throws PKCS11Exception {
        if (PKCS11Object.valueClass(type) != Integer.class) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(type, new Integer(value));
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder(512);
        String pad = "                    ";
        b2.append("object:\n");
        for (int i2 = 0; i2 < attrtypeList.length; ++i2) {
            String valstr;
            String typestr;
            block5: {
                int type = attrtypeList[i2];
                typestr = PKCS11Object.typeToString(type);
                valstr = null;
                try {
                    Object val = this.getAttributeValue(type);
                    valstr = PKCS11Object.attrToString(type, val);
                }
                catch (PKCS11Exception e2) {
                    if (e2.getCode() != 17) break block5;
                    valstr = "(ATTRIBUTE_SENSITIVE)";
                }
            }
            if (valstr == null) continue;
            b2.append("\t").append(typestr).append(":");
            b2.append(pad.substring(typestr.length()));
            b2.append(valstr).append("\n");
        }
        try {
            int size = this.size();
            b2.append("\tSIZE:").append(pad.substring(4)).append(size).append("\n");
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        return b2.toString();
    }

    public static Class valueClass(int type) {
        for (int i2 = 0; i2 < attrtypeList.length; ++i2) {
            if (attrtypeList[i2] != type) continue;
            return attrValueClasses[i2];
        }
        return null;
    }

    public static String typeToString(int type) {
        for (int i2 = 0; i2 < attrtypeList.length; ++i2) {
            if (attrtypeList[i2] != type) continue;
            return attrtypeNames[i2];
        }
        return "0x" + Integer.toString(type, 16);
    }

    public static String classToString(Integer clazz) {
        int c2 = clazz;
        if (c2 >= 0 && c2 < objclassNames.length) {
            return objclassNames[c2];
        }
        return "0x" + Integer.toString(c2, 16);
    }

    public static String keyToString(Integer keytype) {
        int k2 = keytype;
        for (int i2 = 0; i2 < keytypeList.length; ++i2) {
            if (keytypeList[i2] != k2) continue;
            return keytypeNames[i2];
        }
        return "0x" + Integer.toHexString(k2);
    }

    public static String certToString(Integer cert) {
        if (cert.equals(X_509)) {
            return "X_509";
        }
        if (cert.equals(X_509_ATTR_CERT)) {
            return "X_509_ATTR_CERT";
        }
        return "0x" + Integer.toHexString(cert);
    }

    public static String hwfeatureToString(Integer feature) {
        if (feature.equals(MONOTONIC_COUNTER)) {
            return "MONOTONIC_COUNTER";
        }
        if (feature.equals(CLOCK)) {
            return "CLOCK";
        }
        return "0x" + Integer.toHexString(feature);
    }

    public static String pinflagsToString(Integer pinflags) {
        return PKCS11.flagsToString(pinflags, pinflagList, pinflagNames, " | ");
    }

    public static String attrToString(int type, Object value) {
        if (value == null) {
            return "null";
        }
        switch (type) {
            case 0: {
                return PKCS11Object.classToString((Integer)value);
            }
            case 256: {
                return PKCS11Object.keyToString((Integer)value);
            }
            case 128: {
                return PKCS11Object.certToString((Integer)value);
            }
            case 513: {
                return PKCS11Object.pinflagsToString((Integer)value);
            }
            case 768: {
                return PKCS11Object.hwfeatureToString((Integer)value);
            }
            case 17: 
            case 18: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 257: 
            case 258: {
                return PKCS11Object.bytesToString((byte[])value, 10);
            }
            case 288: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 304: 
            case 305: 
            case 306: {
                return "0x" + ((BigInteger)value).toString(16);
            }
        }
        return value.toString();
    }

    public static String bytesToString(byte[] data, int maxlen) {
        if (data == null) {
            return "null";
        }
        StringBuilder out = new StringBuilder(256);
        int n2 = 0;
        int i2 = 0;
        while (i2 < data.length) {
            if (maxlen != 0 && i2 > maxlen) {
                out.append(" ... (").append(data.length).append(" bytes)");
                break;
            }
            if (n2 == 16) {
                out.append('\n');
                n2 = 0;
            }
            if (n2 > 0) {
                out.append(' ');
            }
            out.append("0123456789abcdef".charAt(data[i2] >> 4 & 0xF));
            out.append("0123456789abcdef".charAt(data[i2] & 0xF));
            ++i2;
            ++n2;
        }
        return out.toString();
    }

    public static void main(String[] args) {
        StringBuilder sb2 = new StringBuilder(1024);
        sb2.append("  * <TABLE BORDER RULES=ALL CELLPADDING=3>\n");
        sb2.append("  * <TR> <TH> attribute type     <TH> object type\n");
        for (int i2 = 0; i2 < attrtypeList.length; ++i2) {
            String cn = attrValueClasses[i2].getName();
            cn = cn.endsWith("[B") ? "byte[]" : cn.substring(cn.lastIndexOf(46) + 1);
            sb2.append("  * <TR> <TD> <CODE>").append(attrtypeNames[i2]);
            sb2.append("</CODE> <TD> <CODE>").append(cn).append("</CODE>\n");
        }
        sb2.append("  * </TABLE> <P>\n");
        System.out.println(sb2.toString());
    }
}

